/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public abstract class AbstractSensorBuilder<C extends MetricsBuilderContext, S> {
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    protected final Metrics metrics;
    protected final C context;

    public AbstractSensorBuilder(Metrics metrics, C context) {
        this.metrics = metrics;
        this.context = context;
    }

    public abstract S build();

    protected abstract String sensorSuffix(String var1, C var2);

    protected abstract Map<String, ? extends AbstractSensorCreator> sensorCreators();

    public Map<String, Sensor> getOrCreateSuffixedSensors() {
        HashMap<String, String> sensorsToFind = new HashMap<String, String>();
        Map<String, AbstractSensorCreator> sensorCreators = this.sensorCreators();
        for (String name : sensorCreators.keySet()) {
            sensorsToFind.put(name, name + this.sensorSuffix(name, this.context));
        }
        return this.getOrCreateSensors(sensorsToFind, sensorCreators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<T, Sensor> getOrCreateSensors(Map<T, String> sensorsToFind, Map<T, ? extends AbstractSensorCreator> sensorCreators) {
        Map<T, Sensor> sensors;
        LOCK.readLock().lock();
        try {
            sensors = this.findSensors(this.metrics, sensorsToFind);
            sensorsToFind.keySet().removeAll(sensors.keySet());
        }
        finally {
            LOCK.readLock().unlock();
        }
        if (!sensorsToFind.isEmpty()) {
            LOCK.writeLock().lock();
            try {
                Map<T, Sensor> existingSensors = this.findSensors(this.metrics, sensorsToFind);
                sensorsToFind.keySet().removeAll(existingSensors.keySet());
                sensors.putAll(existingSensors);
                for (Map.Entry<T, String> entry : sensorsToFind.entrySet()) {
                    T key = entry.getKey();
                    String sensorName = entry.getValue();
                    sensors.put(key, this.createSensor(sensorCreators, key, sensorName));
                }
            }
            finally {
                LOCK.writeLock().unlock();
            }
        }
        return sensors;
    }

    protected abstract <T> Sensor createSensor(Map<T, ? extends AbstractSensorCreator> var1, T var2, String var3);

    private <T> Map<T, Sensor> findSensors(Metrics metrics, Map<T, String> sensorNames) {
        HashMap<T, Sensor> existingSensors = new HashMap<T, Sensor>();
        for (Map.Entry<T, String> entry : sensorNames.entrySet()) {
            Sensor sensor = metrics.getSensor(entry.getValue());
            if (sensor == null) continue;
            existingSensors.put(entry.getKey(), sensor);
        }
        return existingSensors;
    }
}

