/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.kafka.common.network.ProxyTlvType;

public class FqdnTemplateVariable {
    private static final HashSet<FqdnTemplateVariable> REGISTERED_TEMPLATE_VARIABLES = new HashSet();
    public static final FqdnTemplateVariable TARGET_TEMPL_VAR = FqdnTemplateVariable.createAndRegisterVariable("$targetId", ValueSource.SERVICE_PROVISION);
    public static final FqdnTemplateVariable ZONE_ID_TEMPL_VAR = FqdnTemplateVariable.createAndRegisterVariable("$zoneId", ValueSource.SERVICE_PROVISION);
    public static final FqdnTemplateVariable REGION_TEMPL_VAR = FqdnTemplateVariable.createAndRegisterVariable("$region", ValueSource.SERVICE_PROVISION);
    public static final FqdnTemplateVariable CLOUD_TEMPL_VAR = FqdnTemplateVariable.createAndRegisterVariable("$cloud", ValueSource.SERVICE_PROVISION);
    public static final FqdnTemplateVariable SERVICE_ID_TEMPL_VAR = FqdnTemplateVariable.createAndRegisterVariable("$svcId", ValueSource.RUNTIME);
    public static final FqdnTemplateVariableWithValueInPPV2Header ACCESS_POINT_TEMPL_VAR = FqdnTemplateVariableWithValueInPPV2Header.createAndRegisterVariable("$accessPointId", ProxyTlvType.ACCESS_POINT_ID);
    protected final String variable;
    protected final ValueSource valueSource;

    private FqdnTemplateVariable(String variable, ValueSource valueSource) {
        this.variable = variable;
        this.valueSource = valueSource;
    }

    public static FqdnTemplateVariable createAndRegisterVariable(String variable, ValueSource valueSource) {
        Objects.requireNonNull(variable);
        Objects.requireNonNull(valueSource);
        if (valueSource == ValueSource.PPV2_HEADER) {
            throw new IllegalArgumentException("Creating template variable with PPV2_HEADER value source is not supported through this method.");
        }
        FqdnTemplateVariable var = new FqdnTemplateVariable(variable, valueSource);
        REGISTERED_TEMPLATE_VARIABLES.add(var);
        return var;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FqdnTemplateVariable that = (FqdnTemplateVariable)o;
        return this.variable.equals(that.variable);
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", FqdnTemplateVariable.class.getSimpleName() + "[", "]").add("variable=" + this.variable).add("valueSource=" + (Object)((Object)this.valueSource));
        return joiner.toString();
    }

    public static Set<FqdnTemplateVariable> getRegisteredTemplateVariables() {
        return REGISTERED_TEMPLATE_VARIABLES;
    }

    public static Set<FqdnTemplateVariable> getRegisteredTemplateVariables(ValueSource valueSource) {
        return REGISTERED_TEMPLATE_VARIABLES.stream().filter(v -> v.valueSource == valueSource).collect(Collectors.toSet());
    }

    public static boolean isRegisteredTemplateVariable(String variable) {
        return REGISTERED_TEMPLATE_VARIABLES.stream().anyMatch(v -> v.variable.equals(variable));
    }

    public static class FqdnTemplateVariableWithValueInPPV2Header
    extends FqdnTemplateVariable {
        private final ProxyTlvType proxyTlvType;

        private FqdnTemplateVariableWithValueInPPV2Header(String variable, ProxyTlvType proxyTlvType) {
            super(variable, ValueSource.PPV2_HEADER);
            this.proxyTlvType = proxyTlvType;
        }

        public static FqdnTemplateVariableWithValueInPPV2Header createAndRegisterVariable(String variable, ProxyTlvType proxyTlvType) {
            Objects.requireNonNull(variable);
            Objects.requireNonNull(proxyTlvType);
            FqdnTemplateVariableWithValueInPPV2Header var = new FqdnTemplateVariableWithValueInPPV2Header(variable, proxyTlvType);
            REGISTERED_TEMPLATE_VARIABLES.add(var);
            return var;
        }

        @Override
        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", FqdnTemplateVariable.class.getSimpleName() + "[", "]").add("variable=" + this.variable).add("valueSource=" + (Object)((Object)this.valueSource)).add("proxyTlvType=" + this.proxyTlvType);
            return joiner.toString();
        }

        public ProxyTlvType proxyTlvType() {
            return this.proxyTlvType;
        }
    }

    public static enum ValueSource {
        SERVICE_PROVISION,
        PPV2_HEADER,
        RUNTIME;

    }
}

