/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.confluent.kafka.security.PemUtils;
import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import io.confluent.kafka.security.oauthbearer.ValidationUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.FileWatchService;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyClientAssertion
implements ClientAssertion {
    private static final Logger log = LoggerFactory.getLogger(PrivateKeyClientAssertion.class);
    private String iss;
    private String aud;
    private String sub;
    private Boolean setNotBefore;
    private final Integer expirationTime;
    private Boolean setJti;
    private static final FileWatchService PRIVATE_KEY_WATCH_SERVICE = new FileWatchService();
    private final PrivateKeyWatchListener privateKeyWatchListener;
    private final String privateKeyPath;
    private final String clientAssertionConfigPath;
    private final String passPhrase;
    private AtomicReference<PrivateKeyAndClientAssertionClaims> privateKeyAndClientAssertionClaims = new AtomicReference<Object>(null);

    public PrivateKeyClientAssertion(String iss, String aud, String sub, Integer expirationTime, Boolean setNotBefore, Boolean setJti, String privateKeyPath, String passPhrase, String clientAssertionConfigPath) {
        this.iss = ValidationUtils.sanitizeString("the client assertion issuer claim", iss);
        this.aud = ValidationUtils.sanitizeString("the client assertion audience claim", aud);
        this.sub = ValidationUtils.sanitizeString("the client assertion subject claim", sub);
        this.expirationTime = ValidationUtils.sanitizeInteger("the client assertion expiration time", expirationTime, 1);
        this.clientAssertionConfigPath = clientAssertionConfigPath;
        this.setJti = setJti;
        this.setNotBefore = setNotBefore;
        this.privateKeyPath = privateKeyPath;
        this.passPhrase = passPhrase;
        this.setPrivateKey();
        this.privateKeyWatchListener = new PrivateKeyWatchListener(privateKeyPath, this::setPrivateKey);
        PRIVATE_KEY_WATCH_SERVICE.add(this.privateKeyWatchListener);
    }

    @Override
    public String getJwt() {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(this.iss);
            claims.setAudience(this.aud);
            claims.setExpirationTimeMinutesInTheFuture((float)this.expirationTime.intValue());
            if (this.setJti.booleanValue()) {
                claims.setGeneratedJwtId(16);
            }
            claims.setIssuedAtToNow();
            if (this.setNotBefore.booleanValue()) {
                claims.setNotBeforeMinutesInThePast(1.0f);
            }
            claims.setSubject(this.sub);
            if (this.privateKeyAndClientAssertionClaims.get().payloadKeyValues != null) {
                for (Map.Entry<String, Object> entry : this.privateKeyAndClientAssertionClaims.get().payloadKeyValues.entrySet()) {
                    claims.setClaim(entry.getKey(), entry.getValue());
                }
            }
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)this.privateKeyAndClientAssertionClaims.get().privateKey);
            if (this.privateKeyAndClientAssertionClaims.get().headerKeyValues != null) {
                for (Map.Entry<String, Object> entry : this.privateKeyAndClientAssertionClaims.get().headerKeyValues.entrySet()) {
                    jws.setHeader(entry.getKey(), entry.getValue());
                }
            }
            jws.setAlgorithmHeaderValue("RS256");
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new KafkaException(e);
        }
    }

    private void setPrivateKey() {
        KeyPair keyPair = null;
        try (InputStream is = Files.newInputStream(Paths.get(this.privateKeyPath, new String[0]), new OpenOption[0]);){
            keyPair = this.passPhrase == null || this.passPhrase.isEmpty() ? PemUtils.loadKeyPair(is) : PemUtils.loadKeyPair(is, this.passPhrase);
        }
        catch (IOException e) {
            throw new KafkaException(e);
        }
        if (this.privateKeyAndClientAssertionClaims.get() != null) {
            log.info("Private key has been updated");
        }
        this.setPrivateKeyAndHeaderValues(keyPair.getPrivate());
    }

    protected PrivateKey getPrivateKey() {
        return this.privateKeyAndClientAssertionClaims.get().privateKey;
    }

    private void setPrivateKeyAndHeaderValues(PrivateKey privateKey) {
        Map<String, Object> headerValues = new HashMap<String, Object>();
        Map<String, Object> payloadValues = new HashMap<String, Object>();
        if (this.clientAssertionConfigPath != null && !this.clientAssertionConfigPath.isEmpty()) {
            Map keyValuePairs;
            ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().enable(new StreamReadFeature[]{StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION})).build();
            try {
                keyValuePairs = (Map)mapper.readValue(new File(this.clientAssertionConfigPath), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new KafkaException("Error parsing the json file, failed with exception :", e);
            }
            headerValues = (Map)mapper.convertValue(keyValuePairs.get("headers"), (TypeReference)new TypeReference<Map<String, Object>>(){});
            payloadValues = (Map)mapper.convertValue(keyValuePairs.get("payload"), (TypeReference)new TypeReference<Map<String, Object>>(){});
        } else {
            log.info("Client assertion config path is not provided, not configuring additional header and payload values");
        }
        this.privateKeyAndClientAssertionClaims.set(new PrivateKeyAndClientAssertionClaims(privateKey, headerValues, payloadValues));
    }

    @Override
    public void close() throws IOException {
        PRIVATE_KEY_WATCH_SERVICE.remove(this.privateKeyWatchListener);
    }

    static class PrivateKeyWatchListener
    implements FileWatchService.Listener {
        private final File privateKeyFile;
        private final Runnable setPrivateKey;

        PrivateKeyWatchListener(String privateKeyPath, Runnable setPrivateKey) {
            Path filePath = Paths.get(privateKeyPath, new String[0]);
            this.privateKeyFile = filePath.toFile();
            this.setPrivateKey = setPrivateKey;
        }

        @Override
        public File file() {
            return this.privateKeyFile;
        }

        @Override
        public void onInit() {
        }

        @Override
        public void onUpdate() {
            this.setPrivateKey.run();
        }
    }

    private static class PrivateKeyAndClientAssertionClaims {
        final PrivateKey privateKey;
        final Map<String, Object> headerKeyValues;
        final Map<String, Object> payloadKeyValues;

        PrivateKeyAndClientAssertionClaims(PrivateKey privatekey, Map<String, Object> headerKeyValues, Map<String, Object> payloadKeyValues) {
            this.privateKey = privatekey;
            this.headerKeyValues = headerKeyValues;
            this.payloadKeyValues = payloadKeyValues;
        }
    }
}

