/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;

public class PartitionReassignment {
    private final List<Integer> replicas;
    private final List<Integer> observers;
    private final List<Integer> addingReplicas;
    private final List<Integer> removingReplicas;

    public PartitionReassignment(List<Integer> replicas, List<Integer> observers, List<Integer> addingReplicas, List<Integer> removingReplicas) {
        this.replicas = Collections.unmodifiableList(replicas);
        this.observers = Collections.unmodifiableList(observers);
        this.addingReplicas = Collections.unmodifiableList(addingReplicas);
        this.removingReplicas = Collections.unmodifiableList(removingReplicas);
    }

    public PartitionReassignment(List<Integer> replicas, List<Integer> addingReplicas, List<Integer> removingReplicas) {
        this.replicas = Collections.unmodifiableList(replicas);
        this.observers = Collections.emptyList();
        this.addingReplicas = Collections.unmodifiableList(addingReplicas);
        this.removingReplicas = Collections.unmodifiableList(removingReplicas);
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> observers() {
        return this.observers;
    }

    public List<Integer> addingReplicas() {
        return this.addingReplicas;
    }

    public List<Integer> removingReplicas() {
        return this.removingReplicas;
    }

    public String toString() {
        return "PartitionReassignment(replicas=" + String.valueOf(this.replicas) + ", observers=" + String.valueOf(this.observers) + ", addingReplicas=" + String.valueOf(this.addingReplicas) + ", removingReplicas=" + String.valueOf(this.removingReplicas) + ")";
    }
}

