/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;

public class Topic {
    public static final String GROUP_METADATA_TOPIC_NAME = "__consumer_offsets";
    public static final String TRANSACTION_STATE_TOPIC_NAME = "__transaction_state";
    public static final String SHARE_GROUP_STATE_TOPIC_NAME = "__share_group_state";
    public static final String CLUSTER_METADATA_TOPIC_NAME = "__cluster_metadata";
    public static final TopicPartition CLUSTER_METADATA_TOPIC_PARTITION = new TopicPartition("__cluster_metadata", 0);
    public static final String TIER_TOPIC_NAME = "_confluent-tier-state";
    public static final String CLUSTER_LINK_METADATA_TOPIC = "_confluent-link-metadata";
    public static final String QUOTA_TOPIC_NAME = "_confluent-quotas";
    public static final String APIKEY_TOPIC_NAME = "_confluent-apikey";
    public static final String LOGICAL_CLUSTER_TOPIC_NAME = "_confluent-logical_cluster";
    public static final String METADATA_AUTH_TOPIC_NAME = "_confluent-metadata-auth";
    public static final String NETWORK_ID_ROUTES_TOPIC_NAME = "_confluent-network_id_routes";
    public static final String TELEMETRY_METRICS_TOPIC_NAME = "_confluent-telemetry-metrics";
    public static final String USER_METADATA_TOPIC_NAME = "_confluent-user_metadata";
    public static final String BALANCER_API_STATE_TOPIC_NAME = "_confluent_balancer_api_state";
    public static final String DURABILITY_AUDIT_TOPIC_NAME = "_confluent_durability_audit";
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    private static final Set<String> INTERNAL_TOPICS = Set.of("__consumer_offsets", "__transaction_state", "__share_group_state", "_confluent-tier-state", "_confluent-link-metadata", "_confluent-quotas");
    private static final Set<String> PREFERRED_LEADER_ELECTION_WARMUP_TOPICS = Set.of("_confluent-tier-state", "_confluent-link-metadata", "_confluent-quotas", "_confluent-apikey", "_confluent-logical_cluster", "_confluent-metadata-auth", "_confluent-network_id_routes", "_confluent-telemetry-metrics", "_confluent-user_metadata", "_confluent_balancer_api_state", "_confluent_durability_audit");
    private static final Set<String> COORDINATOR_TOPICS = Set.of("__consumer_offsets", "__transaction_state");
    public static final Set<String> EXTERNAL_CONNECTIVITY_STARTUP_TOPICS = PREFERRED_LEADER_ELECTION_WARMUP_TOPICS;
    private static final int MAX_NAME_LENGTH = 249;

    public static void validate(String topic) {
        Topic.validate(topic, "");
    }

    public static void validate(String topic, String prefix) {
        Topic.validate(topic, prefix, "Topic name", message -> {
            throw new InvalidTopicException((String)message);
        });
    }

    private static String detectInvalidTopic(String name, int prefixLength) {
        if (name.isEmpty()) {
            return "the empty string is not allowed";
        }
        if (".".equals(name)) {
            return "'.' is not allowed";
        }
        if ("..".equals(name)) {
            return "'..' is not allowed";
        }
        if (name.length() > 249) {
            return "the length of '" + name + "' is longer than the max allowed length " + (249 - prefixLength);
        }
        if (!Topic.containsValidPattern(name)) {
            return "'" + name + "' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'";
        }
        return null;
    }

    public static boolean isValid(String name) {
        String reasonInvalid = Topic.detectInvalidTopic(name, 0);
        return reasonInvalid == null;
    }

    public static void validate(String name, String logPrefix, Consumer<String> throwableConsumer) {
        Topic.validate(name, "", logPrefix, throwableConsumer);
    }

    public static void validate(String name, String namePrefix, String logPrefix, Consumer<String> throwableConsumer) {
        String reasonInvalid = Topic.detectInvalidTopic(name, namePrefix == null ? 0 : namePrefix.length());
        if (reasonInvalid != null) {
            throwableConsumer.accept(logPrefix + " is invalid: " + reasonInvalid);
        }
    }

    public static boolean isInternal(String topic) {
        return INTERNAL_TOPICS.contains(topic) || topic.startsWith(TIER_TOPIC_NAME);
    }

    public static boolean isPreferredLeaderElectionWarmup(String topic) {
        return PREFERRED_LEADER_ELECTION_WARMUP_TOPICS.contains(topic);
    }

    public static boolean isExternalConnectivityStartupTopic(String topic) {
        return EXTERNAL_CONNECTIVITY_STARTUP_TOPICS.contains(topic);
    }

    public static boolean isCoordinatorTopics(String topic) {
        return COORDINATOR_TOPICS.contains(topic);
    }

    public static boolean hasCollisionChars(String topic) {
        return topic.contains("_") || topic.contains(".");
    }

    public static String unifyCollisionChars(String topic) {
        return topic.replace('.', '_');
    }

    public static boolean hasCollision(String topicA, String topicB) {
        return Topic.unifyCollisionChars(topicA).equals(Topic.unifyCollisionChars(topicB));
    }

    public static boolean containsValidPattern(String topic) {
        for (int i = 0; i < topic.length(); ++i) {
            boolean validChar;
            char c = topic.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

