/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ResolveOffsetRangeRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ResolveOffsetRangeRequestDataJsonConverter {
    public static ResolveOffsetRangeRequestData read(JsonNode _node, short _version) {
        ResolveOffsetRangeRequestData _object = new ResolveOffsetRangeRequestData();
        JsonNode _maxNumRangesNode = _node.get("maxNumRanges");
        if (_maxNumRangesNode == null) {
            throw new RuntimeException("ResolveOffsetRangeRequestData: unable to locate field 'maxNumRanges', which is mandatory in version " + _version);
        }
        _object.maxNumRanges = MessageUtil.jsonNodeToInt(_maxNumRangesNode, "ResolveOffsetRangeRequestData");
        JsonNode _isolationLevelNode = _node.get("isolationLevel");
        if (_isolationLevelNode == null) {
            throw new RuntimeException("ResolveOffsetRangeRequestData: unable to locate field 'isolationLevel', which is mandatory in version " + _version);
        }
        _object.isolationLevel = MessageUtil.jsonNodeToByte(_isolationLevelNode, "ResolveOffsetRangeRequestData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ResolveOffsetRangeRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ResolveOffsetRangeRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic> _collection = new ArrayList<ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(ResolveOffsetRangeTopicJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ResolveOffsetRangeRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("maxNumRanges", (JsonNode)new IntNode(_object.maxNumRanges));
        _node.set("isolationLevel", (JsonNode)new ShortNode((short)_object.isolationLevel));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic _element : _object.topics) {
            _topicsArray.add(ResolveOffsetRangeTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(ResolveOffsetRangeRequestData _object, short _version) {
        return ResolveOffsetRangeRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class ResolveOffsetRangeTopicJsonConverter {
        public static ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic read(JsonNode _node, short _version) {
            ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic _object = new ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("ResolveOffsetRangeTopic: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("ResolveOffsetRangeTopic expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ResolveOffsetRangeTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ResolveOffsetRangeTopic expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ResolveOffsetRangeRequestData.ResolveOffsetRangePartition> _collection = new ArrayList<ResolveOffsetRangeRequestData.ResolveOffsetRangePartition>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(ResolveOffsetRangePartitionJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ResolveOffsetRangeRequestData.ResolveOffsetRangePartition _element : _object.partitions) {
                _partitionsArray.add(ResolveOffsetRangePartitionJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic _object, short _version) {
            return ResolveOffsetRangeTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class ResolveOffsetRangePartitionJsonConverter {
        public static ResolveOffsetRangeRequestData.ResolveOffsetRangePartition read(JsonNode _node, short _version) {
            ResolveOffsetRangeRequestData.ResolveOffsetRangePartition _object = new ResolveOffsetRangeRequestData.ResolveOffsetRangePartition();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("ResolveOffsetRangePartition: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "ResolveOffsetRangePartition");
            JsonNode _startOffsetNode = _node.get("startOffset");
            if (_startOffsetNode == null) {
                throw new RuntimeException("ResolveOffsetRangePartition: unable to locate field 'startOffset', which is mandatory in version " + _version);
            }
            _object.startOffset = MessageUtil.jsonNodeToLong(_startOffsetNode, "ResolveOffsetRangePartition");
            return _object;
        }

        public static JsonNode write(ResolveOffsetRangeRequestData.ResolveOffsetRangePartition _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("startOffset", (JsonNode)new LongNode(_object.startOffset));
            return _node;
        }

        public static JsonNode write(ResolveOffsetRangeRequestData.ResolveOffsetRangePartition _object, short _version) {
            return ResolveOffsetRangePartitionJsonConverter.write(_object, _version, true);
        }
    }
}

