/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.kafka.clients.admin.RaftVoterEndpoint;
import org.apache.kafka.common.Uuid;

public class QuorumInfo {
    private final int leaderId;
    private final long leaderEpoch;
    private final long highWatermark;
    private final List<ReplicaState> voters;
    private final List<ReplicaState> observers;
    private final Map<Integer, Node> nodes;

    public QuorumInfo(int leaderId, long leaderEpoch, long highWatermark, List<ReplicaState> voters, List<ReplicaState> observers, Map<Integer, Node> nodes) {
        this.leaderId = leaderId;
        this.leaderEpoch = leaderEpoch;
        this.highWatermark = highWatermark;
        this.voters = voters;
        this.observers = observers;
        this.nodes = nodes;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public long leaderEpoch() {
        return this.leaderEpoch;
    }

    public long highWatermark() {
        return this.highWatermark;
    }

    public List<ReplicaState> voters() {
        return this.voters;
    }

    public List<ReplicaState> observers() {
        return this.observers;
    }

    public Map<Integer, Node> nodes() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuorumInfo that = (QuorumInfo)o;
        return this.leaderId == that.leaderId && this.leaderEpoch == that.leaderEpoch && this.highWatermark == that.highWatermark && Objects.equals(this.voters, that.voters) && Objects.equals(this.observers, that.observers) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.leaderId, this.leaderEpoch, this.highWatermark, this.voters, this.observers, this.nodes);
    }

    public String toString() {
        return "QuorumInfo(leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", highWatermark=" + this.highWatermark + ", voters=" + String.valueOf(this.voters) + ", observers=" + String.valueOf(this.observers) + ", nodes=" + String.valueOf(this.nodes) + ")";
    }

    public static class Node {
        private final int nodeId;
        private final List<RaftVoterEndpoint> endpoints;

        Node(int nodeId, List<RaftVoterEndpoint> endpoints) {
            this.nodeId = nodeId;
            this.endpoints = endpoints;
        }

        public int nodeId() {
            return this.nodeId;
        }

        public List<RaftVoterEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.nodeId == node.nodeId && Objects.equals(this.endpoints, node.endpoints);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.endpoints);
        }

        public String toString() {
            return "Node{nodeId=" + this.nodeId + ", endpoints=" + String.valueOf(this.endpoints) + "}";
        }
    }

    public static class ReplicaState {
        private final int replicaId;
        private final Uuid replicaDirectoryId;
        private final long logEndOffset;
        private final OptionalLong lastFetchTimestamp;
        private final OptionalLong lastCaughtUpTimestamp;

        ReplicaState() {
            this(0, Uuid.ZERO_UUID, 0L, OptionalLong.empty(), OptionalLong.empty());
        }

        public ReplicaState(int replicaId, Uuid replicaDirectoryId, long logEndOffset, OptionalLong lastFetchTimestamp, OptionalLong lastCaughtUpTimestamp) {
            this.replicaId = replicaId;
            this.replicaDirectoryId = replicaDirectoryId;
            this.logEndOffset = logEndOffset;
            this.lastFetchTimestamp = lastFetchTimestamp;
            this.lastCaughtUpTimestamp = lastCaughtUpTimestamp;
        }

        public int replicaId() {
            return this.replicaId;
        }

        public Uuid replicaDirectoryId() {
            return this.replicaDirectoryId;
        }

        public long logEndOffset() {
            return this.logEndOffset;
        }

        public OptionalLong lastFetchTimestamp() {
            return this.lastFetchTimestamp;
        }

        public OptionalLong lastCaughtUpTimestamp() {
            return this.lastCaughtUpTimestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaState that = (ReplicaState)o;
            return this.replicaId == that.replicaId && Objects.equals(this.replicaDirectoryId, that.replicaDirectoryId) && this.logEndOffset == that.logEndOffset && this.lastFetchTimestamp.equals(that.lastFetchTimestamp) && this.lastCaughtUpTimestamp.equals(that.lastCaughtUpTimestamp);
        }

        public int hashCode() {
            return Objects.hash(this.replicaId, this.replicaDirectoryId, this.logEndOffset, this.lastFetchTimestamp, this.lastCaughtUpTimestamp);
        }

        public String toString() {
            return "ReplicaState(replicaId=" + this.replicaId + ", replicaDirectoryId=" + String.valueOf(this.replicaDirectoryId) + ", logEndOffset=" + this.logEndOffset + ", lastFetchTimestamp=" + String.valueOf(this.lastFetchTimestamp) + ", lastCaughtUpTimestamp=" + String.valueOf(this.lastCaughtUpTimestamp) + ")";
        }
    }
}

