/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CellState {
    UNKNOWN(0, false, false),
    READY(1, true, true),
    QUARANTINED(2, false, false),
    EXCLUDED(3, true, false);

    public static final Set<CellState> VALID_CELL_STATES;
    private static final Map<Byte, CellState> CODE_TO_CELL_STATE;
    private final byte code;
    private final boolean isEligibleSource;
    private final boolean isEligibleDestination;

    public byte code() {
        return this.code;
    }

    public boolean isEligibleSource() {
        return this.isEligibleSource;
    }

    public boolean isEligibleDestination() {
        return this.isEligibleDestination;
    }

    private CellState(byte code, boolean isEligibleSource, boolean isEligibleDestination) {
        this.code = code;
        this.isEligibleSource = isEligibleSource;
        this.isEligibleDestination = isEligibleDestination;
    }

    public static CellState toEnum(byte code) {
        return CODE_TO_CELL_STATE.getOrDefault(code, UNKNOWN);
    }

    static {
        VALID_CELL_STATES = Collections.unmodifiableSet(new HashSet<CellState>(Arrays.asList(READY, QUARANTINED, EXCLUDED)));
        CODE_TO_CELL_STATE = Arrays.stream(CellState.values()).collect(Collectors.toMap(CellState::code, Function.identity()));
    }
}

