/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Objects;

public class Node {
    private static final Node NO_NODE = new Node(-1, "", -1);
    private final int id;
    private final String idString;
    private final String host;
    private final int port;
    private final String rack;
    private final boolean isFenced;
    private Integer hash;

    public Node(int id, String host, int port) {
        this(id, host, port, null, false);
    }

    public Node(int id, String host, int port, String rack) {
        this.id = id;
        this.idString = Integer.toString(id);
        this.host = host;
        this.port = port;
        this.rack = rack;
        this.isFenced = false;
    }

    public Node(int id, String host, int port, String rack, boolean isFenced) {
        this.id = id;
        this.idString = Integer.toString(id);
        this.host = host;
        this.port = port;
        this.rack = rack;
        this.isFenced = isFenced;
    }

    public static Node noNode() {
        return NO_NODE;
    }

    public boolean isEmpty() {
        return this.host == null || this.host.isEmpty() || this.port < 0;
    }

    public int id() {
        return this.id;
    }

    public String idString() {
        return this.idString;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public String rack() {
        return this.rack;
    }

    public boolean isFenced() {
        return this.isFenced;
    }

    public int hashCode() {
        Integer h2 = this.hash;
        if (h2 == null) {
            int result = 31 + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + this.port;
            result = 31 * result + (this.rack == null ? 0 : this.rack.hashCode());
            result = 31 * result + Objects.hashCode(this.isFenced);
            this.hash = result;
            return result;
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return this.id == other.id && this.port == other.port && Objects.equals(this.host, other.host) && Objects.equals(this.rack, other.rack) && Objects.equals(this.isFenced, other.isFenced);
    }

    public String toString() {
        return this.host + ":" + this.port + " (id: " + this.idString + " rack: " + this.rack + " isFenced: " + this.isFenced + ")";
    }
}

