/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.utils.FlattenedIterator;

public final class LeaderAndIsrRequest {
    private final int controllerId;
    private final int controllerEpoch;
    private final long brokerEpoch;
    private final List<Node> liveLeaders;
    private final List<TopicState> topicStates;
    private final Type requestType;

    public LeaderAndIsrRequest(Builder builder) {
        this.controllerId = builder.controllerId;
        this.controllerEpoch = builder.controllerEpoch;
        this.brokerEpoch = builder.brokerEpoch;
        this.requestType = builder.updateType;
        this.liveLeaders = new ArrayList<Node>(builder.liveLeaders);
        this.topicStates = new ArrayList<TopicState>(LeaderAndIsrRequest.groupByTopic(builder.partitionStates, builder.topicIds).values());
    }

    private static Map<String, TopicState> groupByTopic(List<PartitionState> partitionStates, Map<String, Uuid> topicIds) {
        HashMap<String, TopicState> topicStates = new HashMap<String, TopicState>();
        for (PartitionState partition : partitionStates) {
            TopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t2 -> {
                TopicState topic = new TopicState();
                topic.topicName = partition.topicName();
                topic.topicId = topicIds.getOrDefault(partition.topicName(), Uuid.ZERO_UUID);
                return topic;
            });
            topicState.partitionStates().add(partition);
        }
        return topicStates;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public Iterable<PartitionState> partitionStates() {
        return () -> new FlattenedIterator(this.topicStates.iterator(), topicState -> topicState.partitionStates().iterator());
    }

    public Map<String, Uuid> topicIds() {
        return this.topicStates.stream().collect(Collectors.toMap(TopicState::topicName, TopicState::topicId));
    }

    public List<Node> liveLeaders() {
        return Collections.unmodifiableList(this.liveLeaders);
    }

    public Type requestType() {
        return this.requestType;
    }

    public LeaderAndIsrResponse getErrorResponse(Exception e) {
        LinkedHashMap<Uuid, List<LeaderAndIsrResponse.PartitionError>> errorsMap = new LinkedHashMap<Uuid, List<LeaderAndIsrResponse.PartitionError>>();
        Errors error = Errors.forException(e);
        for (TopicState topicState : this.topicStates) {
            ArrayList<LeaderAndIsrResponse.PartitionError> partitions = new ArrayList<LeaderAndIsrResponse.PartitionError>(topicState.partitionStates().size());
            for (PartitionState partition : topicState.partitionStates()) {
                partitions.add(new LeaderAndIsrResponse.PartitionError(partition.partitionIndex, error.code()));
            }
            errorsMap.put(topicState.topicId, partitions);
        }
        return new LeaderAndIsrResponse(error, errorsMap);
    }

    public static class Builder {
        protected final int controllerId;
        protected final int controllerEpoch;
        protected final long brokerEpoch;
        private final List<PartitionState> partitionStates;
        private final Map<String, Uuid> topicIds;
        private final Collection<Node> liveLeaders;
        private final Type updateType;

        public Builder(int controllerId, int controllerEpoch, long brokerEpoch, List<PartitionState> partitionStates, Map<String, Uuid> topicIds, Collection<Node> liveLeaders) {
            this(controllerId, controllerEpoch, brokerEpoch, partitionStates, topicIds, liveLeaders, Type.UNKNOWN);
        }

        public Builder(int controllerId, int controllerEpoch, long brokerEpoch, List<PartitionState> partitionStates, Map<String, Uuid> topicIds, Collection<Node> liveLeaders, Type updateType) {
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.brokerEpoch = brokerEpoch;
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.liveLeaders = liveLeaders;
            this.updateType = updateType;
        }

        public LeaderAndIsrRequest build() {
            return new LeaderAndIsrRequest(this);
        }

        public String toString() {
            return "(type=LeaderAndIsRequest, controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", partitionStates=" + String.valueOf(this.partitionStates) + ", topicIds=" + String.valueOf(this.topicIds) + ", liveLeaders=(" + this.liveLeaders.stream().map(Node::toString).collect(Collectors.joining(", ")) + "))";
        }
    }

    public static enum Type {
        UNKNOWN(0),
        INCREMENTAL(1),
        FULL(2);

        private final byte type;

        private Type(int type) {
            this.type = (byte)type;
        }

        public byte toByte() {
            return this.type;
        }
    }

    public static class PartitionState {
        String topicName = "";
        int partitionIndex = 0;
        int controllerEpoch = 0;
        int leader = 0;
        int leaderEpoch = 0;
        List<Integer> isr = new ArrayList<Integer>(0);
        int partitionEpoch = 0;
        List<Integer> replicas = new ArrayList<Integer>(0);
        List<Integer> observers = new ArrayList<Integer>(0);
        List<Integer> addingReplicas = new ArrayList<Integer>(0);
        List<Integer> removingReplicas = new ArrayList<Integer>(0);
        boolean isNew = false;
        byte leaderRecoveryState = 0;
        boolean confluentIsUncleanLeader = false;
        String clusterLinkTopicState;
        String clusterLinkId;
        Uuid clusterLinkSourceTopicId = Uuid.ZERO_UUID;
        int linkedLeaderEpoch = -1;
        long mirrorStartOffset = -1L;
        long mirrorStoppedOffset;
        int mirrorStoppedEpoch;
        short mirrorTopicError = (short)-1;

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionState that = (PartitionState)o;
            return this.partitionIndex == that.partitionIndex && this.controllerEpoch == that.controllerEpoch && this.leader == that.leader && this.leaderEpoch == that.leaderEpoch && this.partitionEpoch == that.partitionEpoch && this.isNew == that.isNew && this.leaderRecoveryState == that.leaderRecoveryState && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.isr, that.isr) && Objects.equals(this.replicas, that.replicas) && Objects.equals(this.observers, that.observers) && Objects.equals(this.addingReplicas, that.addingReplicas) && Objects.equals(this.removingReplicas, that.removingReplicas) && this.confluentIsUncleanLeader == that.confluentIsUncleanLeader && Objects.equals(this.clusterLinkTopicState, that.clusterLinkTopicState) && Objects.equals(this.clusterLinkId, that.clusterLinkId) && Objects.equals(this.clusterLinkSourceTopicId, that.clusterLinkSourceTopicId) && this.linkedLeaderEpoch == that.linkedLeaderEpoch && this.mirrorStartOffset == that.mirrorStartOffset && this.mirrorTopicError == that.mirrorTopicError;
        }

        public int hashCode() {
            return Objects.hash(this.topicName, this.partitionIndex, this.controllerEpoch, this.leader, this.leaderEpoch, this.isr, this.partitionEpoch, this.replicas, this.observers, this.addingReplicas, this.removingReplicas, this.isNew, this.leaderRecoveryState, this.confluentIsUncleanLeader, this.clusterLinkTopicState, this.clusterLinkId, this.clusterLinkSourceTopicId, this.linkedLeaderEpoch, this.mirrorStartOffset, this.mirrorTopicError);
        }

        public String toString() {
            return "LeaderAndIsrPartitionState(topicName='" + this.topicName + "', partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", partitionEpoch=" + this.partitionEpoch + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", observers=" + MessageUtil.deepToString(this.replicas.iterator()) + ", addingReplicas=" + MessageUtil.deepToString(this.addingReplicas.iterator()) + ", removingReplicas=" + MessageUtil.deepToString(this.removingReplicas.iterator()) + ", isNew=" + (this.isNew ? "true" : "false") + ", leaderRecoveryState=" + this.leaderRecoveryState + ", confluentIsUncleanLeader=" + this.confluentIsUncleanLeader + ", clusterLinkTopicState=" + this.clusterLinkTopicState + ", clusterLinkId=" + this.clusterLinkId + ", clusterLinkSourceTopicId=" + String.valueOf(this.clusterLinkSourceTopicId) + ", linkedLeaderEpoch=" + this.linkedLeaderEpoch + ", mirrorStartOffset=" + this.mirrorStartOffset + ", mirrorTopicError=" + this.mirrorTopicError + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int partitionEpoch() {
            return this.partitionEpoch;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> observers() {
            return this.observers;
        }

        public List<Integer> addingReplicas() {
            return this.addingReplicas;
        }

        public List<Integer> removingReplicas() {
            return this.removingReplicas;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public byte leaderRecoveryState() {
            return this.leaderRecoveryState;
        }

        public boolean confluentIsUncleanLeader() {
            return this.confluentIsUncleanLeader;
        }

        public String clusterLinkTopicState() {
            return this.clusterLinkTopicState;
        }

        public String clusterLinkId() {
            return this.clusterLinkId;
        }

        public Uuid clusterLinkSourceTopicId() {
            return this.clusterLinkSourceTopicId;
        }

        public int linkedLeaderEpoch() {
            return this.linkedLeaderEpoch;
        }

        public long mirrorStartOffset() {
            return this.mirrorStartOffset;
        }

        public long mirrorStoppedOffset() {
            return this.mirrorStoppedOffset;
        }

        public short mirrorTopicError() {
            return this.mirrorTopicError;
        }

        public PartitionState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public PartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public PartitionState setLeader(int v) {
            this.leader = v;
            return this;
        }

        public PartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public PartitionState setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public PartitionState setPartitionEpoch(int v) {
            this.partitionEpoch = v;
            return this;
        }

        public PartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public PartitionState setObservers(List<Integer> v) {
            this.observers = v;
            return this;
        }

        public PartitionState setAddingReplicas(List<Integer> v) {
            this.addingReplicas = v;
            return this;
        }

        public PartitionState setRemovingReplicas(List<Integer> v) {
            this.removingReplicas = v;
            return this;
        }

        public PartitionState setIsNew(boolean v) {
            this.isNew = v;
            return this;
        }

        public PartitionState setLeaderRecoveryState(byte v) {
            this.leaderRecoveryState = v;
            return this;
        }

        public PartitionState setConfluentIsUncleanLeader(boolean v) {
            this.confluentIsUncleanLeader = v;
            return this;
        }

        public PartitionState setClusterLinkTopicState(String v) {
            this.clusterLinkTopicState = v;
            return this;
        }

        public PartitionState setClusterLinkId(String v) {
            this.clusterLinkId = v;
            return this;
        }

        public PartitionState setClusterLinkSourceTopicId(Uuid v) {
            this.clusterLinkSourceTopicId = v;
            return this;
        }

        public PartitionState setLinkedLeaderEpoch(int v) {
            this.linkedLeaderEpoch = v;
            return this;
        }

        public PartitionState setMirrorStartOffset(long v) {
            this.mirrorStartOffset = v;
            return this;
        }

        public PartitionState setMirrorStoppedOffset(long v) {
            this.mirrorStoppedOffset = v;
            return this;
        }
    }

    public static class TopicState {
        String topicName = "";
        Uuid topicId = Uuid.ZERO_UUID;
        List<PartitionState> partitionStates = new ArrayList<PartitionState>(0);

        public String topicName() {
            return this.topicName;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<PartitionState> partitionStates() {
            return this.partitionStates;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicState that = (TopicState)o;
            return Objects.equals(this.topicName, that.topicName) && Objects.equals(this.topicId, that.topicId) && Objects.equals(this.partitionStates, that.partitionStates);
        }

        public int hashCode() {
            return Objects.hash(this.topicName, this.topicId, this.partitionStates);
        }

        public String toString() {
            return "LeaderAndIsrTopicState(topicName='" + this.topicName + "', topicId=" + String.valueOf(this.topicId) + ", partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }
    }
}

