/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;
import org.apache.kafka.common.Uuid;

public abstract class BackgroundEvent {
    private final Type type;
    private final Uuid id;
    private long enqueuedMs;

    protected BackgroundEvent(Type type) {
        this.type = Objects.requireNonNull(type);
        this.id = Uuid.randomUuid();
    }

    public Type type() {
        return this.type;
    }

    public Uuid id() {
        return this.id;
    }

    public void setEnqueuedMs(long enqueuedMs) {
        this.enqueuedMs = enqueuedMs;
    }

    public long enqueuedMs() {
        return this.enqueuedMs;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundEvent that = (BackgroundEvent)o;
        return this.type == that.type && this.id.equals(that.id);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id});
    }

    protected String toStringBase() {
        return "type=" + String.valueOf((Object)this.type) + ", id=" + String.valueOf(this.id) + ", enqueuedMs=" + this.enqueuedMs;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + "}";
    }

    public static enum Type {
        ERROR,
        CONSUMER_REBALANCE_LISTENER_CALLBACK_NEEDED,
        SHARE_ACKNOWLEDGEMENT_COMMIT_CALLBACK;

    }
}

