/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

public class BrokerAdditionDescription {
    private final int brokerId;
    private final Optional<BalancerOperationError> additionError;
    private final BalancerOperationStatus generalOperationStatus;
    private final PartitionReassignmentsStatus partitionReassignmentsStatus;
    private long createTimeMs;
    private long lastUpdateTimeMs;

    public BrokerAdditionDescription(int brokerId, BalancerOperationStatus balancerOperationGeneralStatus, PartitionReassignmentsStatus partitionReassignmentsStatus, Optional<BalancerOperationError> additionError, long createTimeMs, long lastUpdateTimestamp) {
        this.brokerId = brokerId;
        this.partitionReassignmentsStatus = partitionReassignmentsStatus;
        this.additionError = additionError;
        this.createTimeMs = createTimeMs;
        this.lastUpdateTimeMs = lastUpdateTimestamp;
        this.generalOperationStatus = balancerOperationGeneralStatus;
    }

    public BalancerOperationStatus generalOperationStatus() {
        return this.generalOperationStatus;
    }

    public PartitionReassignmentsStatus partitionReassignmentsStatus() {
        return this.partitionReassignmentsStatus;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long createTimeMs() {
        return this.createTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public Optional<BalancerOperationError> additionError() {
        return this.additionError;
    }

    public String toString() {
        return "BrokerAdditionDescription{brokerId=" + this.brokerId + ", partitionReassignmentsStatus=" + String.valueOf((Object)this.partitionReassignmentsStatus) + ", additionError=" + String.valueOf(this.additionError) + ", generalOperationStatus=" + String.valueOf((Object)this.generalOperationStatus) + ", createTime=" + ClientUtils.utcDateFor(this.createTimeMs) + ", lastUpdateTime=" + ClientUtils.utcDateFor(this.lastUpdateTimeMs) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerAdditionDescription that = (BrokerAdditionDescription)o;
        return this.brokerId == that.brokerId && this.createTimeMs == that.createTimeMs && this.lastUpdateTimeMs == that.lastUpdateTimeMs && Objects.equals(this.additionError, that.additionError) && this.generalOperationStatus == that.generalOperationStatus && this.partitionReassignmentsStatus == that.partitionReassignmentsStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brokerId, this.additionError, this.generalOperationStatus, this.partitionReassignmentsStatus, this.createTimeMs, this.lastUpdateTimeMs});
    }
}

