/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.kafka.common.network.FqdnTemplateVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerFqdnBuilder {
    private static final Logger log = LoggerFactory.getLogger(BrokerFqdnBuilder.class);
    private final Map<String, String> templateIdToTemplate;
    private final Map<String, String> bootstrapToBrokerTemplateId;
    private final Map<FqdnTemplateVariable, String> serviceProvisionVariableValues;

    public BrokerFqdnBuilder(Map<String, String> templateIdToTemplate, Set<String> possibleTemplateVariablesToBeFilled, Map<String, String> bootstrapToBrokerTemplateId, Map<FqdnTemplateVariable, String> serviceProvisionVariableValues) {
        Objects.requireNonNull(templateIdToTemplate);
        Objects.requireNonNull(possibleTemplateVariablesToBeFilled);
        Objects.requireNonNull(bootstrapToBrokerTemplateId);
        for (String string : possibleTemplateVariablesToBeFilled) {
            if (FqdnTemplateVariable.isRegisteredTemplateVariable(string)) continue;
            throw new IllegalArgumentException("No registered template variables found for template variable: " + string + ", registered template variables are " + String.valueOf(FqdnTemplateVariable.getRegisteredTemplateVariables()));
        }
        for (FqdnTemplateVariable fqdnTemplateVariable : serviceProvisionVariableValues.keySet()) {
            if (fqdnTemplateVariable.valueSource == FqdnTemplateVariable.ValueSource.SERVICE_PROVISION) continue;
            throw new IllegalArgumentException("Variable: " + fqdnTemplateVariable.variable + " is not a service provisioned variable");
        }
        for (Map.Entry entry : bootstrapToBrokerTemplateId.entrySet()) {
            String bootstrapTemplateId = (String)entry.getKey();
            String brokerTemplateId = (String)entry.getValue();
            if (!templateIdToTemplate.containsKey(bootstrapTemplateId)) {
                throw new IllegalArgumentException("Template not found for bootstrapTemplateId: " + bootstrapTemplateId);
            }
            if (templateIdToTemplate.containsKey(brokerTemplateId)) continue;
            throw new IllegalArgumentException("Template not found for brokerTemplateId: " + brokerTemplateId);
        }
        this.templateIdToTemplate = templateIdToTemplate;
        this.bootstrapToBrokerTemplateId = bootstrapToBrokerTemplateId;
        this.serviceProvisionVariableValues = serviceProvisionVariableValues;
    }

    public String getBrokerFqdn(FQDNPropertiesFromPPV2 fqdnProperties, Map<FqdnTemplateVariable, String> runTimeVariableValues) {
        String template;
        Objects.requireNonNull(fqdnProperties);
        Objects.requireNonNull(runTimeVariableValues);
        String brokerTemplateId = fqdnProperties.templateId;
        if (this.bootstrapToBrokerTemplateId.containsKey(brokerTemplateId)) {
            brokerTemplateId = this.bootstrapToBrokerTemplateId.get(fqdnProperties.templateId);
            log.debug("Using broker template-id: {} for bootstrap template-id: {}", (Object)brokerTemplateId, (Object)fqdnProperties.templateId);
        }
        if ((template = this.templateIdToTemplate.get(brokerTemplateId)) == null) {
            throw new IllegalArgumentException("Template not found for templateId: " + brokerTemplateId);
        }
        log.debug("Using template: {} for template-id: {}", (Object)template, (Object)brokerTemplateId);
        String filledTemplate = template;
        for (Map.Entry<FqdnTemplateVariable.FqdnTemplateVariableWithValueInPPV2Header, String> entry : fqdnProperties.ppv2VariableValues.entrySet()) {
            filledTemplate = filledTemplate.replace(entry.getKey().variable, entry.getValue());
        }
        for (Map.Entry<FqdnTemplateVariable, String> entry : this.serviceProvisionVariableValues.entrySet()) {
            filledTemplate = filledTemplate.replace(entry.getKey().variable, entry.getValue());
        }
        for (Map.Entry<FqdnTemplateVariable, String> entry : runTimeVariableValues.entrySet()) {
            filledTemplate = filledTemplate.replace(entry.getKey().variable, entry.getValue());
        }
        log.debug("Filled template: {} for template-id: {}", (Object)filledTemplate, (Object)brokerTemplateId);
        return filledTemplate;
    }

    public String toString() {
        StringJoiner templateIdToTemplateJoiner = new StringJoiner(", ", "templateIdToTemplate=[", "]");
        this.templateIdToTemplate.forEach((templateId, template) -> templateIdToTemplateJoiner.add(templateId + ":" + template));
        StringJoiner bootstrapToBrokerTemplateIdJoiner = new StringJoiner(", ", "bootstrapToBrokerTemplateId=[", "]");
        this.bootstrapToBrokerTemplateId.forEach((bootstrapTemplateId, brokerTemplateId) -> bootstrapToBrokerTemplateIdJoiner.add(bootstrapTemplateId + ":" + brokerTemplateId));
        StringJoiner serviceProvisionVariableValuesJoiner = new StringJoiner(", ", "serviceProvisionVariableValues=[", "]");
        this.serviceProvisionVariableValues.forEach((templateVar, varValue) -> serviceProvisionVariableValuesJoiner.add(templateVar.variable + ":" + varValue));
        StringJoiner joiner = new StringJoiner(", ", BrokerFqdnBuilder.class.getSimpleName() + "[", "]").add(templateIdToTemplateJoiner.toString()).add(bootstrapToBrokerTemplateIdJoiner.toString()).add(serviceProvisionVariableValuesJoiner.toString());
        return joiner.toString();
    }

    public static Map<String, String> createBrokerToGatewayZoneMapping(Set<String> gatewayZones, Set<String> brokerZones) {
        Objects.requireNonNull(gatewayZones);
        Objects.requireNonNull(brokerZones);
        if (gatewayZones.isEmpty()) {
            throw new IllegalArgumentException("Gateway zones cannot be empty");
        }
        HashMap<String, String> zoneMapping = new HashMap<String, String>();
        HashSet<String> unmatchedBrokerZones = new HashSet<String>(brokerZones);
        HashSet<String> unmatchedGatewayZones = new HashSet<String>(gatewayZones);
        HashSet<String> matchedGatewayZones = new HashSet<String>();
        for (String brokerZone : brokerZones) {
            if (!gatewayZones.contains(brokerZone)) continue;
            zoneMapping.put(brokerZone, brokerZone);
            unmatchedBrokerZones.remove(brokerZone);
            unmatchedGatewayZones.remove(brokerZone);
            matchedGatewayZones.add(brokerZone);
        }
        ArrayList<String> sortedGatewayZones = new ArrayList<String>(unmatchedGatewayZones);
        Collections.sort(sortedGatewayZones);
        ArrayList sortedMatchedGatewayZones = new ArrayList(matchedGatewayZones);
        Collections.sort(sortedMatchedGatewayZones);
        sortedGatewayZones.addAll(sortedMatchedGatewayZones);
        ArrayList<String> sortedUnmatchedBrokerZones = new ArrayList<String>(unmatchedBrokerZones);
        Collections.sort(sortedUnmatchedBrokerZones);
        int gatewayZonePointer = 0;
        for (String statefulZone : sortedUnmatchedBrokerZones) {
            zoneMapping.put(statefulZone, (String)sortedGatewayZones.get(gatewayZonePointer));
            gatewayZonePointer = (gatewayZonePointer + 1) % sortedGatewayZones.size();
        }
        return zoneMapping;
    }

    public static class FQDNPropertiesFromPPV2 {
        private final String templateId;
        private final Map<FqdnTemplateVariable.FqdnTemplateVariableWithValueInPPV2Header, String> ppv2VariableValues;
        private final Set<String> gatewayZones;
        private final String gatewayZoneId;

        public FQDNPropertiesFromPPV2(String templateId, Map<FqdnTemplateVariable.FqdnTemplateVariableWithValueInPPV2Header, String> ppv2VariableValues, Set<String> gatewayZones, String gatewayZoneId) {
            Objects.requireNonNull(templateId);
            Objects.requireNonNull(ppv2VariableValues);
            for (FqdnTemplateVariable fqdnTemplateVariable : ppv2VariableValues.keySet()) {
                if (fqdnTemplateVariable.valueSource == FqdnTemplateVariable.ValueSource.PPV2_HEADER) continue;
                throw new IllegalArgumentException("Variable: " + fqdnTemplateVariable.variable + " is not a PPV2 header variable");
            }
            this.ppv2VariableValues = ppv2VariableValues;
            this.templateId = templateId;
            this.gatewayZones = gatewayZones;
            this.gatewayZoneId = gatewayZoneId;
        }

        public Set<String> gatewayZones() {
            return this.gatewayZones;
        }

        public String gatewayZoneId() {
            return this.gatewayZoneId;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", FQDNPropertiesFromPPV2.class.getSimpleName() + "[", "]").add("templateId=" + this.templateId).add("gatewayZones=" + String.valueOf(this.gatewayZones)).add("gatewayZoneId=" + this.gatewayZoneId);
            for (Map.Entry<FqdnTemplateVariable.FqdnTemplateVariableWithValueInPPV2Header, String> entry : this.ppv2VariableValues.entrySet()) {
                joiner.add(entry.getKey().variable + "=" + entry.getValue());
            }
            return joiner.toString();
        }
    }
}

