/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

public final class SslUtil {
    public static final int RECORD_HEADER_SIZE = 5;

    private SslUtil() {
    }

    public static Map<Integer, SNIServerName> parseSniServerName(ByteBuffer source) throws IOException {
        ByteBuffer input = source.duplicate();
        if (input.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        byte firstByte = input.get();
        byte secondByte = input.get();
        byte thirdByte = input.get();
        if ((firstByte & 0x80) != 0 && thirdByte == 1) {
            return SslUtil.exploreV2HelloRecord(input, thirdByte);
        }
        if (firstByte == 22) {
            return SslUtil.exploreTLSRecord(input, firstByte);
        }
        throw new SSLException("Not handshake record");
    }

    private static Map<Integer, SNIServerName> exploreV2HelloRecord(ByteBuffer input, byte thirdByte) throws IOException {
        try {
            if (thirdByte != 1) {
                throw new SSLException("Unsupported or Unrecognized SSL record");
            }
            byte helloVersionMajor = input.get();
            byte helloVersionMinor = input.get();
            return Collections.emptyMap();
        }
        catch (BufferUnderflowException bufe) {
            throw new SSLProtocolException("Invalid handshake record");
        }
    }

    private static Map<Integer, SNIServerName> exploreTLSRecord(ByteBuffer input, byte firstByte) throws IOException {
        if (firstByte != 22) {
            throw new SSLException("Not handshake record");
        }
        int recordLength = SslUtil.getInt16(input);
        if (recordLength > input.remaining()) {
            throw new BufferUnderflowException();
        }
        try {
            return SslUtil.parseHandshake(input, recordLength);
        }
        catch (BufferUnderflowException bufe) {
            throw new SSLProtocolException("Invalid handshake record");
        }
    }

    private static Map<Integer, SNIServerName> parseHandshake(ByteBuffer input, int recordLength) throws IOException {
        byte handshakeType = input.get();
        if (handshakeType != 1) {
            throw new IllegalStateException("Not initial handshaking");
        }
        int handshakeLength = SslUtil.getInt24(input);
        if (handshakeLength > recordLength - 4) {
            throw new SSLException("Handshake message spans multiple records");
        }
        input = input.duplicate();
        input.limit(handshakeLength + input.position());
        return SslUtil.parseClientHello(input);
    }

    private static Map<Integer, SNIServerName> parseClientHello(ByteBuffer input) throws IOException {
        Map<Integer, SNIServerName> snMap = Collections.emptyMap();
        byte helloMajorVersion = input.get();
        byte helloMinorVersion = input.get();
        int position = input.position();
        input.position(position + 32);
        SslUtil.ignoreByteVector8(input);
        SslUtil.ignoreByteVector16(input);
        SslUtil.ignoreByteVector8(input);
        if (input.remaining() > 0) {
            snMap = SslUtil.parseExtensions(input);
        }
        return snMap;
    }

    private static Map<Integer, SNIServerName> parseExtensions(ByteBuffer input) throws IOException {
        int extLen;
        for (int length = SslUtil.getInt16(input); length > 0; length -= extLen + 4) {
            int extType = SslUtil.getInt16(input);
            extLen = SslUtil.getInt16(input);
            if (extType == 0) {
                return SslUtil.exploreSNIExt(input, extLen);
            }
            SslUtil.ignoreByteVector(input, extLen);
        }
        return Collections.emptyMap();
    }

    private static Map<Integer, SNIServerName> exploreSNIExt(ByteBuffer input, int extLen) throws IOException {
        LinkedHashMap<Integer, SNIServerName> sniMap = new LinkedHashMap<Integer, SNIServerName>();
        int remains = extLen;
        if (extLen >= 2) {
            int listLen = SslUtil.getInt16(input);
            if (listLen == 0 || listLen + 2 != extLen) {
                throw new SSLProtocolException("Invalid server name indication extension");
            }
            remains -= 2;
            while (remains > 0) {
                SNIServerName serverName;
                int code = SslUtil.getInt8(input);
                int snLen = SslUtil.getInt16(input);
                if (snLen > remains) {
                    throw new SSLProtocolException("Not enough data to fill declared vector size");
                }
                byte[] encoded = new byte[snLen];
                input.get(encoded);
                if (code == 0) {
                    if (encoded.length == 0) {
                        throw new SSLProtocolException("Empty HostName in server name indication");
                    }
                    try {
                        serverName = new SNIHostName(encoded);
                    }
                    catch (IllegalArgumentException e) {
                        serverName = new UnknownServerName(code, encoded);
                    }
                } else {
                    serverName = new UnknownServerName(code, encoded);
                }
                if (sniMap.put(serverName.getType(), serverName) != null) {
                    throw new SSLProtocolException("Duplicated server name of type " + serverName.getType());
                }
                remains -= encoded.length + 3;
            }
        } else if (extLen == 0) {
            throw new SSLProtocolException("Not server name indication extension in client");
        }
        if (remains != 0) {
            throw new SSLProtocolException("Invalid server name indication extension");
        }
        return Collections.unmodifiableMap(sniMap);
    }

    private static int getInt8(ByteBuffer input) {
        return input.get();
    }

    private static int getInt16(ByteBuffer input) {
        return (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static int getInt24(ByteBuffer input) {
        return (input.get() & 0xFF) << 16 | (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static void ignoreByteVector8(ByteBuffer input) {
        SslUtil.ignoreByteVector(input, SslUtil.getInt8(input));
    }

    private static void ignoreByteVector16(ByteBuffer input) {
        SslUtil.ignoreByteVector(input, SslUtil.getInt16(input));
    }

    private static void ignoreByteVector24(ByteBuffer input) {
        SslUtil.ignoreByteVector(input, SslUtil.getInt24(input));
    }

    private static void ignoreByteVector(ByteBuffer input, int length) {
        if (length != 0) {
            int position = input.position();
            input.position(position + length);
        }
    }

    static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int code, byte[] encoded) {
            super(code, encoded);
        }
    }
}

