/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.PushTelemetryRequestData;
import org.apache.kafka.common.message.PushTelemetryResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.PushTelemetryResponse;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryUtils;

public class PushTelemetryRequest
extends AbstractRequest {
    private static final String OTLP_CONTENT_TYPE = "OTLP";
    private final PushTelemetryRequestData data;

    public PushTelemetryRequest(PushTelemetryRequestData data, short version) {
        super(ApiKeys.PUSH_TELEMETRY, version);
        this.data = data;
    }

    @Override
    public PushTelemetryResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.errorResponse(throttleTimeMs, Errors.forException(e));
    }

    @Override
    public PushTelemetryRequestData data() {
        return this.data;
    }

    public PushTelemetryResponse errorResponse(int throttleTimeMs, Errors errors) {
        PushTelemetryResponseData responseData = new PushTelemetryResponseData();
        responseData.setErrorCode(errors.code());
        responseData.setThrottleTimeMs(throttleTimeMs);
        return new PushTelemetryResponse(responseData);
    }

    public String metricsContentType() {
        return OTLP_CONTENT_TYPE;
    }

    public ByteBuffer metricsData() {
        CompressionType cType = CompressionType.forId(this.data.compressionType());
        return cType == CompressionType.NONE ? this.data.metrics() : ClientTelemetryUtils.decompress(this.data.metrics(), cType);
    }

    public static PushTelemetryRequest parse(Readable readable, short version, MessageContext context) {
        return new PushTelemetryRequest(new PushTelemetryRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<PushTelemetryRequest> {
        private final PushTelemetryRequestData data;

        public Builder(PushTelemetryRequestData data) {
            this(data, false);
        }

        public Builder(PushTelemetryRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.PUSH_TELEMETRY, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public PushTelemetryRequest build(short version) {
            return new PushTelemetryRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

