/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetrieverFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidatorFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerLoginCallbackHandler.class);
    public static final String CLIENT_ID_CONFIG = "clientId";
    public static final String CLIENT_SECRET_CONFIG = "clientSecret";
    public static final String SCOPE_CONFIG = "scope";
    public static final String CLIENT_ID_DOC = "The OAuth/OIDC identity provider-issued client ID to uniquely identify the service account to use for authentication for this client. The value must be paired with a corresponding clientSecret value and is provided to the OAuth provider using the OAuth clientcredentials grant type.";
    public static final String CLIENT_SECRET_DOC = "The OAuth/OIDC identity provider-issued client secret serves a similar function as a password to the clientId account and identifies the service account to use for authentication for this client. The value must be paired with a corresponding clientId value and is provided to the OAuth provider using the OAuth clientcredentials grant type.";
    public static final String SCOPE_DOC = "The (optional) HTTP/HTTPS login request to the token endpoint (sasl.oauthbearer.token.endpoint.url) may need to specify an OAuth \"scope\". If so, the scope is used to provide the value to include with the login request.";
    private static final String EXTENSION_PREFIX = "extension_";
    private Map<String, Object> moduleOptions;
    private AccessTokenRetriever accessTokenRetriever;
    private AccessTokenValidator accessTokenValidator;
    private boolean isInitialized = false;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.moduleOptions = JaasOptionsUtils.getOptions(saslMechanism, jaasConfigEntries);
        AccessTokenRetriever accessTokenRetriever = AccessTokenRetrieverFactory.create(configs, saslMechanism, this.moduleOptions);
        AccessTokenValidator accessTokenValidator = AccessTokenValidatorFactory.create(configs, saslMechanism);
        this.init(accessTokenRetriever, accessTokenValidator);
    }

    public void init(AccessTokenRetriever accessTokenRetriever, AccessTokenValidator accessTokenValidator) {
        this.accessTokenRetriever = accessTokenRetriever;
        this.accessTokenValidator = accessTokenValidator;
        try {
            this.accessTokenRetriever.init();
        }
        catch (IOException e) {
            throw new KafkaException("The OAuth login configuration encountered an error when initializing the AccessTokenRetriever", e);
        }
        this.isInitialized = true;
    }

    AccessTokenRetriever getAccessTokenRetriever() {
        return this.accessTokenRetriever;
    }

    @Override
    public void close() {
        if (this.accessTokenRetriever != null) {
            try {
                this.accessTokenRetriever.close();
            }
            catch (IOException e) {
                log.warn("The OAuth login configuration encountered an error when closing the AccessTokenRetriever", (Throwable)e);
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.checkInitialized();
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                this.handleTokenCallback((OAuthBearerTokenCallback)callback);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                this.handleExtensionsCallback((SaslExtensionsCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void handleTokenCallback(OAuthBearerTokenCallback callback) throws IOException {
        this.checkInitialized();
        String accessToken = this.accessTokenRetriever.retrieve();
        try {
            OAuthBearerToken token = this.accessTokenValidator.validate(accessToken);
            callback.token(token);
        }
        catch (ValidateException e) {
            log.warn(e.getMessage(), (Throwable)e);
            callback.error("invalid_token", e.getMessage(), null);
        }
    }

    private void handleExtensionsCallback(SaslExtensionsCallback callback) {
        this.checkInitialized();
        HashMap<String, String> extensions = new HashMap<String, String>();
        for (Map.Entry<String, Object> configEntry : this.moduleOptions.entrySet()) {
            String key = configEntry.getKey();
            if (!key.startsWith(EXTENSION_PREFIX)) continue;
            Object valueRaw = configEntry.getValue();
            String value = valueRaw instanceof String ? (String)valueRaw : String.valueOf(valueRaw);
            extensions.put(key.substring(EXTENSION_PREFIX.length()), value);
        }
        SaslExtensions saslExtensions = new SaslExtensions(extensions);
        try {
            OAuthBearerClientInitialResponse.validateExtensions(saslExtensions);
        }
        catch (SaslException e) {
            throw new ConfigException(e.getMessage());
        }
        callback.extensions(saslExtensions);
    }

    private void checkInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException(String.format("To use %s, first call the configure or init method", this.getClass().getSimpleName()));
        }
    }

    protected void setModuleOptions(Map<String, Object> moduleOptions) {
        this.moduleOptions = moduleOptions;
    }
}

