/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.SampledLogAction;
import org.apache.kafka.common.utils.TimeBasedSampler;

public class AdaptiveSampler
implements TimeBasedSampler {
    private static final long NANOS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    private final long samplesPerMinute;
    private final boolean isDefaultSampler;
    private long lastSampleTimeNanos = 0L;
    private long numRequestsSinceLastSample = 0L;
    private long intervalStartNanos = 0L;
    private long numIntervalRequests = 0L;
    private long numIntervalSamples = 0L;
    private long estimatedRequestsPerSample = 1L;

    public AdaptiveSampler(boolean isDefaultSampler, long samplesPerMin) {
        if (samplesPerMin <= 0L) {
            throw new IllegalArgumentException("The number of samples per minute must be greater than 0");
        }
        this.isDefaultSampler = isDefaultSampler;
        this.samplesPerMinute = samplesPerMin;
    }

    @Override
    public LogAction maybeSample(long requestTimeNanos) {
        if (requestTimeNanos - this.intervalStartNanos > NANOS_PER_MINUTE) {
            this.estimatedRequestsPerSample = Math.max(this.numIntervalRequests / this.samplesPerMinute, 1L);
            this.numIntervalRequests = 0L;
            this.numIntervalSamples = 0L;
            this.intervalStartNanos = requestTimeNanos;
        }
        ++this.numIntervalRequests;
        if (this.numIntervalSamples < this.samplesPerMinute && this.numIntervalRequests % this.estimatedRequestsPerSample == 0L) {
            ++this.numIntervalSamples;
            SampledLogAction requestLogAction = this.lastSampleTimeNanos == 0L ? new SampledLogAction(this.isDefaultSampler, 0L, 0L) : new SampledLogAction(this.isDefaultSampler, requestTimeNanos - this.lastSampleTimeNanos, this.numRequestsSinceLastSample);
            this.lastSampleTimeNanos = requestTimeNanos;
            this.numRequestsSinceLastSample = 0L;
            return requestLogAction;
        }
        ++this.numRequestsSinceLastSample;
        return LogAction.NOT_LOGGED;
    }
}

