/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class LogContext {
    private final String logPrefix;
    private final AtomicReference<Level> maxLogLevel;

    public LogContext(String logPrefix, AtomicReference<Level> maxLogLevel) {
        this.logPrefix = logPrefix == null ? "" : logPrefix;
        this.maxLogLevel = maxLogLevel;
    }

    public LogContext(String logPrefix) {
        this(logPrefix, null);
    }

    public LogContext() {
        this("");
    }

    public Logger logger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        if (this.maxLogLevel != null) {
            return this.loggerWithLogLevelOverride(logger);
        }
        if (logger instanceof LocationAwareLogger) {
            return new LocationAwareKafkaLogger(this.logPrefix, (LocationAwareLogger)logger);
        }
        return new LocationIgnorantKafkaLogger(this.logPrefix, logger);
    }

    Logger loggerWithLogLevelOverride(Logger logger) {
        if (logger instanceof LocationAwareLogger) {
            return new LocationAwareKafkaLogger(this.logPrefix, (LocationAwareLogger)logger){

                @Override
                protected void writeLog(Marker marker, int level, String format, Object[] args, Throwable exception) {
                    int logLevel = LogContext.this.maxLogLevel == null || LogContext.this.maxLogLevel.get() == null ? level : Math.min(LogContext.this.maxLogLevel.get().toInt(), level);
                    super.writeLog(marker, logLevel, format, args, exception);
                }
            };
        }
        return new LocationIgnorantKafkaLogger(this.logPrefix, logger, this.maxLogLevel);
    }

    public String logPrefix() {
        return this.logPrefix;
    }

    private static class LocationAwareKafkaLogger
    extends AbstractKafkaLogger {
        private final LocationAwareLogger logger;
        private final String fqcn;

        LocationAwareKafkaLogger(String logPrefix, LocationAwareLogger logger) {
            super(logPrefix);
            this.logger = logger;
            this.fqcn = LocationAwareKafkaLogger.class.getName();
        }

        public String getName() {
            return this.logger.getName();
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        public void trace(String message) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, message, null, null);
            }
        }

        public void trace(String format, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, format, new Object[]{arg}, null);
            }
        }

        public void trace(String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, format, new Object[]{arg1, arg2}, null);
            }
        }

        public void trace(String format, Object ... args) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, format, args, null);
            }
        }

        public void trace(String msg, Throwable t2) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, msg, null, t2);
            }
        }

        public void trace(Marker marker, String msg) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, msg, null, null);
            }
        }

        public void trace(Marker marker, String format, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, format, new Object[]{arg}, null);
            }
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, format, new Object[]{arg1, arg2}, null);
            }
        }

        public void trace(Marker marker, String format, Object ... argArray) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, format, argArray, null);
            }
        }

        public void trace(Marker marker, String msg, Throwable t2) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, msg, null, t2);
            }
        }

        public void debug(String message) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, message, null, null);
            }
        }

        public void debug(String format, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, format, new Object[]{arg}, null);
            }
        }

        public void debug(String format, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, format, new Object[]{arg1, arg2}, null);
            }
        }

        public void debug(String format, Object ... args) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, format, args, null);
            }
        }

        public void debug(String msg, Throwable t2) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, msg, null, t2);
            }
        }

        public void debug(Marker marker, String msg) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, msg, null, null);
            }
        }

        public void debug(Marker marker, String format, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, format, new Object[]{arg}, null);
            }
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, format, new Object[]{arg1, arg2}, null);
            }
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, format, arguments, null);
            }
        }

        public void debug(Marker marker, String msg, Throwable t2) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, msg, null, t2);
            }
        }

        public void warn(String message) {
            this.writeLog(null, 30, message, null, null);
        }

        public void warn(String format, Object arg) {
            this.writeLog(null, 30, format, new Object[]{arg}, null);
        }

        public void warn(String message, Object arg1, Object arg2) {
            this.writeLog(null, 30, message, new Object[]{arg1, arg2}, null);
        }

        public void warn(String format, Object ... args) {
            this.writeLog(null, 30, format, args, null);
        }

        public void warn(String msg, Throwable t2) {
            this.writeLog(null, 30, msg, null, t2);
        }

        public void warn(Marker marker, String msg) {
            this.writeLog(marker, 30, msg, null, null);
        }

        public void warn(Marker marker, String format, Object arg) {
            this.writeLog(marker, 30, format, new Object[]{arg}, null);
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.writeLog(marker, 30, format, new Object[]{arg1, arg2}, null);
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.writeLog(marker, 30, format, arguments, null);
        }

        public void warn(Marker marker, String msg, Throwable t2) {
            this.writeLog(marker, 30, msg, null, t2);
        }

        public void error(String message) {
            this.writeLog(null, 40, message, null, null);
        }

        public void error(String format, Object arg) {
            this.writeLog(null, 40, format, new Object[]{arg}, null);
        }

        public void error(String format, Object arg1, Object arg2) {
            this.writeLog(null, 40, format, new Object[]{arg1, arg2}, null);
        }

        public void error(String format, Object ... args) {
            this.writeLog(null, 40, format, args, null);
        }

        public void error(String msg, Throwable t2) {
            this.writeLog(null, 40, msg, null, t2);
        }

        public void error(Marker marker, String msg) {
            this.writeLog(marker, 40, msg, null, null);
        }

        public void error(Marker marker, String format, Object arg) {
            this.writeLog(marker, 40, format, new Object[]{arg}, null);
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.writeLog(marker, 40, format, new Object[]{arg1, arg2}, null);
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.writeLog(marker, 40, format, arguments, null);
        }

        public void error(Marker marker, String msg, Throwable t2) {
            this.writeLog(marker, 40, msg, null, t2);
        }

        public void info(String msg) {
            this.writeLog(null, 20, msg, null, null);
        }

        public void info(String format, Object arg) {
            this.writeLog(null, 20, format, new Object[]{arg}, null);
        }

        public void info(String format, Object arg1, Object arg2) {
            this.writeLog(null, 20, format, new Object[]{arg1, arg2}, null);
        }

        public void info(String format, Object ... args) {
            this.writeLog(null, 20, format, args, null);
        }

        public void info(String msg, Throwable t2) {
            this.writeLog(null, 20, msg, null, t2);
        }

        public void info(Marker marker, String msg) {
            this.writeLog(marker, 20, msg, null, null);
        }

        public void info(Marker marker, String format, Object arg) {
            this.writeLog(marker, 20, format, new Object[]{arg}, null);
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.writeLog(marker, 20, format, new Object[]{arg1, arg2}, null);
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.writeLog(marker, 20, format, arguments, null);
        }

        public void info(Marker marker, String msg, Throwable t2) {
            this.writeLog(marker, 20, msg, null, t2);
        }

        protected void writeLog(Marker marker, int level, String format, Object[] args, Throwable exception) {
            String message = format;
            if (args != null && args.length > 0) {
                FormattingTuple formatted = MessageFormatter.arrayFormat((String)format, (Object[])args);
                if (exception == null && formatted.getThrowable() != null) {
                    exception = formatted.getThrowable();
                }
                message = formatted.getMessage();
            }
            this.logger.log(marker, this.fqcn, level, this.addPrefix(message), null, exception);
        }
    }

    private static class LocationIgnorantKafkaLogger
    extends AbstractKafkaLogger {
        private final Logger logger;
        private final AtomicReference<Level> maxLogLevel;

        LocationIgnorantKafkaLogger(String logPrefix, Logger logger) {
            this(logPrefix, logger, new AtomicReference<Level>());
        }

        LocationIgnorantKafkaLogger(String logPrefix, Logger logger, AtomicReference<Level> maxLogLevel) {
            super(logPrefix);
            this.logger = logger;
            this.maxLogLevel = maxLogLevel;
        }

        public String getName() {
            return this.logger.getName();
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        public void trace(String message) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, this.addPrefix(message));
            }
        }

        public void trace(String message, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, this.addPrefix(message), arg);
            }
        }

        public void trace(String message, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, this.addPrefix(message), arg1, arg2);
            }
        }

        public void trace(String message, Object ... args) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, this.addPrefix(message), args);
            }
        }

        public void trace(String msg, Throwable t2) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, this.addPrefix(msg), t2);
            }
        }

        public void trace(Marker marker, String msg) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, marker, this.addPrefix(msg));
            }
        }

        public void trace(Marker marker, String format, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, marker, this.addPrefix(format), arg);
            }
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, marker, this.addPrefix(format), arg1, arg2);
            }
        }

        public void trace(Marker marker, String format, Object ... argArray) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, marker, this.addPrefix(format), argArray);
            }
        }

        public void trace(Marker marker, String msg, Throwable t2) {
            if (this.logger.isTraceEnabled()) {
                this.log(Level.TRACE, marker, this.addPrefix(msg), t2);
            }
        }

        public void debug(String message) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, this.addPrefix(message));
            }
        }

        public void debug(String message, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, this.addPrefix(message), arg);
            }
        }

        public void debug(String message, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, this.addPrefix(message), arg1, arg2);
            }
        }

        public void debug(String message, Object ... args) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, this.addPrefix(message), args);
            }
        }

        public void debug(String msg, Throwable t2) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, this.addPrefix(msg), t2);
            }
        }

        public void debug(Marker marker, String msg) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, marker, this.addPrefix(msg));
            }
        }

        public void debug(Marker marker, String format, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, marker, this.addPrefix(format), arg);
            }
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, marker, this.addPrefix(format), arg1, arg2);
            }
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, marker, this.addPrefix(format), arguments);
            }
        }

        public void debug(Marker marker, String msg, Throwable t2) {
            if (this.logger.isDebugEnabled()) {
                this.log(Level.DEBUG, marker, this.addPrefix(msg), t2);
            }
        }

        public void warn(String message) {
            this.log(Level.WARN, this.addPrefix(message));
        }

        public void warn(String message, Object arg) {
            this.log(Level.WARN, this.addPrefix(message), arg);
        }

        public void warn(String message, Object arg1, Object arg2) {
            this.log(Level.WARN, this.addPrefix(message), arg1, arg2);
        }

        public void warn(String message, Object ... args) {
            this.log(Level.WARN, this.addPrefix(message), args);
        }

        public void warn(String msg, Throwable t2) {
            this.log(Level.WARN, this.addPrefix(msg), t2);
        }

        public void warn(Marker marker, String msg) {
            this.log(Level.WARN, marker, this.addPrefix(msg));
        }

        public void warn(Marker marker, String format, Object arg) {
            this.log(Level.WARN, marker, this.addPrefix(format), arg);
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.log(Level.WARN, marker, this.addPrefix(format), arg1, arg2);
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.log(Level.WARN, marker, this.addPrefix(format), arguments);
        }

        public void warn(Marker marker, String msg, Throwable t2) {
            this.log(Level.WARN, marker, this.addPrefix(msg), t2);
        }

        public void error(String message) {
            this.log(Level.ERROR, this.addPrefix(message));
        }

        public void error(String message, Object arg) {
            this.log(Level.ERROR, this.addPrefix(message), arg);
        }

        public void error(String message, Object arg1, Object arg2) {
            this.log(Level.ERROR, this.addPrefix(message), arg1, arg2);
        }

        public void error(String message, Object ... args) {
            this.log(Level.ERROR, this.addPrefix(message), args);
        }

        public void error(String msg, Throwable t2) {
            this.log(Level.ERROR, this.addPrefix(msg), t2);
        }

        public void error(Marker marker, String msg) {
            this.log(Level.ERROR, marker, this.addPrefix(msg));
        }

        public void error(Marker marker, String format, Object arg) {
            this.log(Level.ERROR, marker, this.addPrefix(format), arg);
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.log(Level.ERROR, marker, this.addPrefix(format), arg1, arg2);
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.log(Level.ERROR, marker, this.addPrefix(format), arguments);
        }

        public void error(Marker marker, String msg, Throwable t2) {
            this.log(Level.ERROR, marker, this.addPrefix(msg), t2);
        }

        public void info(String message) {
            this.log(Level.INFO, this.addPrefix(message));
        }

        public void info(String message, Object arg) {
            this.log(Level.INFO, this.addPrefix(message), arg);
        }

        public void info(String message, Object arg1, Object arg2) {
            this.log(Level.INFO, this.addPrefix(message), arg1, arg2);
        }

        public void info(String message, Object ... args) {
            this.log(Level.INFO, this.addPrefix(message), args);
        }

        public void info(String msg, Throwable t2) {
            this.log(Level.INFO, this.addPrefix(msg), t2);
        }

        public void info(Marker marker, String msg) {
            this.log(Level.INFO, marker, this.addPrefix(msg));
        }

        public void info(Marker marker, String format, Object arg) {
            this.log(Level.INFO, marker, this.addPrefix(format), arg);
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.log(Level.INFO, marker, this.addPrefix(format), arg1, arg2);
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.log(Level.INFO, marker, this.addPrefix(format), arguments);
        }

        public void info(Marker marker, String msg, Throwable t2) {
            this.log(Level.INFO, marker, this.addPrefix(msg), t2);
        }

        private Level logLevel(Level requestedLevel) {
            int level = this.maxLogLevel == null || this.maxLogLevel.get() == null ? requestedLevel.toInt() : Math.min(this.maxLogLevel.get().toInt(), requestedLevel.toInt());
            return Stream.of(Level.values()).filter(l -> l.toInt() == level).findFirst().orElse(Level.ERROR);
        }

        private void log(Level level, String prefixedMessage) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(prefixedMessage);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(prefixedMessage);
                    break;
                }
                case INFO: {
                    this.logger.info(prefixedMessage);
                    break;
                }
                case WARN: {
                    this.logger.warn(prefixedMessage);
                    break;
                }
                case ERROR: {
                    this.logger.error(prefixedMessage);
                    break;
                }
                default: {
                    this.logger.error(prefixedMessage);
                }
            }
        }

        private void log(Level level, String prefixedMessage, Object arg) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(prefixedMessage, arg);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(prefixedMessage, arg);
                    break;
                }
                case INFO: {
                    this.logger.info(prefixedMessage, arg);
                    break;
                }
                case WARN: {
                    this.logger.warn(prefixedMessage, arg);
                    break;
                }
                case ERROR: {
                    this.logger.error(prefixedMessage, arg);
                    break;
                }
                default: {
                    this.logger.error(prefixedMessage, arg);
                }
            }
        }

        private void log(Level level, String prefixedMessage, Object arg1, Object arg2) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(prefixedMessage, arg1, arg2);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(prefixedMessage, arg1, arg2);
                    break;
                }
                case INFO: {
                    this.logger.info(prefixedMessage, arg1, arg2);
                    break;
                }
                case WARN: {
                    this.logger.warn(prefixedMessage, arg1, arg2);
                    break;
                }
                case ERROR: {
                    this.logger.error(prefixedMessage, arg1, arg2);
                    break;
                }
                default: {
                    this.logger.error(prefixedMessage, arg1, arg2);
                }
            }
        }

        private void log(Level level, String prefixedMessage, Object ... args) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(prefixedMessage, args);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(prefixedMessage, args);
                    break;
                }
                case INFO: {
                    this.logger.info(prefixedMessage, args);
                    break;
                }
                case WARN: {
                    this.logger.warn(prefixedMessage, args);
                    break;
                }
                case ERROR: {
                    this.logger.error(prefixedMessage, args);
                    break;
                }
                default: {
                    this.logger.error(prefixedMessage, args);
                }
            }
        }

        private void log(Level level, String prefixedMessage, Throwable t2) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(prefixedMessage, t2);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(prefixedMessage, t2);
                    break;
                }
                case INFO: {
                    this.logger.info(prefixedMessage, t2);
                    break;
                }
                case WARN: {
                    this.logger.warn(prefixedMessage, t2);
                    break;
                }
                case ERROR: {
                    this.logger.error(prefixedMessage, t2);
                    break;
                }
                default: {
                    this.logger.error(prefixedMessage, t2);
                }
            }
        }

        private void log(Level level, Marker marker, String prefixedMessage) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(marker, prefixedMessage);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(marker, prefixedMessage);
                    break;
                }
                case INFO: {
                    this.logger.info(marker, prefixedMessage);
                    break;
                }
                case WARN: {
                    this.logger.warn(marker, prefixedMessage);
                    break;
                }
                case ERROR: {
                    this.logger.error(marker, prefixedMessage);
                    break;
                }
                default: {
                    this.logger.error(marker, prefixedMessage);
                }
            }
        }

        private void log(Level level, Marker marker, String prefixedFormat, Object arg) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(marker, prefixedFormat, arg);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(marker, prefixedFormat, arg);
                    break;
                }
                case INFO: {
                    this.logger.info(marker, prefixedFormat, arg);
                    break;
                }
                case WARN: {
                    this.logger.warn(marker, prefixedFormat, arg);
                    break;
                }
                case ERROR: {
                    this.logger.error(marker, prefixedFormat, arg);
                    break;
                }
                default: {
                    this.logger.error(marker, prefixedFormat, arg);
                }
            }
        }

        private void log(Level level, Marker marker, String prefixedFormat, Object arg1, Object arg2) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(marker, prefixedFormat, arg1, arg2);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(marker, prefixedFormat, arg1, arg2);
                    break;
                }
                case INFO: {
                    this.logger.info(marker, prefixedFormat, arg1, arg2);
                    break;
                }
                case WARN: {
                    this.logger.warn(marker, prefixedFormat, arg1, arg2);
                    break;
                }
                case ERROR: {
                    this.logger.error(marker, prefixedFormat, arg1, arg2);
                    break;
                }
                default: {
                    this.logger.error(marker, prefixedFormat, arg1, arg2);
                }
            }
        }

        private void log(Level level, Marker marker, String prefixedFormat, Object ... args) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(marker, prefixedFormat, args);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(marker, prefixedFormat, args);
                    break;
                }
                case INFO: {
                    this.logger.info(marker, prefixedFormat, args);
                    break;
                }
                case WARN: {
                    this.logger.warn(marker, prefixedFormat, args);
                    break;
                }
                case ERROR: {
                    this.logger.error(marker, prefixedFormat, args);
                    break;
                }
                default: {
                    this.logger.error(marker, prefixedFormat, args);
                }
            }
        }

        private void log(Level level, Marker marker, String prefixedMessage, Throwable t2) {
            switch (this.logLevel(level)) {
                case TRACE: {
                    this.logger.trace(marker, prefixedMessage, t2);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(marker, prefixedMessage, t2);
                    break;
                }
                case INFO: {
                    this.logger.info(marker, prefixedMessage, t2);
                    break;
                }
                case WARN: {
                    this.logger.warn(marker, prefixedMessage, t2);
                    break;
                }
                case ERROR: {
                    this.logger.error(marker, prefixedMessage, t2);
                    break;
                }
                default: {
                    this.logger.error(marker, prefixedMessage, t2);
                }
            }
        }
    }

    private static abstract class AbstractKafkaLogger
    implements Logger {
        private final String prefix;

        protected AbstractKafkaLogger(String prefix) {
            this.prefix = prefix;
        }

        protected String addPrefix(String message) {
            return this.prefix + message;
        }
    }
}

