/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.MessageUtil;

public class RequestHeaderDataJsonConverter {
    public static RequestHeaderData read(JsonNode _node, short _version) {
        RequestHeaderData _object = new RequestHeaderData();
        JsonNode _requestApiKeyNode = _node.get("requestApiKey");
        if (_requestApiKeyNode == null) {
            throw new RuntimeException("RequestHeaderData: unable to locate field 'requestApiKey', which is mandatory in version " + _version);
        }
        _object.requestApiKey = MessageUtil.jsonNodeToShort(_requestApiKeyNode, "RequestHeaderData");
        JsonNode _requestApiVersionNode = _node.get("requestApiVersion");
        if (_requestApiVersionNode == null) {
            throw new RuntimeException("RequestHeaderData: unable to locate field 'requestApiVersion', which is mandatory in version " + _version);
        }
        _object.requestApiVersion = MessageUtil.jsonNodeToShort(_requestApiVersionNode, "RequestHeaderData");
        JsonNode _correlationIdNode = _node.get("correlationId");
        if (_correlationIdNode == null) {
            throw new RuntimeException("RequestHeaderData: unable to locate field 'correlationId', which is mandatory in version " + _version);
        }
        _object.correlationId = MessageUtil.jsonNodeToInt(_correlationIdNode, "RequestHeaderData");
        JsonNode _clientIdNode = _node.get("clientId");
        if (_clientIdNode == null) {
            throw new RuntimeException("RequestHeaderData: unable to locate field 'clientId', which is mandatory in version " + _version);
        }
        if (_clientIdNode.isNull()) {
            _object.clientId = null;
        } else {
            if (!_clientIdNode.isTextual()) {
                throw new RuntimeException("RequestHeaderData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.clientId = _clientIdNode.asText();
        }
        JsonNode _clusterLinkIdNode = _node.get("clusterLinkId");
        if (_clusterLinkIdNode == null) {
            _object.clusterLinkId = Uuid.ZERO_UUID;
        } else {
            if (!_clusterLinkIdNode.isTextual()) {
                throw new RuntimeException("RequestHeaderData expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.clusterLinkId = Uuid.fromString(_clusterLinkIdNode.asText());
        }
        JsonNode _traceContextNode = _node.get("traceContext");
        _object.traceContext = _traceContextNode == null ? new RequestHeaderData.TraceContext() : TraceContextJsonConverter.read(_traceContextNode, _version);
        JsonNode _clusterLinkTenantNode = _node.get("clusterLinkTenant");
        if (_clusterLinkTenantNode == null) {
            _object.clusterLinkTenant = "";
        } else if (_clusterLinkTenantNode.isNull()) {
            _object.clusterLinkTenant = null;
        } else {
            if (!_clusterLinkTenantNode.isTextual()) {
                throw new RuntimeException("RequestHeaderData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.clusterLinkTenant = _clusterLinkTenantNode.asText();
        }
        return _object;
    }

    public static JsonNode write(RequestHeaderData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("requestApiKey", (JsonNode)new ShortNode(_object.requestApiKey));
        _node.set("requestApiVersion", (JsonNode)new ShortNode(_object.requestApiVersion));
        _node.set("correlationId", (JsonNode)new IntNode(_object.correlationId));
        if (_object.clientId == null) {
            _node.set("clientId", (JsonNode)NullNode.instance);
        } else {
            _node.set("clientId", (JsonNode)new TextNode(_object.clientId));
        }
        if (_version >= 2 && !_object.clusterLinkId.equals(Uuid.ZERO_UUID)) {
            _node.set("clusterLinkId", (JsonNode)new TextNode(_object.clusterLinkId.toString()));
        }
        if (_version >= 2 && !_object.traceContext.equals(new RequestHeaderData.TraceContext())) {
            _node.set("traceContext", TraceContextJsonConverter.write(_object.traceContext, _version, _serializeRecords));
        }
        if (_version >= 2) {
            if (_object.clusterLinkTenant == null || !_object.clusterLinkTenant.equals("")) {
                if (_object.clusterLinkTenant == null) {
                    _node.set("clusterLinkTenant", (JsonNode)NullNode.instance);
                } else {
                    _node.set("clusterLinkTenant", (JsonNode)new TextNode(_object.clusterLinkTenant));
                }
            }
        } else if (_object.clusterLinkTenant == null || !_object.clusterLinkTenant.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterLinkTenant at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(RequestHeaderData _object, short _version) {
        return RequestHeaderDataJsonConverter.write(_object, _version, true);
    }

    public static class TraceContextJsonConverter {
        public static RequestHeaderData.TraceContext read(JsonNode _node, short _version) {
            RequestHeaderData.TraceContext _object = new RequestHeaderData.TraceContext();
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TraceContext");
            }
            JsonNode _traceIdNode = _node.get("traceId");
            if (_traceIdNode == null) {
                throw new RuntimeException("TraceContext: unable to locate field 'traceId', which is mandatory in version " + _version);
            }
            _object.traceId = MessageUtil.jsonNodeToBinary(_traceIdNode, "TraceContext");
            JsonNode _parentSpanIdNode = _node.get("parentSpanId");
            if (_parentSpanIdNode == null) {
                throw new RuntimeException("TraceContext: unable to locate field 'parentSpanId', which is mandatory in version " + _version);
            }
            _object.parentSpanId = MessageUtil.jsonNodeToBinary(_parentSpanIdNode, "TraceContext");
            JsonNode _traceFlagsNode = _node.get("traceFlags");
            if (_traceFlagsNode == null) {
                throw new RuntimeException("TraceContext: unable to locate field 'traceFlags', which is mandatory in version " + _version);
            }
            _object.traceFlags = MessageUtil.jsonNodeToByte(_traceFlagsNode, "TraceContext");
            return _object;
        }

        public static JsonNode write(RequestHeaderData.TraceContext _object, short _version, boolean _serializeRecords) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TraceContext");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("traceId", (JsonNode)new BinaryNode(Arrays.copyOf(_object.traceId, _object.traceId.length)));
            _node.set("parentSpanId", (JsonNode)new BinaryNode(Arrays.copyOf(_object.parentSpanId, _object.parentSpanId.length)));
            _node.set("traceFlags", (JsonNode)new ShortNode((short)_object.traceFlags));
            return _node;
        }

        public static JsonNode write(RequestHeaderData.TraceContext _object, short _version) {
            return TraceContextJsonConverter.write(_object, _version, true);
        }
    }
}

