/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.kafka.common.network.InvalidReceiveException;
import org.apache.kafka.common.network.netty.ReadableByteBuf;

public class ByteBufReceive
implements AutoCloseable {
    private final CompositeByteBuf compositeBuf;
    private final int maxReceivedSize;
    private final ByteBuf size;
    private int requestSize = 0;

    public ByteBufReceive(ByteBufAllocator alloc, int maxReceivedSize) {
        this.maxReceivedSize = maxReceivedSize;
        this.size = alloc.buffer(4, 4);
        this.compositeBuf = alloc.compositeBuffer(Integer.MAX_VALUE);
    }

    @Override
    public void close() {
        this.size.release();
        this.compositeBuf.release();
    }

    public void readFrom(ByteBuf byteBuf) {
        int remainingBytesToRead;
        if (this.size.isWritable()) {
            this.readSize(byteBuf);
            if (!byteBuf.isReadable()) {
                return;
            }
        }
        if ((remainingBytesToRead = this.requestSize - this.compositeBuf.capacity()) < byteBuf.readableBytes()) {
            this.compositeBuf.addComponent(byteBuf.readRetainedSlice(remainingBytesToRead));
        } else {
            this.compositeBuf.addComponent(byteBuf.retain());
            byteBuf.readerIndex(byteBuf.writerIndex());
        }
        this.compositeBuf.writerIndex(this.compositeBuf.capacity());
    }

    private void readSize(ByteBuf byteBuf) {
        int byteToRead = Math.min(byteBuf.readableBytes(), this.size.writableBytes());
        byteBuf.readBytes(this.size, byteToRead);
        if (this.size.isWritable()) {
            return;
        }
        this.requestSize = this.size.readInt();
        if (this.requestSize < 0) {
            throw new InvalidReceiveException("Invalid request size: " + this.requestSize);
        }
        if (this.requestSize > this.maxReceivedSize) {
            throw new InvalidReceiveException("Request size is too large: " + this.requestSize);
        }
    }

    public boolean complete() {
        return !this.size.isWritable() && this.requestSize == this.compositeBuf.capacity();
    }

    public int size() {
        return this.requestSize + this.size.capacity();
    }

    public int requestSize() {
        return this.requestSize;
    }

    public int bytesRead() {
        if (this.size.isWritable()) {
            return this.size.writerIndex();
        }
        return this.compositeBuf.readableBytes() + this.size.capacity();
    }

    public ReadableByteBuf payload() {
        return new ReadableByteBuf((ByteBuf)this.compositeBuf);
    }

    public int refCnt() {
        return this.compositeBuf.refCnt();
    }
}

