/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.netty.K2PStreamMetadata;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class Http2AuthenticationContext
implements AuthenticationContext {
    private final SecurityProtocol securityProtocol;
    private final ListenerName listenerName;
    private final InetAddress clientAddress;
    private final long sessionId;
    private final Optional<Integer> clientPort;
    private final ClientInformation clientInformation;
    private final Optional<String> clientId;

    public Http2AuthenticationContext(K2PStreamMetadata streamMetadata, SecurityProtocol securityProtocol, ListenerName listenerName, long sessionId) throws UnknownHostException {
        this.securityProtocol = securityProtocol;
        this.listenerName = listenerName;
        this.sessionId = sessionId;
        this.clientAddress = InetAddress.getByName(streamMetadata.clientAddress());
        this.clientPort = Optional.ofNullable(streamMetadata.clientPort());
        this.clientInformation = streamMetadata.clientInformation();
        this.clientId = Optional.ofNullable(streamMetadata.clientId());
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    @Override
    public InetAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    public String listenerName() {
        return this.listenerName.value();
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    public Optional<Integer> clientPort() {
        return this.clientPort;
    }

    public ClientInformation clientInformation() {
        return this.clientInformation;
    }

    public Optional<String> clientId() {
        return this.clientId;
    }
}

