/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class NettyHttp2Connection {
    private final Logger log;
    private final LogContext logContext;
    private final Channel channel;
    private final ChannelGroup allChannels;
    private final Http2StreamChannelBootstrap streamChannelBootstrap;
    private final boolean flowControlEnabled;

    public NettyHttp2Connection(Channel channel, ChannelGroup allChannels, LogContext logContext, boolean flowControlEnabled) {
        this.channel = channel;
        this.streamChannelBootstrap = new Http2StreamChannelBootstrap(channel);
        this.allChannels = allChannels;
        this.log = logContext.logger(NettyHttp2Connection.class);
        this.logContext = logContext;
        this.flowControlEnabled = flowControlEnabled;
    }

    public Future<NettyHttp2Stream> createStream(Http2Headers http2Headers, NettyStream.StreamHandler handler) {
        Promise future = this.channel.eventLoop().newPromise();
        Future<NettyHttp2Stream> streamPromise = this.createStream(handler);
        streamPromise.addListener(Utils.exceptionSafe(future, listener -> {
            if (listener.isSuccess()) {
                NettyHttp2Stream stream = (NettyHttp2Stream)streamPromise.get();
                stream.sendHeaders(http2Headers).addListener(headerListener -> {
                    if (headerListener.isSuccess()) {
                        future.setSuccess((Object)stream);
                    } else {
                        future.setFailure(headerListener.cause());
                    }
                });
            } else {
                future.setFailure(listener.cause());
            }
        }));
        return future;
    }

    private Future<NettyHttp2Stream> createStream(NettyStream.StreamHandler handler) {
        Promise streamPromise = this.channel.eventLoop().newPromise();
        Future channelFuture = this.streamChannelBootstrap.open();
        channelFuture.addListener(Utils.exceptionSafe(streamPromise, future -> {
            if (future.isSuccess()) {
                Http2StreamChannel streamChannel = (Http2StreamChannel)channelFuture.get();
                this.allChannels.add((Object)streamChannel);
                NettyHttp2Stream nettyHttp2Stream = new NettyHttp2Stream(streamChannel, this.logContext, this.flowControlEnabled);
                streamChannel.pipeline().addLast(new ChannelHandler[]{new NettyHttp2Stream.NettyHttp2StreamHandler((NettyStream)nettyHttp2Stream, handler, this.logContext)});
                streamChannel.closeFuture().addListener(__ -> handler.handleClose());
                streamPromise.setSuccess((Object)nettyHttp2Stream);
            } else {
                this.log.error("Failed to create HTTP/2 stream", future.cause());
                streamPromise.setFailure(future.cause());
            }
        }));
        return streamPromise;
    }

    public Channel channel() {
        return this.channel;
    }

    public Future<Void> close() {
        this.log.debug("Closing channel {}", (Object)this.channel);
        ChannelFuture closeFuture = this.channel.close();
        closeFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.log.debug("Connection channel closed successfully {}", (Object)this.channel);
            } else {
                this.log.error("Failed to close connection channel {}", (Object)this.channel, (Object)future.cause());
            }
        });
        return closeFuture;
    }

    public String toString() {
        return "NettyHttp2Connection {channel = " + String.valueOf(this.channel) + "}";
    }
}

