/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.network.TransferableChannel;

public interface NettyStream {
    public String streamId();

    public SocketAddress remoteAddress();

    public SocketAddress localAddress();

    public Future<Void> send(ByteBuf var1, boolean var2);

    public void flush();

    public void receiveMore();

    public boolean isReadyForSending();

    public Future<Void> closeStream();

    public boolean isOpen();

    public ByteBufAllocator alloc();

    public Priority priority();

    public void setPriority(Priority var1);

    public void runOnEventLoop(Runnable var1, boolean var2);

    public boolean inEventLoop();

    public ScheduledFuture<?> scheduleWithDelayOnEventLoop(Runnable var1, long var2, TimeUnit var4);

    public TransferableChannel transferableChannel();

    default public Optional<SSLSession> sslSession() {
        return Optional.empty();
    }

    public void setStreamHandler(StreamHandler var1);

    public StreamHandler getStreamHandler();

    public static abstract class NoOpStreamHandler
    implements StreamHandler {
        @Override
        public void handleData(ByteBuf data) {
        }

        @Override
        public void handleReadyForSend() {
        }

        @Override
        public void handleException(Throwable t) {
        }

        @Override
        public void handleClose() {
        }
    }

    public static interface StreamHandler {
        public void handleData(ByteBuf var1);

        public void handleReadyForSend();

        public void handleException(Throwable var1);

        public void handleClose();
    }

    public static enum Priority {
        NORMAL,
        HIGH;

    }
}

