/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ShareAcknowledgeResponse
extends AbstractResponse {
    private final ShareAcknowledgeResponseData data;

    public ShareAcknowledgeResponse(ShareAcknowledgeResponseData data) {
        super(ApiKeys.SHARE_ACKNOWLEDGE);
        this.data = data;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public ShareAcknowledgeResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        ShareAcknowledgeResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.responses().forEach(topic -> topic.partitions().forEach(partition -> ShareAcknowledgeResponse.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ShareAcknowledgeResponse parse(Readable readable, short version, MessageContext context) {
        return new ShareAcknowledgeResponse(new ShareAcknowledgeResponseData(readable, version, context));
    }

    private static boolean matchingTopic(ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse previousTopic, TopicIdPartition currentTopic) {
        if (previousTopic == null) {
            return false;
        }
        return previousTopic.topicId().equals(currentTopic.topicId());
    }

    public static ShareAcknowledgeResponseData.PartitionData partitionResponse(TopicIdPartition topicIdPartition, Errors error) {
        return ShareAcknowledgeResponse.partitionResponse(topicIdPartition.topicPartition().partition(), error);
    }

    public static ShareAcknowledgeResponseData.PartitionData partitionResponse(int partition, Errors error) {
        return new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(error.code());
    }

    public static ShareAcknowledgeResponse of(Errors error, int throttleTimeMs, LinkedHashMap<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData> responseData, List<Node> nodeEndpoints) {
        return new ShareAcknowledgeResponse(ShareAcknowledgeResponse.toMessage(error, throttleTimeMs, responseData.entrySet().iterator(), nodeEndpoints));
    }

    public static ShareAcknowledgeResponseData toMessage(Errors error, int throttleTimeMs, Iterator<Map.Entry<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData>> partIterator, List<Node> nodeEndpoints) {
        ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponseCollection topicResponses = new ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponseCollection();
        while (partIterator.hasNext()) {
            Map.Entry<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData> entry = partIterator.next();
            ShareAcknowledgeResponseData.PartitionData partitionData = entry.getValue();
            partitionData.setPartitionIndex(entry.getKey().topicPartition().partition());
            ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse topicResponse = topicResponses.find(entry.getKey().topicId());
            if (topicResponse == null) {
                topicResponse = new ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse().setTopicId(entry.getKey().topicId()).setPartitions(new ArrayList<ShareAcknowledgeResponseData.PartitionData>());
                topicResponses.add(topicResponse);
            }
            topicResponse.partitions().add(partitionData);
        }
        ShareAcknowledgeResponseData data = new ShareAcknowledgeResponseData();
        nodeEndpoints.forEach(endpoint -> data.nodeEndpoints().add(new ShareAcknowledgeResponseData.NodeEndpoint().setNodeId(endpoint.id()).setHost(endpoint.host()).setPort(endpoint.port()).setRack(endpoint.rack())));
        return data.setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setResponses(topicResponses);
    }
}

