/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.InvalidReceiveException;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.ReauthenticationContext;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.authenticator.SaslAuthenticatorTransport;

public class SaslSocketServerTransport
implements SaslAuthenticatorTransport {
    private NetworkReceive netInBuffer = null;
    private Send netOutBuffer = null;
    private final TransportLayer transportLayer;
    private boolean shouldRestoreReadInterest = false;
    private final String connectionId;
    private NetworkReceive reauthenticationHandshakeRequest = null;

    public SaslSocketServerTransport(TransportLayer transportLayer, String connectionId) {
        this.transportLayer = transportLayer;
        this.connectionId = connectionId;
    }

    @Override
    public byte[] receiveClientTokenOrKafkaRequest(int maxInBufferSize) throws IOException {
        if (this.reauthenticationHandshakeRequest != null) {
            this.netInBuffer = this.reauthenticationHandshakeRequest;
            this.reauthenticationHandshakeRequest = null;
        } else {
            if (this.netInBuffer == null) {
                this.netInBuffer = new NetworkReceive(maxInBufferSize, this.connectionId);
            }
            try {
                this.netInBuffer.readFrom(this.transportLayer);
            }
            catch (InvalidReceiveException e) {
                throw new SaslAuthenticationException("Failing SASL authentication due to invalid receive size", e);
            }
            if (!this.netInBuffer.complete()) {
                return null;
            }
        }
        this.netInBuffer.payload().rewind();
        byte[] clientToken = new byte[this.netInBuffer.payload().remaining()];
        this.netInBuffer.payload().get(clientToken, 0, clientToken.length);
        this.netInBuffer = null;
        return clientToken;
    }

    @Override
    public void startReauthentication(ReauthenticationContext reauthenticationContext) {
        NetworkReceive saslHandshakeReceive = reauthenticationContext.networkReceive();
        if (saslHandshakeReceive == null) {
            throw new IllegalArgumentException("Invalid saslHandshakeReceive in server-side re-authentication context: null");
        }
        this.reauthenticationHandshakeRequest = saslHandshakeReceive;
    }

    @Override
    public void muteReading() {
        if ((this.transportLayer.selectionKey().interestOps() & 1) != 0) {
            this.transportLayer.removeInterestOps(1);
            this.shouldRestoreReadInterest = true;
        } else {
            this.shouldRestoreReadInterest = false;
        }
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return this.transportLayer instanceof SslTransportLayer ? Optional.of(((SslTransportLayer)this.transportLayer).sslSession()) : Optional.empty();
    }

    @Override
    public InetAddress serverAddress() {
        return this.transportLayer.socketChannel().socket().getLocalAddress();
    }

    @Override
    public InetAddress clientAddress() {
        return this.transportLayer.socketAddress();
    }

    @Override
    public int clientPort() {
        return this.transportLayer.socketChannel().socket().getPort();
    }

    @Override
    public boolean isProxyModeLocal() {
        return this.transportLayer.isProxyModeLocal();
    }

    @Override
    public Principal peerPrincipal() {
        if (this.transportLayer instanceof SslTransportLayer) {
            return ((SslTransportLayer)this.transportLayer).peerPrincipal();
        }
        throw new IllegalStateException("Transport layer is not an instance of SslTransportLayer");
    }

    @Override
    public void sendResponse(Send send) throws IOException {
        this.netOutBuffer = send;
        this.flushNetOutBufferAndUpdateInterestOps();
    }

    @Override
    public boolean finishInProgressSend() throws IOException {
        return this.netOutBuffer == null || this.flushNetOutBufferAndUpdateInterestOps();
    }

    @Override
    public boolean isSendInProgress() {
        return this.netOutBuffer != null && !this.netOutBuffer.completed();
    }

    private boolean flushNetOutBufferAndUpdateInterestOps() throws IOException {
        boolean flushedCompletely = this.flushNetOutBuffer();
        if (flushedCompletely) {
            if (this.shouldRestoreReadInterest) {
                this.transportLayer.addInterestOps(1);
            }
            this.transportLayer.removeInterestOps(4);
        } else {
            this.transportLayer.addInterestOps(4);
        }
        return flushedCompletely;
    }

    private boolean flushNetOutBuffer() throws IOException {
        if (!this.netOutBuffer.completed()) {
            this.netOutBuffer.writeTo(this.transportLayer);
        }
        return this.netOutBuffer.completed();
    }
}

