/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.util.function.Function;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOrJaas {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigOrJaas.class);
    private final ConfigurationUtils cu;
    private final JaasOptionsUtils jou;

    public ConfigOrJaas(ConfigurationUtils cu, JaasOptionsUtils jou) {
        this.cu = cu;
        this.jou = jou;
    }

    public String clientId() {
        return this.clientId(true);
    }

    public String clientId(boolean isRequired) {
        return this.getValue("sasl.oauthbearer.client.credentials.client.id", "clientId", isRequired, name -> this.cu.validateString((String)name, isRequired), name -> this.jou.validateString((String)name, isRequired));
    }

    public String clientSecret() {
        return this.getValue("sasl.oauthbearer.client.credentials.client.secret", "clientSecret", true, this.cu::validatePassword, this.jou::validateString);
    }

    public String scope() {
        return this.getValue("sasl.oauthbearer.scope", "scope", false, name -> this.cu.validateString((String)name, false), name -> this.jou.validateString((String)name, false));
    }

    private String getValue(String configName, String jaasName, boolean isRequired, Function<String, String> configValueGetter, Function<String, String> jaasValueGetter) {
        boolean isPresentInConfig = this.cu.containsKey(configName);
        boolean isPresentInJaas = this.jou.containsKey(jaasName);
        if (isPresentInConfig) {
            if (isPresentInJaas) {
                LOG.warn("Both the OAuth configuration {} as well as the JAAS option {} (from the {} configuration) were provided. Since the {} JAAS option is deprecated, it will be ignored and the value from the {} configuration will be used. Please update your configuration to only use {}.", new Object[]{configName, jaasName, "sasl.jaas.config", jaasName, configName, configName});
            }
            return configValueGetter.apply(configName);
        }
        if (isPresentInJaas) {
            String value = jaasValueGetter.apply(jaasName);
            LOG.warn("The OAuth JAAS option {} was configured in {}, but that JAAS option is deprecated and will be removed. Please update your configuration to use the {} configuration instead.", new Object[]{jaasName, "sasl.jaas.config", configName});
            return value;
        }
        if (isRequired) {
            throw new ConfigException(configName, (Object)null);
        }
        return null;
    }
}

