/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.TieredFragmentType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicIdAndPartition;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ResolveOffsetRangeResult {
    private final Map<TopicIdAndPartition, KafkaFuture<ResolveOffsetRangeResultInfo>> futures;

    public ResolveOffsetRangeResult(Map<TopicIdAndPartition, KafkaFuture<ResolveOffsetRangeResultInfo>> futures) {
        this.futures = futures;
    }

    public KafkaFuture<ResolveOffsetRangeResultInfo> partitionResult(TopicIdAndPartition partition) {
        KafkaFuture<ResolveOffsetRangeResultInfo> future = this.futures.get(partition);
        if (future == null) {
            throw new IllegalArgumentException("Resolve Offset Range for partition \"" + String.valueOf(partition) + "\" was not attempted");
        }
        return future;
    }

    public KafkaFuture<Map<TopicIdAndPartition, ResolveOffsetRangeResultInfo>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(v -> {
            HashMap<TopicIdAndPartition, ResolveOffsetRangeResultInfo> offsets = new HashMap<TopicIdAndPartition, ResolveOffsetRangeResultInfo>(this.futures.size());
            for (Map.Entry<TopicIdAndPartition, KafkaFuture<ResolveOffsetRangeResultInfo>> entry : this.futures.entrySet()) {
                try {
                    offsets.put(entry.getKey(), entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return offsets;
        });
    }

    public static class ResolveOffsetRangeResultInfo {
        private final List<TieredRange> tieredRanges;
        private final Optional<Long> brokerStartOffset;
        private final Optional<Long> brokerEndOffset;

        public ResolveOffsetRangeResultInfo(List<TieredRange> tieredRanges, Optional<Long> brokerStartOffset, Optional<Long> brokerEndOffset) {
            this.tieredRanges = tieredRanges;
            this.brokerStartOffset = brokerStartOffset;
            this.brokerEndOffset = brokerEndOffset;
        }

        public Optional<Long> brokerStartOffset() {
            return this.brokerStartOffset;
        }

        public Optional<Long> brokerEndOffset() {
            return this.brokerEndOffset;
        }

        public List<TieredRange> tieredRanges() {
            return this.tieredRanges;
        }

        public String toString() {
            return String.format("ResolveOffsetRangeResultInfo(brokerStartOffset=%s, brokerEndOffset=%s, tieredRanges=%s", this.brokerStartOffset, this.brokerEndOffset, this.tieredRanges.stream().map(TieredRange::toString).collect(Collectors.joining(", ")));
        }
    }

    public static class TieredFile {
        private final String objectLocator;
        private final long startPosition;
        private final long endPosition;
        private final TieredFragmentType fragmentType;

        public TieredFile(String objectLocator, long startPosition, long endPosition, TieredFragmentType fragmentType) {
            this.objectLocator = objectLocator;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.fragmentType = fragmentType;
        }

        public String objectLocator() {
            return this.objectLocator;
        }

        public long startPosition() {
            return this.startPosition;
        }

        public long endPosition() {
            return this.endPosition;
        }

        public TieredFragmentType fragmentType() {
            return this.fragmentType;
        }

        public String toString() {
            return String.format("TieredFile(objectLocator=%s, startPosition=%d, endPosition=%d, fragmentType=%s", new Object[]{this.objectLocator, this.startPosition, this.endPosition, this.fragmentType});
        }
    }

    public static class TieredRange {
        private final long startOffset;
        private final long endOffset;
        private final TieredFile segmentFile;
        private final TieredFile offsetIndex;
        private final Optional<TieredFile> transactionIndex;

        public TieredRange(long startOffset, long endOffset, TieredFile segmentFile, TieredFile offsetIndex, Optional<TieredFile> transactionIndex) {
            this.validateTieredFiles(segmentFile, offsetIndex, transactionIndex);
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.segmentFile = segmentFile;
            this.offsetIndex = offsetIndex;
            this.transactionIndex = transactionIndex;
        }

        private void validateTieredFiles(TieredFile segmentFile, TieredFile offsetIndex, Optional<TieredFile> transactionIndex) {
            if (segmentFile.fragmentType() != TieredFragmentType.SEGMENT) {
                throw new IllegalArgumentException("Segment file must be of type SEGMENT");
            }
            if (offsetIndex.fragmentType() != TieredFragmentType.OFFSET_INDEX) {
                throw new IllegalArgumentException("Offset index must be of type OFFSET_INDEX");
            }
            if (transactionIndex.isPresent() && transactionIndex.get().fragmentType() != TieredFragmentType.TRANSACTION_INDEX) {
                throw new IllegalArgumentException("Transaction index must be of type TRANSACTION_INDEX");
            }
        }

        public long startOffset() {
            return this.startOffset;
        }

        public long endOffset() {
            return this.endOffset;
        }

        public TieredFile segmentFile() {
            return this.segmentFile;
        }

        public TieredFile offsetIndex() {
            return this.offsetIndex;
        }

        public Optional<TieredFile> transactionIndex() {
            return this.transactionIndex;
        }

        public String toString() {
            return String.format("TieredRange(startOffset=%d, endOffset=%d, segmentFile=%s, offsetIndex=%s, transactionIndex=%s", this.startOffset, this.endOffset, this.segmentFile, this.offsetIndex, this.transactionIndex);
        }
    }
}

