/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeSwitchoverStatusResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    String linkName;
    Uuid linkId;
    String remoteClusterId;
    String localClusterId;
    byte switchoverState;
    short linkState;
    short remoteLinkState;
    byte switchoverType;
    short linkErrorCode;
    String linkErrorMessage;
    short remoteLinkErrorCode;
    String remoteLinkErrorMessage;
    List<TopicData> topics;
    List<TaskData> tasks;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there is no error"), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("link_id", Type.UUID, "The ID associated with the cluster link."), new Field("remote_cluster_id", Type.COMPACT_NULLABLE_STRING, "The remote cluster ID for the cluster link if known."), new Field("local_cluster_id", Type.COMPACT_STRING, "The local cluster ID for the cluster link."), new Field("switchover_state", Type.INT8, "Whether the switchover is currently the active, passive, or in progress of changing into one of those states."), new Field("link_state", Type.INT16, "The cluster link state."), new Field("remote_link_state", Type.INT16, "The state of the remote cluster link"), new Field("switchover_type", Type.INT8, "The last switchover command for the switchover pair"), new Field("link_error_code", Type.INT16, "Link error code if it's in an error state, otherwise 0"), new Field("link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if link is in an error state, otherwise null"), new Field("remote_link_error_code", Type.INT16, "Error code for remote link if it is in an error state, otherwise 0"), new Field("remote_link_error_message", Type.COMPACT_NULLABLE_STRING, "Error message if remote link is in an error state, otherwise null"), new Field("topics", CompactArrayOf.nullable(TopicData.SCHEMA_0), "The switchover information for each topic."), new Field("tasks", CompactArrayOf.nullable(TaskData.SCHEMA_0), "Tasks information"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeSwitchoverStatusResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeSwitchoverStatusResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.linkName = "";
        this.linkId = Uuid.ZERO_UUID;
        this.remoteClusterId = "";
        this.localClusterId = "";
        this.switchoverState = 0;
        this.linkState = 0;
        this.remoteLinkState = (short)-1;
        this.switchoverType = 0;
        this.linkErrorCode = 0;
        this.linkErrorMessage = null;
        this.remoteLinkErrorCode = 0;
        this.remoteLinkErrorMessage = null;
        this.topics = new ArrayList<TopicData>(0);
        this.tasks = new ArrayList<TaskData>(0);
    }

    @Override
    public short apiKey() {
        return 10042;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<TopicData> newCollection;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field linkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field linkName had invalid length " + length);
        }
        this.linkName = _context.read(EntityType.LINK_NAME, _readable.readString(length));
        this.linkId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.remoteClusterId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field remoteClusterId had invalid length " + length);
            }
            this.remoteClusterId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field localClusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field localClusterId had invalid length " + length);
        }
        this.localClusterId = _context.read(EntityType.CLUSTER_ID, _readable.readString(length));
        this.switchoverState = _readable.readByte();
        this.linkState = _readable.readShort();
        this.remoteLinkState = _readable.readShort();
        this.switchoverType = _readable.readByte();
        this.linkErrorCode = _readable.readShort();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.linkErrorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkErrorMessage had invalid length " + length);
            }
            this.linkErrorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        this.remoteLinkErrorCode = _readable.readShort();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.remoteLinkErrorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field remoteLinkErrorMessage had invalid length " + length);
            }
            this.remoteLinkErrorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<TopicData>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicData(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.tasks = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((TopicData)((Object)new TaskData(_readable, _version, _context)));
            }
            this.tasks = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _stringBytes = _cache.getSerializedValue(this.linkName);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeUuid(this.linkId);
        if (this.remoteClusterId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.remoteClusterId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _stringBytes = _cache.getSerializedValue(this.localClusterId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeByte(this.switchoverState);
        _writable.writeShort(this.linkState);
        _writable.writeShort(this.remoteLinkState);
        _writable.writeByte(this.switchoverType);
        _writable.writeShort(this.linkErrorCode);
        if (this.linkErrorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.linkErrorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeShort(this.remoteLinkErrorCode);
        if (this.remoteLinkErrorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.remoteLinkErrorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.topics == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                TopicData topicsElement = (TopicData)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.tasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.tasks.size() + 1);
            for (TaskData tasksElement : this.tasks) {
                tasksElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _stringBytes = _context.write(EntityType.LINK_NAME, this.linkName).getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'linkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.linkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(16);
        if (this.remoteClusterId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.remoteClusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'remoteClusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.remoteClusterId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _stringBytes = _context.write(EntityType.CLUSTER_ID, this.localClusterId).getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'localClusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.localClusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(1);
        _size.addBytes(2);
        _size.addBytes(2);
        _size.addBytes(1);
        _size.addBytes(2);
        if (this.linkErrorMessage == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.linkErrorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkErrorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkErrorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(2);
        if (this.remoteLinkErrorMessage == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.remoteLinkErrorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'remoteLinkErrorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.remoteLinkErrorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.topics == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            for (TopicData topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.tasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.tasks.size() + 1));
            for (TaskData tasksElement : this.tasks) {
                tasksElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeSwitchoverStatusResponseData)) {
            return false;
        }
        DescribeSwitchoverStatusResponseData other = (DescribeSwitchoverStatusResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
            return false;
        }
        if (!this.linkId.equals(other.linkId)) {
            return false;
        }
        if (this.remoteClusterId == null ? other.remoteClusterId != null : !this.remoteClusterId.equals(other.remoteClusterId)) {
            return false;
        }
        if (this.localClusterId == null ? other.localClusterId != null : !this.localClusterId.equals(other.localClusterId)) {
            return false;
        }
        if (this.switchoverState != other.switchoverState) {
            return false;
        }
        if (this.linkState != other.linkState) {
            return false;
        }
        if (this.remoteLinkState != other.remoteLinkState) {
            return false;
        }
        if (this.switchoverType != other.switchoverType) {
            return false;
        }
        if (this.linkErrorCode != other.linkErrorCode) {
            return false;
        }
        if (this.linkErrorMessage == null ? other.linkErrorMessage != null : !this.linkErrorMessage.equals(other.linkErrorMessage)) {
            return false;
        }
        if (this.remoteLinkErrorCode != other.remoteLinkErrorCode) {
            return false;
        }
        if (this.remoteLinkErrorMessage == null ? other.remoteLinkErrorMessage != null : !this.remoteLinkErrorMessage.equals(other.remoteLinkErrorMessage)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.tasks == null ? other.tasks != null : !this.tasks.equals(other.tasks)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
        hashCode = 31 * hashCode + this.linkId.hashCode();
        hashCode = 31 * hashCode + (this.remoteClusterId == null ? 0 : this.remoteClusterId.hashCode());
        hashCode = 31 * hashCode + (this.localClusterId == null ? 0 : this.localClusterId.hashCode());
        hashCode = 31 * hashCode + this.switchoverState;
        hashCode = 31 * hashCode + this.linkState;
        hashCode = 31 * hashCode + this.remoteLinkState;
        hashCode = 31 * hashCode + this.switchoverType;
        hashCode = 31 * hashCode + this.linkErrorCode;
        hashCode = 31 * hashCode + (this.linkErrorMessage == null ? 0 : this.linkErrorMessage.hashCode());
        hashCode = 31 * hashCode + this.remoteLinkErrorCode;
        hashCode = 31 * hashCode + (this.remoteLinkErrorMessage == null ? 0 : this.remoteLinkErrorMessage.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.tasks == null ? 0 : this.tasks.hashCode());
        return hashCode;
    }

    @Override
    public DescribeSwitchoverStatusResponseData duplicate() {
        DescribeSwitchoverStatusResponseData _duplicate = new DescribeSwitchoverStatusResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.linkName = this.linkName;
        _duplicate.linkId = this.linkId;
        _duplicate.remoteClusterId = this.remoteClusterId == null ? null : this.remoteClusterId;
        _duplicate.localClusterId = this.localClusterId;
        _duplicate.switchoverState = this.switchoverState;
        _duplicate.linkState = this.linkState;
        _duplicate.remoteLinkState = this.remoteLinkState;
        _duplicate.switchoverType = this.switchoverType;
        _duplicate.linkErrorCode = this.linkErrorCode;
        _duplicate.linkErrorMessage = this.linkErrorMessage == null ? null : this.linkErrorMessage;
        _duplicate.remoteLinkErrorCode = this.remoteLinkErrorCode;
        _duplicate.remoteLinkErrorMessage = this.remoteLinkErrorMessage == null ? null : this.remoteLinkErrorMessage;
        if (this.topics == null) {
            _duplicate.topics = null;
        } else {
            ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
            for (TopicData topicData : this.topics) {
                newTopics.add(topicData.duplicate());
            }
            _duplicate.topics = newTopics;
        }
        if (this.tasks == null) {
            _duplicate.tasks = null;
        } else {
            ArrayList<TaskData> newTasks = new ArrayList<TaskData>(this.tasks.size());
            for (TaskData taskData : this.tasks) {
                newTasks.add(taskData.duplicate());
            }
            _duplicate.tasks = newTasks;
        }
        return _duplicate;
    }

    public String toString() {
        return "DescribeSwitchoverStatusResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", linkName=" + (String)(this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", linkId=" + this.linkId.toString() + ", remoteClusterId=" + (String)(this.remoteClusterId == null ? "null" : "'" + this.remoteClusterId.toString() + "'") + ", localClusterId=" + (String)(this.localClusterId == null ? "null" : "'" + this.localClusterId.toString() + "'") + ", switchoverState=" + this.switchoverState + ", linkState=" + this.linkState + ", remoteLinkState=" + this.remoteLinkState + ", switchoverType=" + this.switchoverType + ", linkErrorCode=" + this.linkErrorCode + ", linkErrorMessage=" + (String)(this.linkErrorMessage == null ? "null" : "'" + this.linkErrorMessage.toString() + "'") + ", remoteLinkErrorCode=" + this.remoteLinkErrorCode + ", remoteLinkErrorMessage=" + (String)(this.remoteLinkErrorMessage == null ? "null" : "'" + this.remoteLinkErrorMessage.toString() + "'") + ", topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ", tasks=" + (this.tasks == null ? "null" : MessageUtil.deepToString(this.tasks.iterator())) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public byte switchoverState() {
        return this.switchoverState;
    }

    public short linkState() {
        return this.linkState;
    }

    public short remoteLinkState() {
        return this.remoteLinkState;
    }

    public byte switchoverType() {
        return this.switchoverType;
    }

    public short linkErrorCode() {
        return this.linkErrorCode;
    }

    public String linkErrorMessage() {
        return this.linkErrorMessage;
    }

    public short remoteLinkErrorCode() {
        return this.remoteLinkErrorCode;
    }

    public String remoteLinkErrorMessage() {
        return this.remoteLinkErrorMessage;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    public List<TaskData> tasks() {
        return this.tasks;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeSwitchoverStatusResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setLinkName(String v) {
        this.linkName = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setLinkId(Uuid v) {
        this.linkId = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setRemoteClusterId(String v) {
        this.remoteClusterId = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setLocalClusterId(String v) {
        this.localClusterId = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setSwitchoverState(byte v) {
        this.switchoverState = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setLinkState(short v) {
        this.linkState = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setRemoteLinkState(short v) {
        this.remoteLinkState = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setSwitchoverType(byte v) {
        this.switchoverType = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setLinkErrorCode(short v) {
        this.linkErrorCode = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setLinkErrorMessage(String v) {
        this.linkErrorMessage = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setRemoteLinkErrorCode(short v) {
        this.remoteLinkErrorCode = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setRemoteLinkErrorMessage(String v) {
        this.remoteLinkErrorMessage = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public DescribeSwitchoverStatusResponseData setTasks(List<TaskData> v) {
        this.tasks = v;
        return this;
    }

    public static class TopicData
    implements Message {
        String topic;
        short errorCode;
        String errorMessage;
        String state;
        long switchoverMessagesTruncated;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The topic's name."), new Field("error_code", Type.INT16, "Topic-specific error code for the last switchover."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "Topic-specific error message for the last switchover."), new Field("state", Type.COMPACT_NULLABLE_STRING, "The mirror state of the topic"), new Field("switchover_messages_truncated", Type.INT64, "The number of messages truncated by the truncate-and-restore operation for the topic"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicData() {
            this.topic = "";
            this.errorCode = 0;
            this.errorMessage = "";
            this.state = null;
            this.switchoverMessagesTruncated = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.errorCode = _readable.readShort();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.state = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field state had invalid length " + length);
                }
                this.state = _readable.readString(length);
            }
            this.switchoverMessagesTruncated = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.state == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.state);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeLong(this.switchoverMessagesTruncated);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this.state == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.state.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'state' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.state, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
                return false;
            }
            if (this.switchoverMessagesTruncated != other.switchoverMessagesTruncated) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.state == null ? 0 : this.state.hashCode());
            hashCode = 31 * hashCode + ((int)(this.switchoverMessagesTruncated >> 32) ^ (int)this.switchoverMessagesTruncated);
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topic = this.topic;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.state = this.state == null ? null : this.state;
            _duplicate.switchoverMessagesTruncated = this.switchoverMessagesTruncated;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topic=" + (String)(this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", state=" + (String)(this.state == null ? "null" : "'" + this.state.toString() + "'") + ", switchoverMessagesTruncated=" + this.switchoverMessagesTruncated + ")";
        }

        public String topic() {
            return this.topic;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String state() {
            return this.state;
        }

        public long switchoverMessagesTruncated() {
            return this.switchoverMessagesTruncated;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public TopicData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public TopicData setState(String v) {
            this.state = v;
            return this;
        }

        public TopicData setSwitchoverMessagesTruncated(long v) {
            this.switchoverMessagesTruncated = v;
            return this;
        }
    }

    public static class TaskData
    implements Message {
        String name;
        short state;
        List<TaskErrorData> errors;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The task name."), new Field("state", Type.INT16, "The task state."), new Field("errors", CompactArrayOf.nullable(TaskErrorData.SCHEMA_0), "The task error data."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TaskData() {
            this.name = "";
            this.state = 0;
            this.errors = new ArrayList<TaskErrorData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaskData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.state = _readable.readShort();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.errors = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TaskErrorData> newCollection = new ArrayList<TaskErrorData>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new TaskErrorData(_readable, _version, _context));
                }
                this.errors = newCollection;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeShort(this.state);
            if (this.errors == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.errors.size() + 1);
                _stringBytes = this.errors.iterator();
                while (_stringBytes.hasNext()) {
                    TaskErrorData errorsElement = (TaskErrorData)_stringBytes.next();
                    errorsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TaskData");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this.errors == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.errors.size() + 1));
                for (TaskErrorData errorsElement : this.errors) {
                    errorsElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskData)) {
                return false;
            }
            TaskData other = (TaskData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.state != other.state) {
                return false;
            }
            if (this.errors == null ? other.errors != null : !this.errors.equals(other.errors)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.state;
            hashCode = 31 * hashCode + (this.errors == null ? 0 : this.errors.hashCode());
            return hashCode;
        }

        @Override
        public TaskData duplicate() {
            TaskData _duplicate = new TaskData();
            _duplicate.name = this.name;
            _duplicate.state = this.state;
            if (this.errors == null) {
                _duplicate.errors = null;
            } else {
                ArrayList<TaskErrorData> newErrors = new ArrayList<TaskErrorData>(this.errors.size());
                for (TaskErrorData _element : this.errors) {
                    newErrors.add(_element.duplicate());
                }
                _duplicate.errors = newErrors;
            }
            return _duplicate;
        }

        public String toString() {
            return "TaskData(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", state=" + this.state + ", errors=" + (this.errors == null ? "null" : MessageUtil.deepToString(this.errors.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public short state() {
            return this.state;
        }

        public List<TaskErrorData> errors() {
            return this.errors;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskData setName(String v) {
            this.name = v;
            return this;
        }

        public TaskData setState(short v) {
            this.state = v;
            return this;
        }

        public TaskData setErrors(List<TaskErrorData> v) {
            this.errors = v;
            return this;
        }
    }

    public static class TaskErrorData
    implements Message {
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if the task is not in an error state."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if the task is not in an error state."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskErrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TaskErrorData() {
            this.errorCode = 0;
            this.errorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaskErrorData");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TaskErrorData");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskErrorData)) {
                return false;
            }
            TaskErrorData other = (TaskErrorData)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        @Override
        public TaskErrorData duplicate() {
            TaskErrorData _duplicate = new TaskErrorData();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "TaskErrorData(errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskErrorData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public TaskErrorData setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }
    }
}

