/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class InitProducerIdRequestDataJsonConverter {
    public static InitProducerIdRequestData read(JsonNode _node, short _version) {
        InitProducerIdRequestData _object = new InitProducerIdRequestData();
        JsonNode _transactionalIdNode = _node.get("transactionalId");
        if (_transactionalIdNode == null) {
            throw new RuntimeException("InitProducerIdRequestData: unable to locate field 'transactionalId', which is mandatory in version " + _version);
        }
        if (_transactionalIdNode.isNull()) {
            _object.transactionalId = null;
        } else {
            if (!_transactionalIdNode.isTextual()) {
                throw new RuntimeException("InitProducerIdRequestData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.transactionalId = _transactionalIdNode.asText();
        }
        JsonNode _transactionTimeoutMsNode = _node.get("transactionTimeoutMs");
        if (_transactionTimeoutMsNode == null) {
            throw new RuntimeException("InitProducerIdRequestData: unable to locate field 'transactionTimeoutMs', which is mandatory in version " + _version);
        }
        _object.transactionTimeoutMs = MessageUtil.jsonNodeToInt(_transactionTimeoutMsNode, "InitProducerIdRequestData");
        JsonNode _producerIdNode = _node.get("producerId");
        if (_producerIdNode == null) {
            if (_version >= 3) {
                throw new RuntimeException("InitProducerIdRequestData: unable to locate field 'producerId', which is mandatory in version " + _version);
            }
            _object.producerId = -1L;
        } else {
            _object.producerId = MessageUtil.jsonNodeToLong(_producerIdNode, "InitProducerIdRequestData");
        }
        JsonNode _producerEpochNode = _node.get("producerEpoch");
        if (_producerEpochNode == null) {
            if (_version >= 3) {
                throw new RuntimeException("InitProducerIdRequestData: unable to locate field 'producerEpoch', which is mandatory in version " + _version);
            }
            _object.producerEpoch = (short)-1;
        } else {
            _object.producerEpoch = MessageUtil.jsonNodeToShort(_producerEpochNode, "InitProducerIdRequestData");
        }
        JsonNode _confluentEnableTwoPhaseCommitNode = _node.get("confluentEnableTwoPhaseCommit");
        if (_confluentEnableTwoPhaseCommitNode == null) {
            _object.confluentEnableTwoPhaseCommit = false;
        } else {
            if (!_confluentEnableTwoPhaseCommitNode.isBoolean()) {
                throw new RuntimeException("InitProducerIdRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.confluentEnableTwoPhaseCommit = _confluentEnableTwoPhaseCommitNode.asBoolean();
        }
        JsonNode _confluentKeepPreparedTransactionNode = _node.get("confluentKeepPreparedTransaction");
        if (_confluentKeepPreparedTransactionNode == null) {
            _object.confluentKeepPreparedTransaction = false;
        } else {
            if (!_confluentKeepPreparedTransactionNode.isBoolean()) {
                throw new RuntimeException("InitProducerIdRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.confluentKeepPreparedTransaction = _confluentKeepPreparedTransactionNode.asBoolean();
        }
        JsonNode _enable2PcNode = _node.get("enable2Pc");
        if (_enable2PcNode == null) {
            if (_version >= 6) {
                throw new RuntimeException("InitProducerIdRequestData: unable to locate field 'enable2Pc', which is mandatory in version " + _version);
            }
            _object.enable2Pc = false;
        } else {
            if (!_enable2PcNode.isBoolean()) {
                throw new RuntimeException("InitProducerIdRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.enable2Pc = _enable2PcNode.asBoolean();
        }
        JsonNode _keepPreparedTxnNode = _node.get("keepPreparedTxn");
        if (_keepPreparedTxnNode == null) {
            if (_version >= 6) {
                throw new RuntimeException("InitProducerIdRequestData: unable to locate field 'keepPreparedTxn', which is mandatory in version " + _version);
            }
            _object.keepPreparedTxn = false;
        } else {
            if (!_keepPreparedTxnNode.isBoolean()) {
                throw new RuntimeException("InitProducerIdRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.keepPreparedTxn = _keepPreparedTxnNode.asBoolean();
        }
        return _object;
    }

    public static JsonNode write(InitProducerIdRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_object.transactionalId == null) {
            _node.set("transactionalId", (JsonNode)NullNode.instance);
        } else {
            _node.set("transactionalId", (JsonNode)new TextNode(_object.transactionalId));
        }
        _node.set("transactionTimeoutMs", (JsonNode)new IntNode(_object.transactionTimeoutMs));
        if (_version >= 3) {
            _node.set("producerId", (JsonNode)new LongNode(_object.producerId));
        } else if (_object.producerId != -1L) {
            throw new UnsupportedVersionException("Attempted to write a non-default producerId at version " + _version);
        }
        if (_version >= 3) {
            _node.set("producerEpoch", (JsonNode)new ShortNode(_object.producerEpoch));
        } else if (_object.producerEpoch != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default producerEpoch at version " + _version);
        }
        if (_version >= 4 && _object.confluentEnableTwoPhaseCommit) {
            _node.set("confluentEnableTwoPhaseCommit", (JsonNode)BooleanNode.valueOf((boolean)_object.confluentEnableTwoPhaseCommit));
        }
        if (_version >= 4 && _object.confluentKeepPreparedTransaction) {
            _node.set("confluentKeepPreparedTransaction", (JsonNode)BooleanNode.valueOf((boolean)_object.confluentKeepPreparedTransaction));
        }
        if (_version >= 6) {
            _node.set("enable2Pc", (JsonNode)BooleanNode.valueOf((boolean)_object.enable2Pc));
        } else if (_object.enable2Pc) {
            throw new UnsupportedVersionException("Attempted to write a non-default enable2Pc at version " + _version);
        }
        if (_version >= 6) {
            _node.set("keepPreparedTxn", (JsonNode)BooleanNode.valueOf((boolean)_object.keepPreparedTxn));
        } else if (_object.keepPreparedTxn) {
            throw new UnsupportedVersionException("Attempted to write a non-default keepPreparedTxn at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(InitProducerIdRequestData _object, short _version) {
        return InitProducerIdRequestDataJsonConverter.write(_object, _version, true);
    }
}

