/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvParser;
import org.apache.kafka.common.network.ProxyTlvType;
import org.apache.kafka.common.network.ProxyTlvValidator;
import org.slf4j.Logger;

public class DefaultProxyTlvParser
implements ProxyTlvParser {
    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public Optional<ProxyTlv> parse(Logger log, int tlvType, byte[] bytes) {
        ProxyTlv tlv;
        if (tlvType == 239) {
            tlv = this.createReservedTlv(log, bytes);
        } else {
            ProxyTlvType ptt = new ProxyTlvType(tlvType);
            tlv = new ProxyTlv(ptt, bytes);
        }
        return Optional.of(tlv);
    }

    private ProxyTlv createReservedTlv(Logger log, byte[] tlvBytes) {
        ProxyTlvValidator validator;
        Optional<Integer> tlvSubtype = Optional.of(tlvBytes[0] & 0xFF);
        Set<ProxyTlvType> registeredTypes = ProxyTlvType.registeredTypes();
        ProxyTlvType ptt = null;
        for (ProxyTlvType registered : registeredTypes) {
            if (registered.type != 239 || !registered.subtype.equals(tlvSubtype)) continue;
            ptt = registered;
            break;
        }
        if (ptt == null) {
            String options = registeredTypes.stream().map(x -> String.format("%s/%s", x.type, x.subtype)).collect(Collectors.joining(", "));
            String message = String.format("No Confluent TLV types found with type %s, subtype %s; known TLV types are: %s", 239, tlvSubtype.get(), options);
            log.error(message);
            ptt = new ProxyTlvType(239, tlvSubtype);
        }
        if ((validator = (ProxyTlvValidator)ptt.validator().orElse(null)) != null) {
            try {
                validator.validate(tlvBytes);
            }
            catch (Throwable t) {
                log.debug("Error validating TLV: {}", (Object)t.getMessage());
            }
        }
        return new ProxyTlv(ptt, tlvBytes);
    }
}

