/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterPartitionResponse
extends AbstractResponse {
    private final AlterPartitionResponseData data;

    public AlterPartitionResponse(AlterPartitionResponseData data) {
        super(ApiKeys.ALTER_PARTITION);
        this.data = data;
    }

    @Override
    public AlterPartitionResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        AlterPartitionResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.topics().forEach(topicResponse -> topicResponse.partitions().forEach(partitionResponse -> AlterPartitionResponse.updateErrorCounts(counts, Errors.forCode(partitionResponse.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static AlterPartitionResponse parse(Readable readable, short version, MessageContext context) {
        return new AlterPartitionResponse(new AlterPartitionResponseData(readable, version, context));
    }
}

