/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.DescribeNetworkResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeNetworkResponse
extends AbstractResponse {
    private final DescribeNetworkResponseData data;

    public DescribeNetworkResponse(DescribeNetworkResponseData data) {
        super(ApiKeys.DESCRIBE_NETWORK);
        this.data = data;
    }

    @Override
    public DescribeNetworkResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        DescribeNetworkResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        return counts;
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public static DescribeNetworkResponse parse(Readable readable, short version, MessageContext context) {
        return new DescribeNetworkResponse(new DescribeNetworkResponseData(readable, version, context));
    }
}

