/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Map;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class EndTxnResponse
extends AbstractResponse {
    private final EndTxnResponseData data;

    public EndTxnResponse(EndTxnResponseData data) {
        super(ApiKeys.END_TXN);
        this.data = data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return EndTxnResponse.errorCounts(this.error());
    }

    @Override
    public EndTxnResponseData data() {
        return this.data;
    }

    public static EndTxnResponse parse(Readable readable, short version, MessageContext context) {
        return new EndTxnResponse(new EndTxnResponseData(readable, version, context));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

