/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.StreamsGroupDescribeRequestData;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.StreamsGroupDescribeResponse;

public class StreamsGroupDescribeRequest
extends AbstractRequest {
    private final StreamsGroupDescribeRequestData data;

    public StreamsGroupDescribeRequest(StreamsGroupDescribeRequestData data, short version) {
        super(ApiKeys.STREAMS_GROUP_DESCRIBE, version);
        this.data = data;
    }

    @Override
    public StreamsGroupDescribeResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        StreamsGroupDescribeResponseData data = new StreamsGroupDescribeResponseData().setThrottleTimeMs(throttleTimeMs);
        this.data.groupIds().forEach(groupId -> data.groups().add(new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId((String)groupId).setErrorCode(Errors.forException(e).code())));
        return new StreamsGroupDescribeResponse(data);
    }

    @Override
    public StreamsGroupDescribeRequestData data() {
        return this.data;
    }

    public static StreamsGroupDescribeRequest parse(Readable readable, short version, MessageContext context) {
        return new StreamsGroupDescribeRequest(new StreamsGroupDescribeRequestData(readable, version, context), version);
    }

    public static List<StreamsGroupDescribeResponseData.DescribedGroup> getErrorDescribedGroupList(List<String> groupIds, Errors error) {
        return groupIds.stream().map(groupId -> new StreamsGroupDescribeResponseData.DescribedGroup().setGroupId((String)groupId).setErrorCode(error.code())).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractRequest.Builder<StreamsGroupDescribeRequest> {
        private final StreamsGroupDescribeRequestData data;

        public Builder(StreamsGroupDescribeRequestData data) {
            super(ApiKeys.STREAMS_GROUP_DESCRIBE);
            this.data = data;
        }

        @Override
        public StreamsGroupDescribeRequest build(short version) {
            return new StreamsGroupDescribeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

