/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class VoteResponse
extends AbstractResponse {
    private final VoteResponseData data;

    public VoteResponse(VoteResponseData data) {
        super(ApiKeys.VOTE);
        this.data = data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errors = new EnumMap<Errors, Integer>(Errors.class);
        errors.put(Errors.forCode(this.data.errorCode()), 1);
        for (VoteResponseData.TopicData topicResponse : this.data.topics()) {
            for (VoteResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                VoteResponse.updateErrorCounts(errors, Errors.forCode(partitionResponse.errorCode()));
            }
        }
        return errors;
    }

    @Override
    public VoteResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static VoteResponse parse(Readable readable, short version, MessageContext context) {
        return new VoteResponse(new VoteResponseData(readable, version, context));
    }
}

