/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.TopicIdPartition;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineInteger;

public class BrokersToIsrs {
    private static final int LEADER_FLAG = Integer.MIN_VALUE;
    private static final int REPLICA_MASK = Integer.MAX_VALUE;
    private final SnapshotRegistry snapshotRegistry;
    private final TimelineHashMap<Integer, TimelineHashMap<Uuid, int[]>> isrMembers;
    private final TimelineInteger offlinePartitionCount;

    BrokersToIsrs(SnapshotRegistry snapshotRegistry) {
        this.snapshotRegistry = snapshotRegistry;
        this.isrMembers = new TimelineHashMap(snapshotRegistry, 0);
        this.offlinePartitionCount = new TimelineInteger(snapshotRegistry);
    }

    void update(Uuid topicId, int partitionId, int[] prevIsr, int[] nextIsr, int prevLeader, int nextLeader) {
        int[] next;
        int[] prev;
        if (prevIsr == null) {
            prev = Replicas.NONE;
        } else {
            if (prevLeader == -1) {
                prev = Replicas.copyWith(prevIsr, -1);
                if (nextLeader != -1) {
                    this.offlinePartitionCount.decrement();
                }
            } else {
                prev = Replicas.clone(prevIsr);
            }
            Arrays.sort(prev);
        }
        if (nextIsr == null) {
            next = Replicas.NONE;
        } else {
            if (nextLeader == -1) {
                next = Replicas.copyWith(nextIsr, -1);
                if (prevLeader != -1) {
                    this.offlinePartitionCount.increment();
                }
            } else {
                next = Replicas.clone(nextIsr);
            }
            Arrays.sort(next);
        }
        int i = 0;
        int j = 0;
        while (true) {
            boolean isLeader;
            int prevReplica;
            if (i == prev.length) {
                int newReplica;
                if (j == next.length) break;
                this.add(newReplica, topicId, partitionId, (newReplica = next[j]) == nextLeader);
                ++j;
                continue;
            }
            if (j == next.length) {
                this.remove(prevReplica, topicId, partitionId, (prevReplica = prev[i]) == prevLeader);
                ++i;
                continue;
            }
            prevReplica = prev[i];
            int newReplica = next[j];
            if (prevReplica < newReplica) {
                this.remove(prevReplica, topicId, partitionId, prevReplica == prevLeader);
                ++i;
                continue;
            }
            if (prevReplica > newReplica) {
                this.add(newReplica, topicId, partitionId, newReplica == nextLeader);
                ++j;
                continue;
            }
            boolean wasLeader = prevReplica == prevLeader;
            boolean bl = isLeader = prevReplica == nextLeader;
            if (wasLeader != isLeader) {
                this.change(prevReplica, topicId, partitionId, wasLeader, isLeader);
            }
            ++i;
            ++j;
        }
    }

    void removeTopicEntryForBroker(Uuid topicId, int brokerId) {
        Map topicMap = this.isrMembers.get(brokerId);
        if (topicMap != null) {
            if (brokerId == -1) {
                this.offlinePartitionCount.set(this.offlinePartitionCount.get() - ((int[])topicMap.get(topicId)).length);
            }
            topicMap.remove(topicId);
        }
    }

    private void add(int brokerId, Uuid topicId, int newPartition, boolean leader) {
        int[] newPartitions;
        int[] partitions;
        TimelineHashMap<Object, Object> topicMap;
        if (leader) {
            newPartition |= Integer.MIN_VALUE;
        }
        if ((topicMap = this.isrMembers.get(brokerId)) == null) {
            topicMap = new TimelineHashMap(this.snapshotRegistry, 0);
            this.isrMembers.put(brokerId, topicMap);
        }
        if ((partitions = topicMap.get(topicId)) == null) {
            newPartitions = new int[1];
        } else {
            newPartitions = new int[partitions.length + 1];
            System.arraycopy(partitions, 0, newPartitions, 0, partitions.length);
        }
        newPartitions[newPartitions.length - 1] = newPartition;
        topicMap.put(topicId, newPartitions);
    }

    private void change(int brokerId, Uuid topicId, int partition, boolean wasLeader, boolean isLeader) {
        TimelineHashMap<Uuid, int[]> topicMap = this.isrMembers.get(brokerId);
        if (topicMap == null) {
            throw new RuntimeException("Broker " + brokerId + " has no isrMembers entry, so we can't change " + topicId + ":" + partition);
        }
        int[] partitions = topicMap.get(topicId);
        if (partitions == null) {
            throw new RuntimeException("Broker " + brokerId + " has no entry in isrMembers for topic " + topicId);
        }
        int[] newPartitions = new int[partitions.length];
        int target = wasLeader ? partition | Integer.MIN_VALUE : partition;
        for (int i = 0; i < partitions.length; ++i) {
            int cur = partitions[i];
            newPartitions[i] = cur == target ? (isLeader ? partition | Integer.MIN_VALUE : partition) : cur;
        }
        topicMap.put(topicId, newPartitions);
    }

    private void remove(int brokerId, Uuid topicId, int removedPartition, boolean leader) {
        TimelineHashMap<Uuid, int[]> topicMap;
        if (leader) {
            removedPartition |= Integer.MIN_VALUE;
        }
        if ((topicMap = this.isrMembers.get(brokerId)) == null) {
            throw new RuntimeException("Broker " + brokerId + " has no isrMembers entry, so we can't remove " + topicId + ":" + removedPartition);
        }
        int[] partitions = topicMap.get(topicId);
        if (partitions == null) {
            throw new RuntimeException("Broker " + brokerId + " has no entry in isrMembers for topic " + topicId);
        }
        if (partitions.length == 1) {
            if (partitions[0] != removedPartition) {
                throw new RuntimeException("Broker " + brokerId + " has no entry in isrMembers for " + topicId + ":" + removedPartition);
            }
            topicMap.remove(topicId);
            if (topicMap.isEmpty()) {
                this.isrMembers.remove(brokerId);
            }
        } else {
            int[] newPartitions = new int[partitions.length - 1];
            int j = 0;
            for (int i = 0; i < partitions.length; ++i) {
                int partition = partitions[i];
                if (partition == removedPartition) continue;
                newPartitions[j++] = partition;
            }
            topicMap.put(topicId, newPartitions);
        }
    }

    PartitionsOnReplicaIterator iterator(int brokerId, boolean leadersOnly) {
        Map<Uuid, int[]> topicMap = (Map<Uuid, int[]>)this.isrMembers.get(brokerId);
        if (topicMap == null) {
            topicMap = Collections.emptyMap();
        }
        return new PartitionsOnReplicaIterator(topicMap, leadersOnly);
    }

    PartitionsOnReplicaIterator partitionsWithNoLeader() {
        return this.iterator(-1, true);
    }

    PartitionsOnReplicaIterator partitionsLedByBroker(int brokerId) {
        return this.iterator(brokerId, true);
    }

    PartitionsOnReplicaIterator partitionsWithBrokerInIsr(int brokerId) {
        return this.iterator(brokerId, false);
    }

    boolean hasLeaderships(int brokerId) {
        return this.iterator(brokerId, true).hasNext();
    }

    int offlinePartitionCount() {
        return this.offlinePartitionCount.get();
    }

    static class PartitionsOnReplicaIterator
    implements Iterator<TopicIdPartition> {
        private final Iterator<Map.Entry<Uuid, int[]>> iterator;
        private final boolean leaderOnly;
        private int offset = 0;
        Uuid uuid = Uuid.ZERO_UUID;
        int[] replicas = Replicas.NONE;
        private TopicIdPartition next = null;

        PartitionsOnReplicaIterator(Map<Uuid, int[]> topicMap, boolean leaderOnly) {
            this.iterator = topicMap.entrySet().iterator();
            this.leaderOnly = leaderOnly;
        }

        @Override
        public boolean hasNext() {
            int replica;
            if (this.next != null) {
                return true;
            }
            do {
                if (this.offset >= this.replicas.length) {
                    if (!this.iterator.hasNext()) {
                        return false;
                    }
                    this.offset = 0;
                    Map.Entry<Uuid, int[]> entry = this.iterator.next();
                    this.uuid = entry.getKey();
                    this.replicas = entry.getValue();
                }
                replica = this.replicas[this.offset++];
            } while (this.leaderOnly && (replica & Integer.MIN_VALUE) == 0);
            this.next = new TopicIdPartition(this.uuid, replica & Integer.MAX_VALUE);
            return true;
        }

        @Override
        public TopicIdPartition next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TopicIdPartition result = this.next;
            this.next = null;
            return result;
        }
    }
}

