/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.server.common.MetadataVersion;

public final class FeaturesImage {
    public static final FeaturesImage EMPTY = new FeaturesImage(Collections.emptyMap(), MetadataVersion.MINIMUM_KRAFT_VERSION);
    private final Map<String, Short> finalizedVersions;
    private final MetadataVersion metadataVersion;

    public FeaturesImage(Map<String, Short> finalizedVersions, MetadataVersion metadataVersion) {
        this.finalizedVersions = Collections.unmodifiableMap(finalizedVersions);
        this.metadataVersion = metadataVersion;
    }

    public boolean isEmpty() {
        return this.finalizedVersions.isEmpty();
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public Map<String, Short> finalizedVersions() {
        return this.finalizedVersions;
    }

    private Optional<Short> finalizedVersion(String feature) {
        return Optional.ofNullable(this.finalizedVersions.get(feature));
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        if (options.metadataVersion().isLessThan(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION)) {
            this.handleFeatureLevelNotSupported(options);
        } else {
            this.writeFeatureLevels(writer, options);
        }
    }

    private void handleFeatureLevelNotSupported(ImageWriterOptions options) {
        if (!this.finalizedVersions.isEmpty()) {
            ArrayList<String> features = new ArrayList<String>(this.finalizedVersions.keySet());
            features.sort(String::compareTo);
            options.handleLoss("feature flag(s): " + features.stream().collect(Collectors.joining(", ")));
        }
    }

    private void writeFeatureLevels(ImageWriter writer, ImageWriterOptions options) {
        writer.write(0, new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(options.metadataVersion().featureLevel()));
        for (Map.Entry<String, Short> entry : this.finalizedVersions.entrySet()) {
            if (entry.getKey().equals("metadata.version")) continue;
            writer.write(0, new FeatureLevelRecord().setName(entry.getKey()).setFeatureLevel(entry.getValue()));
        }
    }

    public int hashCode() {
        return this.finalizedVersions.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeaturesImage)) {
            return false;
        }
        FeaturesImage other = (FeaturesImage)o;
        return this.finalizedVersions.equals(other.finalizedVersions);
    }

    public String toString() {
        return "FeaturesImage{finalizedVersions=" + this.finalizedVersions + ", metadataVersion=" + this.metadataVersion + '}';
    }
}

