/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Optional;

public enum ZkMigrationState {
    NONE(0),
    PRE_MIGRATION(1),
    MIGRATION(2),
    POST_MIGRATION(3);

    private final byte value;

    private ZkMigrationState(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static ZkMigrationState of(byte value) {
        return ZkMigrationState.optionalOf(value).orElseThrow(() -> new IllegalArgumentException(String.format("Value %s is not a valid Zk migration state", value)));
    }

    public static Optional<ZkMigrationState> optionalOf(byte value) {
        for (ZkMigrationState state : ZkMigrationState.values()) {
            if (state.value != value) continue;
            return Optional.of(state);
        }
        return Optional.empty();
    }
}

