/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.server.mutable.BoundedListTooLongException;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;
import org.slf4j.Logger;

public class AclControlManager {
    private final Logger log;
    private final TimelineHashMap<Uuid, StandardAcl> idToAcl;
    private final TimelineHashSet<StandardAcl> existingAcls;

    private AclControlManager(LogContext logContext, SnapshotRegistry snapshotRegistry) {
        this.log = logContext.logger(AclControlManager.class);
        this.idToAcl = new TimelineHashMap(snapshotRegistry, 0);
        this.existingAcls = new TimelineHashSet(snapshotRegistry, 0);
    }

    ControllerResult<List<AclCreateResult>> createAcls(List<AclBinding> acls) {
        ArrayList<AclCreateResult> results = new ArrayList<AclCreateResult>(acls.size());
        BoundedList records = BoundedList.newArrayBacked((int)10000);
        for (AclBinding acl : acls) {
            try {
                AclControlManager.validateNewAcl(acl);
            }
            catch (Throwable t) {
                ApiException e = t instanceof ApiException ? (ApiException)t : new UnknownServerException("Unknown error while trying to create ACL", t);
                results.add(new AclCreateResult(e));
                continue;
            }
            StandardAcl standardAcl = StandardAcl.fromAclBinding(acl);
            if (this.existingAcls.add((Object)standardAcl)) {
                StandardAclWithId standardAclWithId = new StandardAclWithId(this.newAclId(), standardAcl);
                this.idToAcl.put((Object)standardAclWithId.id(), (Object)standardAcl);
                records.add(new ApiMessageAndVersion((ApiMessage)standardAclWithId.toRecord(), 0));
            }
            results.add(AclCreateResult.SUCCESS);
        }
        return new ControllerResult<List<AclCreateResult>>((List<ApiMessageAndVersion>)records, results, true);
    }

    Uuid newAclId() {
        Uuid uuid;
        while (this.idToAcl.containsKey((Object)(uuid = Uuid.randomUuid()))) {
        }
        return uuid;
    }

    static void validateNewAcl(AclBinding binding) {
        switch (binding.pattern().resourceType()) {
            case UNKNOWN: 
            case ANY: {
                throw new InvalidRequestException("Invalid resourceType " + String.valueOf(binding.pattern().resourceType()));
            }
        }
        switch (binding.pattern().patternType()) {
            case LITERAL: 
            case PREFIXED: {
                break;
            }
            default: {
                throw new InvalidRequestException("Invalid patternType " + String.valueOf(binding.pattern().patternType()));
            }
        }
        switch (binding.entry().operation()) {
            case UNKNOWN: 
            case ANY: {
                throw new InvalidRequestException("Invalid operation " + String.valueOf(binding.entry().operation()));
            }
        }
        switch (binding.entry().permissionType()) {
            case DENY: 
            case ALLOW: {
                break;
            }
            default: {
                throw new InvalidRequestException("Invalid permissionType " + String.valueOf(binding.entry().permissionType()));
            }
        }
        if (binding.pattern().name() == null || binding.pattern().name().isEmpty()) {
            throw new InvalidRequestException("Resource name should not be empty");
        }
        int colonIndex = binding.entry().principal().indexOf(":");
        if (colonIndex == -1) {
            throw new InvalidRequestException("Could not parse principal from `" + binding.entry().principal() + "` (no colon is present separating the principal type from the principal name)");
        }
    }

    ControllerResult<List<AclDeleteResult>> deleteAcls(List<AclBindingFilter> filters) {
        ArrayList<AclDeleteResult> results = new ArrayList<AclDeleteResult>();
        HashSet<ApiMessageAndVersion> records = new HashSet<ApiMessageAndVersion>();
        for (AclBindingFilter filter : filters) {
            try {
                AclControlManager.validateFilter(filter);
                AclDeleteResult result = this.deleteAclsForFilter(filter, records);
                results.add(result);
            }
            catch (Throwable e) {
                results.add(new AclDeleteResult(ApiError.fromThrowable((Throwable)e).exception()));
            }
        }
        return ControllerResult.atomicOf(new ArrayList<ApiMessageAndVersion>(records), results);
    }

    AclDeleteResult deleteAclsForFilter(AclBindingFilter filter, Set<ApiMessageAndVersion> records) {
        ArrayList<AclDeleteResult.AclBindingDeleteResult> deleted = new ArrayList<AclDeleteResult.AclBindingDeleteResult>();
        for (Map.Entry entry : this.idToAcl.entrySet()) {
            Uuid id = (Uuid)entry.getKey();
            StandardAcl acl = (StandardAcl)entry.getValue();
            AclBinding binding = acl.toBinding();
            if (!filter.matches(binding)) continue;
            deleted.add(new AclDeleteResult.AclBindingDeleteResult(binding));
            records.add(new ApiMessageAndVersion((ApiMessage)new RemoveAccessControlEntryRecord().setId(id), 0));
            if (records.size() <= 10000) continue;
            throw new BoundedListTooLongException("Cannot remove more than 10000 acls in a single delete operation.");
        }
        return new AclDeleteResult(deleted);
    }

    static void validateFilter(AclBindingFilter filter) {
        if (filter.patternFilter().isUnknown()) {
            throw new InvalidRequestException("Unknown patternFilter.");
        }
        if (filter.entryFilter().isUnknown()) {
            throw new InvalidRequestException("Unknown entryFilter.");
        }
    }

    public void replay(AccessControlEntryRecord record) {
        StandardAclWithId aclWithId = StandardAclWithId.fromRecord(record);
        this.idToAcl.put((Object)aclWithId.id(), (Object)aclWithId.acl());
        this.existingAcls.add((Object)aclWithId.acl());
        this.log.info("Replayed AccessControlEntryRecord for {}, setting {}", (Object)record.id(), (Object)aclWithId.acl());
    }

    public void replay(RemoveAccessControlEntryRecord record) {
        StandardAcl acl = (StandardAcl)this.idToAcl.remove((Object)record.id());
        if (acl == null) {
            throw new RuntimeException("Unable to replay " + String.valueOf(record) + ": no acl with that ID found.");
        }
        if (!this.existingAcls.remove((Object)acl)) {
            throw new RuntimeException("Unable to replay " + String.valueOf(record) + " for " + String.valueOf(acl) + ": acl not found in existingAcls.");
        }
        this.log.info("Replayed RemoveAccessControlEntryRecord for {}, removing {}", (Object)record.id(), (Object)acl);
    }

    Map<Uuid, StandardAcl> idToAcl() {
        return Collections.unmodifiableMap(this.idToAcl);
    }

    static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        AclControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            return new AclControlManager(this.logContext, this.snapshotRegistry);
        }
    }
}

