/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class PartitionChangeRecord
implements ApiMessage {
    int partitionId;
    Uuid topicId;
    List<Integer> isr;
    int leader;
    List<Integer> replicas;
    List<Integer> removingReplicas;
    List<Integer> addingReplicas;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("isr", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the ISR didn't change; the new in-sync replicas otherwise."), 1, new Field("leader", (Type)Type.INT32, "-1 if there is now no leader; -2 if the leader didn't change; the new leader otherwise."), 2, new Field("replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the replicas didn't change; the new replicas otherwise."), 3, new Field("removing_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the removing replicas didn't change; the new removing replicas otherwise."), 4, new Field("adding_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the adding replicas didn't change; the new adding replicas otherwise.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public PartitionChangeRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public PartitionChangeRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public PartitionChangeRecord() {
        this.partitionId = -1;
        this.topicId = Uuid.ZERO_UUID;
        this.isr = null;
        this.leader = -2;
        this.replicas = null;
        this.removingReplicas = null;
        this.addingReplicas = null;
    }

    public short apiKey() {
        return 5;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.partitionId = _readable.readInt();
        this.topicId = _readable.readUuid();
        this.isr = null;
        this.leader = -2;
        this.replicas = null;
        this.removingReplicas = null;
        this.addingReplicas = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block7: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.isr = null;
                        continue block7;
                    }
                    ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.isr = newCollection;
                    continue block7;
                }
                case 1: {
                    this.leader = _readable.readInt();
                    continue block7;
                }
                case 2: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.replicas = null;
                        continue block7;
                    }
                    ArrayList<Integer> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.replicas = newCollection;
                    continue block7;
                }
                case 3: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.removingReplicas = null;
                        continue block7;
                    }
                    ArrayList<Integer> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.removingReplicas = newCollection;
                    continue block7;
                }
                case 4: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.addingReplicas = null;
                        continue block7;
                    }
                    ArrayList<Integer> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.addingReplicas = newCollection;
                    continue block7;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.partitionId);
        _writable.writeUuid(this.topicId);
        if (this.isr != null) {
            ++_numTaggedFields;
        }
        if (this.leader != -2) {
            ++_numTaggedFields;
        }
        if (this.replicas != null) {
            ++_numTaggedFields;
        }
        if (this.removingReplicas != null) {
            ++_numTaggedFields;
        }
        if (this.addingReplicas != null) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.isr != null) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.isr).intValue());
            _writable.writeUnsignedVarint(this.isr.size() + 1);
            for (Integer isrElement : this.isr) {
                _writable.writeInt(isrElement.intValue());
            }
        }
        if (this.leader != -2) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(4);
            _writable.writeInt(this.leader);
        }
        if (this.replicas != null) {
            _writable.writeUnsignedVarint(2);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.replicas).intValue());
            _writable.writeUnsignedVarint(this.replicas.size() + 1);
            for (Integer replicasElement : this.replicas) {
                _writable.writeInt(replicasElement.intValue());
            }
        }
        if (this.removingReplicas != null) {
            _writable.writeUnsignedVarint(3);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.removingReplicas).intValue());
            _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
            for (Integer removingReplicasElement : this.removingReplicas) {
                _writable.writeInt(removingReplicasElement.intValue());
            }
        }
        if (this.addingReplicas != null) {
            _writable.writeUnsignedVarint(4);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.addingReplicas).intValue());
            _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
            for (Integer addingReplicasElement : this.addingReplicas) {
                _writable.writeInt(addingReplicasElement.intValue());
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _arraySize;
        int _sizeBeforeArray;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        if (this.isr != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.isr.size() + 1)));
            _size.addBytes(this.isr.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.isr, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.leader != -2) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(4);
        }
        if (this.replicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.replicas.size() + 1)));
            _size.addBytes(this.replicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.replicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.removingReplicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.removingReplicas.size() + 1)));
            _size.addBytes(this.removingReplicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.removingReplicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.addingReplicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.addingReplicas.size() + 1)));
            _size.addBytes(this.addingReplicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.addingReplicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartitionChangeRecord)) {
            return false;
        }
        PartitionChangeRecord other = (PartitionChangeRecord)obj;
        if (this.partitionId != other.partitionId) {
            return false;
        }
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
            return false;
        }
        if (this.leader != other.leader) {
            return false;
        }
        if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
            return false;
        }
        if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
            return false;
        }
        if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.partitionId;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
        hashCode = 31 * hashCode + this.leader;
        hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
        hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
        hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
        return hashCode;
    }

    public PartitionChangeRecord duplicate() {
        PartitionChangeRecord _duplicate = new PartitionChangeRecord();
        _duplicate.partitionId = this.partitionId;
        _duplicate.topicId = this.topicId;
        if (this.isr == null) {
            _duplicate.isr = null;
        } else {
            ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
            for (Integer _element : this.isr) {
                newIsr.add(_element);
            }
            _duplicate.isr = newIsr;
        }
        _duplicate.leader = this.leader;
        if (this.replicas == null) {
            _duplicate.replicas = null;
        } else {
            ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
            for (Integer _element : this.replicas) {
                newReplicas.add(_element);
            }
            _duplicate.replicas = newReplicas;
        }
        if (this.removingReplicas == null) {
            _duplicate.removingReplicas = null;
        } else {
            ArrayList<Integer> newRemovingReplicas = new ArrayList<Integer>(this.removingReplicas.size());
            for (Integer _element : this.removingReplicas) {
                newRemovingReplicas.add(_element);
            }
            _duplicate.removingReplicas = newRemovingReplicas;
        }
        if (this.addingReplicas == null) {
            _duplicate.addingReplicas = null;
        } else {
            ArrayList<Integer> newAddingReplicas = new ArrayList<Integer>(this.addingReplicas.size());
            for (Integer _element : this.addingReplicas) {
                newAddingReplicas.add(_element);
            }
            _duplicate.addingReplicas = newAddingReplicas;
        }
        return _duplicate;
    }

    public String toString() {
        return "PartitionChangeRecord(partitionId=" + this.partitionId + ", topicId=" + this.topicId.toString() + ", isr=" + (this.isr == null ? "null" : MessageUtil.deepToString(this.isr.iterator())) + ", leader=" + this.leader + ", replicas=" + (this.replicas == null ? "null" : MessageUtil.deepToString(this.replicas.iterator())) + ", removingReplicas=" + (this.removingReplicas == null ? "null" : MessageUtil.deepToString(this.removingReplicas.iterator())) + ", addingReplicas=" + (this.addingReplicas == null ? "null" : MessageUtil.deepToString(this.addingReplicas.iterator())) + ")";
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public List<Integer> isr() {
        return this.isr;
    }

    public int leader() {
        return this.leader;
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> removingReplicas() {
        return this.removingReplicas;
    }

    public List<Integer> addingReplicas() {
        return this.addingReplicas;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public PartitionChangeRecord setPartitionId(int v) {
        this.partitionId = v;
        return this;
    }

    public PartitionChangeRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public PartitionChangeRecord setIsr(List<Integer> v) {
        this.isr = v;
        return this;
    }

    public PartitionChangeRecord setLeader(int v) {
        this.leader = v;
        return this;
    }

    public PartitionChangeRecord setReplicas(List<Integer> v) {
        this.replicas = v;
        return this;
    }

    public PartitionChangeRecord setRemovingReplicas(List<Integer> v) {
        this.removingReplicas = v;
        return this;
    }

    public PartitionChangeRecord setAddingReplicas(List<Integer> v) {
        this.addingReplicas = v;
        return this;
    }
}

