/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Optional;

public enum LeaderRecoveryState {
    RECOVERED(0),
    RECOVERING(1);

    private static final byte NO_CHANGE = -1;
    private final byte value;

    public static LeaderRecoveryState of(byte value) {
        return LeaderRecoveryState.optionalOf(value).orElseThrow(() -> new IllegalArgumentException(String.format("Value %s is not a valid leader recovery state", value)));
    }

    public static Optional<LeaderRecoveryState> optionalOf(byte value) {
        if (value == RECOVERED.value()) {
            return Optional.of(RECOVERED);
        }
        if (value == RECOVERING.value()) {
            return Optional.of(RECOVERING);
        }
        return Optional.empty();
    }

    private LeaderRecoveryState(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public LeaderRecoveryState changeTo(byte value) {
        if (value == -1) {
            return this;
        }
        return LeaderRecoveryState.of(value);
    }
}

