/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class BrokerRegistrationChangeRecordJsonConverter {
    public static BrokerRegistrationChangeRecord read(JsonNode _node, short _version) {
        BrokerRegistrationChangeRecord _object = new BrokerRegistrationChangeRecord();
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("BrokerRegistrationChangeRecord: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt((JsonNode)_brokerIdNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        if (_brokerEpochNode == null) {
            throw new RuntimeException("BrokerRegistrationChangeRecord: unable to locate field 'brokerEpoch', which is mandatory in version " + _version);
        }
        _object.brokerEpoch = MessageUtil.jsonNodeToLong((JsonNode)_brokerEpochNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _fencedNode = _node.get("fenced");
        _object.fenced = _fencedNode == null ? (byte)0 : MessageUtil.jsonNodeToByte((JsonNode)_fencedNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _inControlledShutdownNode = _node.get("inControlledShutdown");
        _object.inControlledShutdown = _inControlledShutdownNode == null ? (byte)0 : MessageUtil.jsonNodeToByte((JsonNode)_inControlledShutdownNode, (String)"BrokerRegistrationChangeRecord");
        JsonNode _degradedComponentsNode = _node.get("degradedComponents");
        if (_degradedComponentsNode == null) {
            _object.degradedComponents = null;
        } else if (_degradedComponentsNode.isNull()) {
            _object.degradedComponents = null;
        } else {
            if (!_degradedComponentsNode.isArray()) {
                throw new RuntimeException("BrokerRegistrationChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<BrokerRegistrationChangeRecord.DegradedComponent> _collection = new ArrayList<BrokerRegistrationChangeRecord.DegradedComponent>(_degradedComponentsNode.size());
            _object.degradedComponents = _collection;
            for (JsonNode _element : _degradedComponentsNode) {
                _collection.add(DegradedComponentJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(BrokerRegistrationChangeRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
        _node.set("brokerEpoch", (JsonNode)new LongNode(_object.brokerEpoch));
        if (_object.fenced != 0) {
            _node.set("fenced", (JsonNode)new ShortNode((short)_object.fenced));
        }
        if (_version >= 1) {
            if (_object.inControlledShutdown != 0) {
                _node.set("inControlledShutdown", (JsonNode)new ShortNode((short)_object.inControlledShutdown));
            }
        } else if (_object.inControlledShutdown != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default inControlledShutdown at version " + _version);
        }
        if (_version >= 1) {
            if (_object.degradedComponents != null) {
                ArrayNode _degradedComponentsArray = new ArrayNode(JsonNodeFactory.instance);
                for (BrokerRegistrationChangeRecord.DegradedComponent _element : _object.degradedComponents) {
                    _degradedComponentsArray.add(DegradedComponentJsonConverter.write(_element, _version, _serializeRecords));
                }
                _node.set("degradedComponents", (JsonNode)_degradedComponentsArray);
            }
        } else if (_object.degradedComponents != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default degradedComponents at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(BrokerRegistrationChangeRecord _object, short _version) {
        return BrokerRegistrationChangeRecordJsonConverter.write(_object, _version, true);
    }

    public static class DegradedComponentJsonConverter {
        public static BrokerRegistrationChangeRecord.DegradedComponent read(JsonNode _node, short _version) {
            BrokerRegistrationChangeRecord.DegradedComponent _object = new BrokerRegistrationChangeRecord.DegradedComponent();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DegradedComponent");
            }
            JsonNode _reasonNode = _node.get("reason");
            if (_reasonNode == null) {
                throw new RuntimeException("DegradedComponent: unable to locate field 'reason', which is mandatory in version " + _version);
            }
            if (!_reasonNode.isTextual()) {
                throw new RuntimeException("DegradedComponent expected a string type, but got " + _node.getNodeType());
            }
            _object.reason = _reasonNode.asText();
            JsonNode _componentCodeNode = _node.get("componentCode");
            if (_componentCodeNode == null) {
                throw new RuntimeException("DegradedComponent: unable to locate field 'componentCode', which is mandatory in version " + _version);
            }
            _object.componentCode = MessageUtil.jsonNodeToByte((JsonNode)_componentCodeNode, (String)"DegradedComponent");
            return _object;
        }

        public static JsonNode write(BrokerRegistrationChangeRecord.DegradedComponent _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DegradedComponent");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("reason", (JsonNode)new TextNode(_object.reason));
            _node.set("componentCode", (JsonNode)new ShortNode((short)_object.componentCode));
            return _node;
        }

        public static JsonNode write(BrokerRegistrationChangeRecord.DegradedComponent _object, short _version) {
            return DegradedComponentJsonConverter.write(_object, _version, true);
        }
    }
}

