/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class PartitionRecord
implements ApiMessage {
    int partitionId;
    Uuid topicId;
    List<Integer> replicas;
    List<Integer> isr;
    List<Integer> removingReplicas;
    List<Integer> addingReplicas;
    int leader;
    byte leaderRecoveryState;
    int leaderEpoch;
    int partitionEpoch;
    int linkedLeaderEpoch;
    byte linkState;
    List<Integer> observers;
    List<Integer> deprecatedDoNotUseTag1003;
    List<Integer> deprecatedDoNotUseTag1004;
    List<Integer> removingObservers;
    List<Integer> addingObservers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), new Field("replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas of this partition, sorted by preferred order."), new Field("isr", (Type)new CompactArrayOf((Type)Type.INT32), "The in-sync replicas of this partition"), new Field("removing_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of removing."), new Field("adding_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of adding."), new Field("leader", (Type)Type.INT32, "The lead replica, or -1 if there is no leader."), new Field("leader_epoch", (Type)Type.INT32, "The epoch of the partition leader."), new Field("partition_epoch", (Type)Type.INT32, "An epoch that gets incremented each time we change anything in the partition."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("leader_recovery_state", (Type)Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise."), 10000, new Field("linked_leader_epoch", (Type)Type.INT32, "Leader epoch of linked cluster for this partition. Default is -1."), 10001, new Field("link_state", (Type)Type.INT8, "Is the link to the other cluster active or failed for this partition. Default is -1 denoting no change or not a mirror partition."), 10002, new Field("observers", (Type)new CompactArrayOf((Type)Type.INT32), "The observers of this partition. Observers are a subset of replicas."), 10003, new Field("deprecated_do_not_use_tag1003", (Type)new CompactArrayOf((Type)Type.INT32), "Deprecated! Do not use. This used to be the removing sync replicas, but they can be derived from the other metadata fields."), 10004, new Field("deprecated_do_not_use_tag1004", (Type)new CompactArrayOf((Type)Type.INT32), "Deprecated! Do not use. This used to be the adding sync replicas, but they can be derived from the other metadata fields."), 10005, new Field("removing_observers", (Type)new CompactArrayOf((Type)Type.INT32), "The observers that we are in the process of removing."), 10006, new Field("adding_observers", (Type)new CompactArrayOf((Type)Type.INT32), "The observers that we are in the process of adding.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public PartitionRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public PartitionRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public PartitionRecord() {
        this.partitionId = -1;
        this.topicId = Uuid.ZERO_UUID;
        this.replicas = new ArrayList<Integer>(0);
        this.isr = new ArrayList<Integer>(0);
        this.removingReplicas = new ArrayList<Integer>(0);
        this.addingReplicas = new ArrayList<Integer>(0);
        this.leader = -1;
        this.leaderRecoveryState = 0;
        this.leaderEpoch = -1;
        this.partitionEpoch = -1;
        this.linkedLeaderEpoch = -1;
        this.linkState = (byte)-1;
        this.observers = new ArrayList<Integer>(0);
        this.deprecatedDoNotUseTag1003 = new ArrayList<Integer>(0);
        this.deprecatedDoNotUseTag1004 = new ArrayList<Integer>(0);
        this.removingObservers = new ArrayList<Integer>(0);
        this.addingObservers = new ArrayList<Integer>(0);
    }

    public short apiKey() {
        return 3;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        this.partitionId = _readable.readInt();
        this.topicId = _readable.readUuid();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field replicas was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.replicas = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field isr was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.isr = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field removingReplicas was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.removingReplicas = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field addingReplicas was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.addingReplicas = newCollection;
        this.leader = _readable.readInt();
        this.leaderRecoveryState = 0;
        this.leaderEpoch = _readable.readInt();
        this.partitionEpoch = _readable.readInt();
        this.linkedLeaderEpoch = -1;
        this.linkState = (byte)-1;
        this.observers = new ArrayList<Integer>(0);
        this.deprecatedDoNotUseTag1003 = new ArrayList<Integer>(0);
        this.deprecatedDoNotUseTag1004 = new ArrayList<Integer>(0);
        this.removingObservers = new ArrayList<Integer>(0);
        this.addingObservers = new ArrayList<Integer>(0);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block14: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    this.leaderRecoveryState = _readable.readByte();
                    continue block14;
                }
                case 10000: {
                    this.linkedLeaderEpoch = _readable.readInt();
                    continue block14;
                }
                case 10001: {
                    this.linkState = _readable.readByte();
                    continue block14;
                }
                case 10002: {
                    int i2;
                    int arrayLength2 = _readable.readUnsignedVarint() - 1;
                    if (arrayLength2 < 0) {
                        throw new RuntimeException("non-nullable field observers was serialized as null");
                    }
                    if (arrayLength2 > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection2 = new ArrayList<Integer>(arrayLength2);
                    for (i2 = 0; i2 < arrayLength2; ++i2) {
                        newCollection2.add(_readable.readInt());
                    }
                    this.observers = newCollection2;
                    continue block14;
                }
                case 10003: {
                    int i2;
                    int arrayLength2 = _readable.readUnsignedVarint() - 1;
                    if (arrayLength2 < 0) {
                        throw new RuntimeException("non-nullable field deprecatedDoNotUseTag1003 was serialized as null");
                    }
                    if (arrayLength2 > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection2 = new ArrayList(arrayLength2);
                    for (i2 = 0; i2 < arrayLength2; ++i2) {
                        newCollection2.add(_readable.readInt());
                    }
                    this.deprecatedDoNotUseTag1003 = newCollection2;
                    continue block14;
                }
                case 10004: {
                    int i2;
                    int arrayLength2 = _readable.readUnsignedVarint() - 1;
                    if (arrayLength2 < 0) {
                        throw new RuntimeException("non-nullable field deprecatedDoNotUseTag1004 was serialized as null");
                    }
                    if (arrayLength2 > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection2 = new ArrayList(arrayLength2);
                    for (i2 = 0; i2 < arrayLength2; ++i2) {
                        newCollection2.add(_readable.readInt());
                    }
                    this.deprecatedDoNotUseTag1004 = newCollection2;
                    continue block14;
                }
                case 10005: {
                    int i2;
                    int arrayLength2 = _readable.readUnsignedVarint() - 1;
                    if (arrayLength2 < 0) {
                        throw new RuntimeException("non-nullable field removingObservers was serialized as null");
                    }
                    if (arrayLength2 > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection2 = new ArrayList(arrayLength2);
                    for (i2 = 0; i2 < arrayLength2; ++i2) {
                        newCollection2.add(_readable.readInt());
                    }
                    this.removingObservers = newCollection2;
                    continue block14;
                }
                case 10006: {
                    int i2;
                    int arrayLength2 = _readable.readUnsignedVarint() - 1;
                    if (arrayLength2 < 0) {
                        throw new RuntimeException("non-nullable field addingObservers was serialized as null");
                    }
                    if (arrayLength2 > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection2 = new ArrayList(arrayLength2);
                    for (i2 = 0; i2 < arrayLength2; ++i2) {
                        newCollection2.add(_readable.readInt());
                    }
                    this.addingObservers = newCollection2;
                    continue block14;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.partitionId);
        _writable.writeUuid(this.topicId);
        _writable.writeUnsignedVarint(this.replicas.size() + 1);
        for (Integer replicasElement : this.replicas) {
            _writable.writeInt(replicasElement.intValue());
        }
        _writable.writeUnsignedVarint(this.isr.size() + 1);
        for (Integer isrElement : this.isr) {
            _writable.writeInt(isrElement.intValue());
        }
        _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
        for (Integer removingReplicasElement : this.removingReplicas) {
            _writable.writeInt(removingReplicasElement.intValue());
        }
        _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
        for (Integer addingReplicasElement : this.addingReplicas) {
            _writable.writeInt(addingReplicasElement.intValue());
        }
        _writable.writeInt(this.leader);
        if (this.leaderRecoveryState != 0) {
            ++_numTaggedFields;
        }
        _writable.writeInt(this.leaderEpoch);
        _writable.writeInt(this.partitionEpoch);
        if (this.linkedLeaderEpoch != -1) {
            ++_numTaggedFields;
        }
        if (this.linkState != -1) {
            ++_numTaggedFields;
        }
        if (!this.observers.isEmpty()) {
            ++_numTaggedFields;
        }
        if (!this.deprecatedDoNotUseTag1003.isEmpty()) {
            ++_numTaggedFields;
        }
        if (!this.deprecatedDoNotUseTag1004.isEmpty()) {
            ++_numTaggedFields;
        }
        if (!this.removingObservers.isEmpty()) {
            ++_numTaggedFields;
        }
        if (!this.addingObservers.isEmpty()) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.leaderRecoveryState != 0) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.leaderRecoveryState);
        }
        _rawWriter.writeRawTags(_writable, 10000);
        if (this.linkedLeaderEpoch != -1) {
            _writable.writeUnsignedVarint(10000);
            _writable.writeUnsignedVarint(4);
            _writable.writeInt(this.linkedLeaderEpoch);
        }
        if (this.linkState != -1) {
            _writable.writeUnsignedVarint(10001);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.linkState);
        }
        if (!this.observers.isEmpty()) {
            _writable.writeUnsignedVarint(10002);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.observers).intValue());
            _writable.writeUnsignedVarint(this.observers.size() + 1);
            for (Integer observersElement : this.observers) {
                _writable.writeInt(observersElement.intValue());
            }
        }
        if (!this.deprecatedDoNotUseTag1003.isEmpty()) {
            _writable.writeUnsignedVarint(10003);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.deprecatedDoNotUseTag1003).intValue());
            _writable.writeUnsignedVarint(this.deprecatedDoNotUseTag1003.size() + 1);
            for (Integer deprecatedDoNotUseTag1003Element : this.deprecatedDoNotUseTag1003) {
                _writable.writeInt(deprecatedDoNotUseTag1003Element.intValue());
            }
        }
        if (!this.deprecatedDoNotUseTag1004.isEmpty()) {
            _writable.writeUnsignedVarint(10004);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.deprecatedDoNotUseTag1004).intValue());
            _writable.writeUnsignedVarint(this.deprecatedDoNotUseTag1004.size() + 1);
            for (Integer deprecatedDoNotUseTag1004Element : this.deprecatedDoNotUseTag1004) {
                _writable.writeInt(deprecatedDoNotUseTag1004Element.intValue());
            }
        }
        if (!this.removingObservers.isEmpty()) {
            _writable.writeUnsignedVarint(10005);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.removingObservers).intValue());
            _writable.writeUnsignedVarint(this.removingObservers.size() + 1);
            for (Integer removingObserversElement : this.removingObservers) {
                _writable.writeInt(removingObserversElement.intValue());
            }
        }
        if (!this.addingObservers.isEmpty()) {
            _writable.writeUnsignedVarint(10006);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.addingObservers).intValue());
            _writable.writeUnsignedVarint(this.addingObservers.size() + 1);
            for (Integer addingObserversElement : this.addingObservers) {
                _writable.writeInt(addingObserversElement.intValue());
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _arraySize;
        int _sizeBeforeArray;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.replicas.size() + 1)));
        _size.addBytes(this.replicas.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.isr.size() + 1)));
        _size.addBytes(this.isr.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.removingReplicas.size() + 1)));
        _size.addBytes(this.removingReplicas.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.addingReplicas.size() + 1)));
        _size.addBytes(this.addingReplicas.size() * 4);
        _size.addBytes(4);
        if (this.leaderRecoveryState != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        _size.addBytes(4);
        _size.addBytes(4);
        if (this.linkedLeaderEpoch != -1) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(4);
        }
        if (this.linkState != -1) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (!this.observers.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.observers.size() + 1)));
            _size.addBytes(this.observers.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.observers, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (!this.deprecatedDoNotUseTag1003.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.deprecatedDoNotUseTag1003.size() + 1)));
            _size.addBytes(this.deprecatedDoNotUseTag1003.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.deprecatedDoNotUseTag1003, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (!this.deprecatedDoNotUseTag1004.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.deprecatedDoNotUseTag1004.size() + 1)));
            _size.addBytes(this.deprecatedDoNotUseTag1004.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.deprecatedDoNotUseTag1004, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (!this.removingObservers.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.removingObservers.size() + 1)));
            _size.addBytes(this.removingObservers.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.removingObservers, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (!this.addingObservers.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.addingObservers.size() + 1)));
            _size.addBytes(this.addingObservers.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.addingObservers, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartitionRecord)) {
            return false;
        }
        PartitionRecord other = (PartitionRecord)obj;
        if (this.partitionId != other.partitionId) {
            return false;
        }
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
            return false;
        }
        if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
            return false;
        }
        if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
            return false;
        }
        if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
            return false;
        }
        if (this.leader != other.leader) {
            return false;
        }
        if (this.leaderRecoveryState != other.leaderRecoveryState) {
            return false;
        }
        if (this.leaderEpoch != other.leaderEpoch) {
            return false;
        }
        if (this.partitionEpoch != other.partitionEpoch) {
            return false;
        }
        if (this.linkedLeaderEpoch != other.linkedLeaderEpoch) {
            return false;
        }
        if (this.linkState != other.linkState) {
            return false;
        }
        if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
            return false;
        }
        if (this.deprecatedDoNotUseTag1003 == null ? other.deprecatedDoNotUseTag1003 != null : !this.deprecatedDoNotUseTag1003.equals(other.deprecatedDoNotUseTag1003)) {
            return false;
        }
        if (this.deprecatedDoNotUseTag1004 == null ? other.deprecatedDoNotUseTag1004 != null : !this.deprecatedDoNotUseTag1004.equals(other.deprecatedDoNotUseTag1004)) {
            return false;
        }
        if (this.removingObservers == null ? other.removingObservers != null : !this.removingObservers.equals(other.removingObservers)) {
            return false;
        }
        if (this.addingObservers == null ? other.addingObservers != null : !this.addingObservers.equals(other.addingObservers)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.partitionId;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
        hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
        hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
        hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
        hashCode = 31 * hashCode + this.leader;
        hashCode = 31 * hashCode + this.leaderRecoveryState;
        hashCode = 31 * hashCode + this.leaderEpoch;
        hashCode = 31 * hashCode + this.partitionEpoch;
        hashCode = 31 * hashCode + this.linkedLeaderEpoch;
        hashCode = 31 * hashCode + this.linkState;
        hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
        hashCode = 31 * hashCode + (this.deprecatedDoNotUseTag1003 == null ? 0 : this.deprecatedDoNotUseTag1003.hashCode());
        hashCode = 31 * hashCode + (this.deprecatedDoNotUseTag1004 == null ? 0 : this.deprecatedDoNotUseTag1004.hashCode());
        hashCode = 31 * hashCode + (this.removingObservers == null ? 0 : this.removingObservers.hashCode());
        hashCode = 31 * hashCode + (this.addingObservers == null ? 0 : this.addingObservers.hashCode());
        return hashCode;
    }

    public PartitionRecord duplicate() {
        PartitionRecord _duplicate = new PartitionRecord();
        _duplicate.partitionId = this.partitionId;
        _duplicate.topicId = this.topicId;
        ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
        for (Integer n : this.replicas) {
            newReplicas.add(n);
        }
        _duplicate.replicas = newReplicas;
        ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
        for (Integer n : this.isr) {
            newIsr.add(n);
        }
        _duplicate.isr = newIsr;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.removingReplicas.size());
        for (Integer n : this.removingReplicas) {
            arrayList.add(n);
        }
        _duplicate.removingReplicas = arrayList;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.addingReplicas.size());
        for (Integer n : this.addingReplicas) {
            arrayList2.add(n);
        }
        _duplicate.addingReplicas = arrayList2;
        _duplicate.leader = this.leader;
        _duplicate.leaderRecoveryState = this.leaderRecoveryState;
        _duplicate.leaderEpoch = this.leaderEpoch;
        _duplicate.partitionEpoch = this.partitionEpoch;
        _duplicate.linkedLeaderEpoch = this.linkedLeaderEpoch;
        _duplicate.linkState = this.linkState;
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(this.observers.size());
        for (Integer n : this.observers) {
            arrayList3.add(n);
        }
        _duplicate.observers = arrayList3;
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(this.deprecatedDoNotUseTag1003.size());
        for (Integer n : this.deprecatedDoNotUseTag1003) {
            arrayList4.add(n);
        }
        _duplicate.deprecatedDoNotUseTag1003 = arrayList4;
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>(this.deprecatedDoNotUseTag1004.size());
        for (Integer n : this.deprecatedDoNotUseTag1004) {
            arrayList5.add(n);
        }
        _duplicate.deprecatedDoNotUseTag1004 = arrayList5;
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>(this.removingObservers.size());
        for (Integer _element : this.removingObservers) {
            arrayList6.add(_element);
        }
        _duplicate.removingObservers = arrayList6;
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>(this.addingObservers.size());
        for (Integer _element : this.addingObservers) {
            arrayList7.add(_element);
        }
        _duplicate.addingObservers = arrayList7;
        return _duplicate;
    }

    public String toString() {
        return "PartitionRecord(partitionId=" + this.partitionId + ", topicId=" + this.topicId.toString() + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", removingReplicas=" + MessageUtil.deepToString(this.removingReplicas.iterator()) + ", addingReplicas=" + MessageUtil.deepToString(this.addingReplicas.iterator()) + ", leader=" + this.leader + ", leaderRecoveryState=" + this.leaderRecoveryState + ", leaderEpoch=" + this.leaderEpoch + ", partitionEpoch=" + this.partitionEpoch + ", linkedLeaderEpoch=" + this.linkedLeaderEpoch + ", linkState=" + this.linkState + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ", deprecatedDoNotUseTag1003=" + MessageUtil.deepToString(this.deprecatedDoNotUseTag1003.iterator()) + ", deprecatedDoNotUseTag1004=" + MessageUtil.deepToString(this.deprecatedDoNotUseTag1004.iterator()) + ", removingObservers=" + MessageUtil.deepToString(this.removingObservers.iterator()) + ", addingObservers=" + MessageUtil.deepToString(this.addingObservers.iterator()) + ")";
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> isr() {
        return this.isr;
    }

    public List<Integer> removingReplicas() {
        return this.removingReplicas;
    }

    public List<Integer> addingReplicas() {
        return this.addingReplicas;
    }

    public int leader() {
        return this.leader;
    }

    public byte leaderRecoveryState() {
        return this.leaderRecoveryState;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public int partitionEpoch() {
        return this.partitionEpoch;
    }

    public int linkedLeaderEpoch() {
        return this.linkedLeaderEpoch;
    }

    public byte linkState() {
        return this.linkState;
    }

    public List<Integer> observers() {
        return this.observers;
    }

    public List<Integer> deprecatedDoNotUseTag1003() {
        return this.deprecatedDoNotUseTag1003;
    }

    public List<Integer> deprecatedDoNotUseTag1004() {
        return this.deprecatedDoNotUseTag1004;
    }

    public List<Integer> removingObservers() {
        return this.removingObservers;
    }

    public List<Integer> addingObservers() {
        return this.addingObservers;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public PartitionRecord setPartitionId(int v) {
        this.partitionId = v;
        return this;
    }

    public PartitionRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public PartitionRecord setReplicas(List<Integer> v) {
        this.replicas = v;
        return this;
    }

    public PartitionRecord setIsr(List<Integer> v) {
        this.isr = v;
        return this;
    }

    public PartitionRecord setRemovingReplicas(List<Integer> v) {
        this.removingReplicas = v;
        return this;
    }

    public PartitionRecord setAddingReplicas(List<Integer> v) {
        this.addingReplicas = v;
        return this;
    }

    public PartitionRecord setLeader(int v) {
        this.leader = v;
        return this;
    }

    public PartitionRecord setLeaderRecoveryState(byte v) {
        this.leaderRecoveryState = v;
        return this;
    }

    public PartitionRecord setLeaderEpoch(int v) {
        this.leaderEpoch = v;
        return this;
    }

    public PartitionRecord setPartitionEpoch(int v) {
        this.partitionEpoch = v;
        return this;
    }

    public PartitionRecord setLinkedLeaderEpoch(int v) {
        this.linkedLeaderEpoch = v;
        return this;
    }

    public PartitionRecord setLinkState(byte v) {
        this.linkState = v;
        return this;
    }

    public PartitionRecord setObservers(List<Integer> v) {
        this.observers = v;
        return this;
    }

    public PartitionRecord setDeprecatedDoNotUseTag1003(List<Integer> v) {
        this.deprecatedDoNotUseTag1003 = v;
        return this;
    }

    public PartitionRecord setDeprecatedDoNotUseTag1004(List<Integer> v) {
        this.deprecatedDoNotUseTag1004 = v;
        return this;
    }

    public PartitionRecord setRemovingObservers(List<Integer> v) {
        this.removingObservers = v;
        return this;
    }

    public PartitionRecord setAddingObservers(List<Integer> v) {
        this.addingObservers = v;
        return this;
    }
}

