/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineObject;
import org.slf4j.Logger;

public class EncryptionControlManager {
    private final Logger log;
    private final TimelineObject<MetadataEncryptor> encryptor;
    private final MetadataEncryptorFactory encryptorFactory;

    EncryptionControlManager(LogContext logContext, SnapshotRegistry snapshotRegistry, Map<String, Object> configMap) {
        this.log = logContext.logger(EncryptionControlManager.class);
        this.encryptor = new TimelineObject(snapshotRegistry, (Object)NoOpMetadataEncryptor.INSTANCE);
        this.encryptorFactory = new MetadataEncryptorFactory(configMap);
    }

    public void replay(InstallMetadataEncryptorRecord record) {
        MetadataEncryptor newEncryptor = this.encryptorFactory.createFromConfig(record);
        this.encryptor.set((Object)newEncryptor);
        this.log.info("Loaded {} with id {}", (Object)this.encryptor.getClass().getSimpleName(), (Object)record.keyId());
    }

    public ApiMessageAndVersion decrypt(EncryptedEnvelopeRecord record) {
        return ((MetadataEncryptor)this.encryptor.get()).decrypt(record);
    }

    public ControllerResult<Void> maybeInstallEncryptor() {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>(0);
        if (!((MetadataEncryptor)this.encryptor.get()).id().equals((Object)this.encryptorFactory.activeId())) {
            records.add(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(this.encryptorFactory.activeId()), 0));
        }
        return new ControllerResult<Object>(records, null, true);
    }

    public MetadataEncryptor encryptor() {
        return (MetadataEncryptor)this.encryptor.get();
    }

    public MetadataEncryptor encryptor(long epoch) {
        return (MetadataEncryptor)this.encryptor.get(epoch);
    }

    Uuid encryptorId() {
        return ((MetadataEncryptor)this.encryptor.get()).id();
    }

    EncryptionControlIterator iterator(long epoch) {
        return new EncryptionControlIterator(((MetadataEncryptor)this.encryptor.get(epoch)).id());
    }

    class EncryptionControlIterator
    implements Iterator<List<ApiMessageAndVersion>> {
        private Uuid id;

        EncryptionControlIterator(Uuid id) {
            this.id = id;
        }

        @Override
        public boolean hasNext() {
            return this.id != null;
        }

        @Override
        public List<ApiMessageAndVersion> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            List<ApiMessageAndVersion> result = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(this.id), 0));
            this.id = null;
            return result;
        }
    }
}

