/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.node.AclsImageByIdNode;
import org.apache.kafka.image.node.BrokerReplicaExclusionsImageNode;
import org.apache.kafka.image.node.CellImageNode;
import org.apache.kafka.image.node.ClientQuotasImageNode;
import org.apache.kafka.image.node.ClusterImageNode;
import org.apache.kafka.image.node.ClusterLinksImageNode;
import org.apache.kafka.image.node.ConfigurationsImageNode;
import org.apache.kafka.image.node.FeaturesImageNode;
import org.apache.kafka.image.node.MetadataEncryptorNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.ProducerIdsImageNode;
import org.apache.kafka.image.node.ProvenanceNode;
import org.apache.kafka.image.node.ScramImageNode;
import org.apache.kafka.image.node.TenantImageNode;
import org.apache.kafka.image.node.TopicsImageNode;

public class MetadataImageNode
implements MetadataNode {
    public static final String NAME = "image";
    private final MetadataImage image;
    private static final Map<String, Function<MetadataImage, MetadataNode>> CHILDREN;

    public MetadataImageNode(MetadataImage image) {
        this.image = image;
    }

    public MetadataImage image() {
        return this.image;
    }

    @Override
    public Collection<String> childNames() {
        return CHILDREN.keySet();
    }

    @Override
    public MetadataNode child(String name) {
        return CHILDREN.getOrDefault(name, __ -> null).apply(this.image);
    }

    static {
        HashMap<String, Function<MetadataImage, MetadataNode>> children = new HashMap<String, Function<MetadataImage, MetadataNode>>();
        children.put("provenance", image -> new ProvenanceNode(image.provenance()));
        children.put("features", image -> new FeaturesImageNode(image.features()));
        children.put("cluster", image -> new ClusterImageNode(image.cluster()));
        children.put("topics", image -> new TopicsImageNode(image.topics()));
        children.put("configs", image -> new ConfigurationsImageNode(image.configs()));
        children.put("clientQuotas", image -> new ClientQuotasImageNode(image.clientQuotas()));
        children.put("producerIds", image -> new ProducerIdsImageNode(image.producerIds()));
        children.put("acls", image -> new AclsImageByIdNode(image.acls()));
        children.put("clusterLinks", image -> new ClusterLinksImageNode(image.clusterLinks()));
        children.put("replicaExclusions", image -> new BrokerReplicaExclusionsImageNode(image.brokerReplicaExclusions()));
        children.put("cells", image -> new CellImageNode(image.cells()));
        children.put("tenants", image -> new TenantImageNode(image.tenants()));
        children.put("encryptor", image -> new MetadataEncryptorNode(image.encryptor()));
        children.put("scram", image -> new ScramImageNode(image.scram()));
        CHILDREN = Collections.unmodifiableMap(children);
    }
}

