/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.MetadataEncryptor;

public class AesGcm128MetadataEncryptor
implements MetadataEncryptor {
    private static final int NUM_INIT_VECTOR_BYTES = 12;
    private static final int NUM_AUTH_TAG_BITS = 128;
    static final int KEY_LENGTH = 16;
    private final Uuid id;
    private final SecureRandom random;
    private final Cipher cipher;
    private final SecretKeySpec secretKeySpec;

    public AesGcm128MetadataEncryptor() throws GeneralSecurityException {
        this.id = Uuid.randomUuid();
        this.random = new SecureRandom();
        this.cipher = AesGcm128MetadataEncryptor.createCipher();
        byte[] secret = new byte[16];
        this.random.nextBytes(secret);
        this.secretKeySpec = AesGcm128MetadataEncryptor.createSecretKeySpec(secret);
    }

    public AesGcm128MetadataEncryptor(Uuid id, byte[] secret) throws GeneralSecurityException {
        if (id.equals((Object)Uuid.ZERO_UUID)) {
            throw new RuntimeException("Invalid zero id.");
        }
        this.id = id;
        this.random = new SecureRandom();
        this.cipher = AesGcm128MetadataEncryptor.createCipher();
        if (secret.length != 16) {
            throw new RuntimeException("Invalid key length " + secret.length + ". " + this.getClass().getSimpleName() + " requires a length of " + 16);
        }
        this.secretKeySpec = AesGcm128MetadataEncryptor.createSecretKeySpec(secret);
    }

    private static Cipher createCipher() throws GeneralSecurityException {
        return Cipher.getInstance("AES/GCM/NoPadding");
    }

    private static SecretKeySpec createSecretKeySpec(byte[] secret) {
        return new SecretKeySpec(secret, "AES");
    }

    @Override
    public Uuid id() {
        return this.id;
    }

    @Override
    public byte[] decrypt(byte[] input) {
        try {
            byte[] iv = new byte[12];
            System.arraycopy(input, 0, iv, 0, iv.length);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            this.cipher.init(2, (Key)this.secretKeySpec, parameterSpec);
            byte[] cipherTextAndAuthTag = new byte[input.length - iv.length];
            System.arraycopy(input, iv.length, cipherTextAndAuthTag, 0, input.length - iv.length);
            byte[] plaintext = this.cipher.doFinal(cipherTextAndAuthTag);
            return plaintext;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("decryption failed", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] input) {
        try {
            byte[] iv = new byte[12];
            this.random.nextBytes(iv);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            this.cipher.init(1, (Key)this.secretKeySpec, parameterSpec);
            byte[] cipherTextAndAuthTag = this.cipher.doFinal(input);
            byte[] result = new byte[iv.length + cipherTextAndAuthTag.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(cipherTextAndAuthTag, 0, result, iv.length, cipherTextAndAuthTag.length);
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("encryption failed", e);
        }
    }

    @Override
    public byte[] secret() {
        return this.secretKeySpec.getEncoded();
    }
}

