/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerData;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableNavigableMap;
import org.apache.kafka.server.immutable.ImmutableNavigableSet;

public class AclCache {
    private final ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks> aclsByResource;
    private final ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> denyAclsByPrincipal;
    private final ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> allowAclsByPrincipal;
    private final ImmutableMap<Uuid, ConfluentStandardAcl> aclsById;

    public AclCache() {
        this((ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>)ImmutableNavigableMap.empty(), (ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>>)ImmutableMap.empty(), (ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>>)ImmutableMap.empty(), (ImmutableMap<Uuid, ConfluentStandardAcl>)ImmutableMap.empty());
    }

    public AclCache(ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks> aclsByResource, ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> denyAclsByPrincipal, ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> allowAclsByPrincipal, ImmutableMap<Uuid, ConfluentStandardAcl> aclsById) {
        this.aclsByResource = aclsByResource;
        this.denyAclsByPrincipal = denyAclsByPrincipal;
        this.allowAclsByPrincipal = allowAclsByPrincipal;
        this.aclsById = aclsById;
    }

    public SortedMap<StandardAcl, StandardAuthorizerData.AclLinks> aclsByResource() {
        return this.aclsByResource;
    }

    public SortedSet<StandardAcl> denyAclsByPrincipal(KafkaPrincipal principal) {
        return (SortedSet)this.denyAclsByPrincipal.getOrDefault((Object)principal, (Object)ImmutableNavigableSet.empty());
    }

    public SortedSet<StandardAcl> allowAclsByPrincipal(KafkaPrincipal principal) {
        return (SortedSet)this.allowAclsByPrincipal.getOrDefault((Object)principal, (Object)ImmutableNavigableSet.empty());
    }

    public Map<Uuid, ConfluentStandardAcl> aclsById() {
        return this.aclsById;
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        ArrayList<AclBinding> aclBindingList = new ArrayList<AclBinding>();
        this.aclsByResource.forEach((acl, links) -> {
            AclBinding aclBinding = acl.toBinding(links.aclBindingLinksIds());
            if (filter.matches(aclBinding)) {
                aclBindingList.add(aclBinding);
            }
        });
        return aclBindingList;
    }

    public SortedSet<StandardAcl> allAcls() {
        return this.aclsByResource.navigableKeySet();
    }

    public AclCache clear() {
        return new AclCache();
    }

    public int count() {
        return this.aclsById.size();
    }

    public ConfluentStandardAcl getAcl(Uuid id) {
        return (ConfluentStandardAcl)this.aclsById.get((Object)id);
    }

    public AclCache addAcl(Uuid id, ConfluentStandardAcl acl) {
        ImmutableNavigableSet newPrincipalAcls;
        ImmutableNavigableMap aclsByResource = this.aclsByResource;
        ImmutableMap allowAclsByPrincipal = this.allowAclsByPrincipal;
        ImmutableMap denyAclsByPrincipal = this.denyAclsByPrincipal;
        ImmutableMap aclsById = this.aclsById;
        StandardAcl standardAcl = acl.standardAcl();
        Optional<Uuid> linkIdToAdd = acl.clusterLinkId();
        aclsById = aclsById.updated((Object)id, (Object)acl);
        StandardAuthorizerData.AclLinks newLinks = (StandardAuthorizerData.AclLinks)aclsByResource.get((Object)standardAcl);
        newLinks = newLinks == null ? new StandardAuthorizerData.AclLinks(standardAcl, Collections.singleton(linkIdToAdd.orElse(Uuid.ZERO_UUID))) : newLinks.copyAndAddLinkId(linkIdToAdd);
        aclsByResource = aclsByResource.updated((Object)standardAcl, (Object)newLinks);
        if (standardAcl.permissionType().equals((Object)AclPermissionType.ALLOW)) {
            newPrincipalAcls = ((ImmutableNavigableSet)allowAclsByPrincipal.getOrDefault((Object)standardAcl.kafkaPrincipal(), (Object)ImmutableNavigableSet.empty())).added((Object)standardAcl);
            allowAclsByPrincipal = allowAclsByPrincipal.updated((Object)standardAcl.kafkaPrincipal(), (Object)newPrincipalAcls);
        }
        if (standardAcl.permissionType().equals((Object)AclPermissionType.DENY)) {
            newPrincipalAcls = ((ImmutableNavigableSet)denyAclsByPrincipal.getOrDefault((Object)standardAcl.kafkaPrincipal(), (Object)ImmutableNavigableSet.empty())).added((Object)standardAcl);
            denyAclsByPrincipal = denyAclsByPrincipal.updated((Object)standardAcl.kafkaPrincipal(), (Object)newPrincipalAcls);
        }
        return new AclCache((ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>)aclsByResource, denyAclsByPrincipal, allowAclsByPrincipal, (ImmutableMap<Uuid, ConfluentStandardAcl>)aclsById);
    }

    public AclCache removeAcl(Uuid id) {
        ImmutableMap aclsById = this.aclsById;
        ImmutableNavigableMap aclsByResource = this.aclsByResource;
        ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> allowAclsByPrincipal = this.allowAclsByPrincipal;
        ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> denyAclsByPrincipal = this.denyAclsByPrincipal;
        ConfluentStandardAcl acl = (ConfluentStandardAcl)aclsById.get((Object)id);
        if (acl == null) {
            throw new RuntimeException("ID " + id + " not found in aclsById.");
        }
        aclsById = aclsById.removed((Object)id);
        StandardAcl standardAcl = acl.standardAcl();
        StandardAuthorizerData.AclLinks links = (StandardAuthorizerData.AclLinks)aclsByResource.get((Object)standardAcl);
        if (links == null) {
            throw new RuntimeException("ACL  " + acl + " not found in aclsByResource");
        }
        StandardAuthorizerData.AclLinks newAclLinks = links.copyAndRemoveLinkId(acl.clusterLinkId());
        if (!newAclLinks.isEmpty()) {
            aclsByResource = aclsByResource.updated((Object)standardAcl, (Object)newAclLinks);
        } else {
            aclsByResource = aclsByResource.removed((Object)standardAcl);
            if (standardAcl.permissionType().equals((Object)AclPermissionType.ALLOW)) {
                allowAclsByPrincipal = this.removeAclFromPrincipalAclCache(allowAclsByPrincipal, standardAcl, id, true);
            }
            if (standardAcl.permissionType().equals((Object)AclPermissionType.DENY)) {
                denyAclsByPrincipal = this.removeAclFromPrincipalAclCache(denyAclsByPrincipal, standardAcl, id, false);
            }
        }
        return new AclCache((ImmutableNavigableMap<StandardAcl, StandardAuthorizerData.AclLinks>)aclsByResource, denyAclsByPrincipal, allowAclsByPrincipal, (ImmutableMap<Uuid, ConfluentStandardAcl>)aclsById);
    }

    public boolean validateAclCache() {
        final Set allowAcls = this.allowAclsByPrincipal.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        final Set denyAcls = this.denyAclsByPrincipal.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (!allowAcls.isEmpty() && !allowAcls.stream().filter(acl -> acl.permissionType() != AclPermissionType.ALLOW).collect(Collectors.toSet()).isEmpty()) {
            return false;
        }
        if (!denyAcls.isEmpty() && !denyAcls.stream().filter(acl -> acl.permissionType() != AclPermissionType.DENY).collect(Collectors.toSet()).isEmpty()) {
            return false;
        }
        HashSet<StandardAcl> cachedAcls = new HashSet<StandardAcl>(){
            {
                this.addAll(allowAcls);
                this.addAll(denyAcls);
            }
        };
        return new HashSet(this.aclsByResource.keySet()).equals(cachedAcls);
    }

    private ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> removeAclFromPrincipalAclCache(ImmutableMap<KafkaPrincipal, ImmutableNavigableSet<StandardAcl>> aclsByPrincipal, StandardAcl standardAcl, Uuid id, boolean isAllow) {
        ImmutableNavigableSet aclSet = (ImmutableNavigableSet)aclsByPrincipal.get((Object)standardAcl.kafkaPrincipal());
        if (aclSet == null || !aclSet.contains((Object)standardAcl)) {
            throw new RuntimeException("Unable to remove the ACL with " + id + " from " + (isAllow ? "allowAclsByPrincipal" : "denyAclsByPrincipal"));
        }
        if ((aclSet = aclSet.removed((Object)standardAcl)).isEmpty()) {
            return aclsByPrincipal.removed((Object)standardAcl.kafkaPrincipal());
        }
        return aclsByPrincipal.updated((Object)standardAcl.kafkaPrincipal(), (Object)aclSet);
    }
}

