/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.metadata.authorizer.StandardAcl;

public class ConfluentStandardAcl {
    private final StandardAcl standardAcl;
    private final Optional<Uuid> clusterLinkId;

    public ConfluentStandardAcl(StandardAcl standardAcl, Optional<Uuid> clusterLinkId) {
        this.standardAcl = standardAcl;
        this.clusterLinkId = clusterLinkId;
    }

    public StandardAcl standardAcl() {
        return this.standardAcl;
    }

    public Optional<Uuid> clusterLinkId() {
        return this.clusterLinkId;
    }

    public static List<ConfluentStandardAcl> fromAclBinding(AclBinding aclBinding) {
        StandardAcl standardAcl = ConfluentStandardAcl.standardAclFromAclBinding(aclBinding);
        if (aclBinding.entry().clusterLinkIds().isEmpty()) {
            return Collections.singletonList(new ConfluentStandardAcl(standardAcl, Optional.empty()));
        }
        return aclBinding.entry().clusterLinkIds().stream().map(linkId -> new ConfluentStandardAcl(standardAcl, Optional.of(linkId))).collect(Collectors.toList());
    }

    private static StandardAcl standardAclFromAclBinding(AclBinding aclBinding) {
        return StandardAcl.fromAclBinding(aclBinding);
    }

    public AclBinding toBinding() {
        Set linkIds = this.clusterLinkId.map(Collections::singleton).orElse(Collections.emptySet());
        AccessControlEntry accessControlEntry = new AccessControlEntry(this.standardAcl.principal(), this.standardAcl.host(), this.standardAcl.operation(), this.standardAcl.permissionType(), linkIds);
        return new AclBinding(this.standardAcl.resourcePattern(), accessControlEntry);
    }

    public static ConfluentStandardAcl fromRecord(AccessControlEntryRecord record) {
        Optional<Uuid> linkId = record.clusterLinkId().equals((Object)Uuid.ZERO_UUID) ? Optional.empty() : Optional.of(record.clusterLinkId());
        return new ConfluentStandardAcl(StandardAcl.fromRecord(record), linkId);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(ConfluentStandardAcl.class)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ConfluentStandardAcl other = (ConfluentStandardAcl)o;
        return Objects.equals(this.standardAcl, other.standardAcl) && Objects.equals(this.clusterLinkId, other.clusterLinkId);
    }

    public int hashCode() {
        return Objects.hash(this.standardAcl, this.clusterLinkId);
    }

    public String toString() {
        return "ConfluentStandardAcl(standardAcl=" + this.standardAcl + ", clusterLinkId=" + this.clusterLinkId + ")";
    }

    public ConfluentStandardAcl toLocalAcl() {
        if (this.clusterLinkId.equals(Uuid.ZERO_UUID)) {
            return this;
        }
        return new ConfluentStandardAcl(this.standardAcl, Optional.empty());
    }

    public boolean hasLinkId() {
        return this.clusterLinkId.isPresent() && !this.clusterLinkId.get().equals((Object)Uuid.ZERO_UUID);
    }
}

