/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerIdNotRegisteredException;
import org.apache.kafka.common.errors.DemotionLimitReachedException;
import org.apache.kafka.common.errors.DuplicateBrokerRegistrationException;
import org.apache.kafka.common.errors.InconsistentClusterIdException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerHeartbeatManager;
import org.apache.kafka.controller.CellControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.metrics.ControllerMetrics;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.BrokerReplicaExclusionModificationResult;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.server.util.BrokerReplicaExclusionUtils;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class ClusterControlManager {
    static final long DEFAULT_SESSION_TIMEOUT_NS = TimeUnit.NANOSECONDS.convert(9L, TimeUnit.SECONDS);
    private final LogContext logContext;
    private final String clusterId;
    private final Logger log;
    private final Time time;
    private final long sessionTimeoutNs;
    private final ReplicaPlacer replicaPlacer;
    private final TimelineHashMap<Integer, BrokerRegistration> brokerRegistrations;
    private final TimelineHashMap<Integer, Long> registerBrokerRecordOffsets;
    private final TimelineHashMap<Integer, String> brokerReplicaExclusions;
    private final ControllerMetrics controllerMetrics;
    private BrokerHeartbeatManager heartbeatManager;
    private Optional<ReadyBrokersFuture> readyBrokersFuture;
    private final FeatureControlManager featureControl;
    private final boolean zkMigrationEnabled;
    private final CellControlManager cellControl;

    private ClusterControlManager(LogContext logContext, String clusterId, Time time, SnapshotRegistry snapshotRegistry, long sessionTimeoutNs, ReplicaPlacer replicaPlacer, ControllerMetrics metrics, FeatureControlManager featureControl, boolean zkMigrationEnabled, CellControlManager cellControl) {
        this.logContext = logContext;
        this.clusterId = clusterId;
        this.log = logContext.logger(ClusterControlManager.class);
        this.time = time;
        this.sessionTimeoutNs = sessionTimeoutNs;
        this.replicaPlacer = replicaPlacer;
        this.brokerRegistrations = new TimelineHashMap(snapshotRegistry, 0);
        this.registerBrokerRecordOffsets = new TimelineHashMap(snapshotRegistry, 0);
        this.brokerReplicaExclusions = new TimelineHashMap(snapshotRegistry, 0);
        this.heartbeatManager = null;
        this.readyBrokersFuture = Optional.empty();
        this.controllerMetrics = metrics;
        this.featureControl = featureControl;
        this.zkMigrationEnabled = zkMigrationEnabled;
        this.cellControl = cellControl;
    }

    ReplicaPlacer replicaPlacer() {
        return this.replicaPlacer;
    }

    public void activate() {
        this.heartbeatManager = new BrokerHeartbeatManager(this.logContext, this.time, this.sessionTimeoutNs);
        for (BrokerRegistration registration : this.brokerRegistrations.values()) {
            this.heartbeatManager.touch(registration.id(), registration.fenced(), -1L);
        }
    }

    public void deactivate() {
        this.heartbeatManager = null;
    }

    Map<Integer, BrokerRegistration> brokerRegistrations() {
        return this.brokerRegistrations;
    }

    Set<Integer> cellBrokers(int cellId) {
        return this.cellControl.getCell(cellId).map(Cell::brokers).orElse(Collections.emptySet());
    }

    Map<Integer, Map<String, VersionRange>> brokerSupportedVersions() {
        return this.brokerRegistrations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((BrokerRegistration)entry.getValue()).supportedFeatures()));
    }

    Set<Integer> fencedBrokerIds() {
        return this.brokerRegistrations.values().stream().filter(BrokerRegistration::fenced).map(BrokerRegistration::id).collect(Collectors.toSet());
    }

    boolean zkRegistrationAllowed() {
        return this.zkMigrationEnabled && this.featureControl.metadataVersion().isMigrationSupported();
    }

    public Map<Integer, String> activeBrokerReplicaExclusions() {
        return Collections.unmodifiableMap(this.brokerReplicaExclusions);
    }

    public Map<Integer, Set<DegradedBrokerHealthState>> activeBrokerComponentDegradations() {
        HashMap degradations = new HashMap();
        this.brokerRegistrations().forEach((brokerId, brokerRegistration) -> {
            Set<DegradedBrokerHealthState> degradedComponents = brokerRegistration.degradedComponents();
            if (degradedComponents != null && !degradedComponents.isEmpty()) {
                degradations.put(brokerId, degradedComponents);
            }
        });
        return Collections.unmodifiableMap(degradations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ControllerResult<BrokerRegistrationReply> registerBroker(BrokerRegistrationRequestData request, long brokerEpoch, FinalizedControllerFeatures finalizedFeatures) {
        if (this.heartbeatManager == null) {
            throw new RuntimeException("ClusterControlManager is not active.");
        }
        if (!this.clusterId.equals(request.clusterId())) {
            throw new InconsistentClusterIdException("Expected cluster ID " + this.clusterId + ", but got cluster ID " + request.clusterId());
        }
        int brokerId = request.brokerId();
        BrokerRegistration existing = (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
        if (existing != null) {
            if (this.heartbeatManager.hasValidSession(brokerId)) {
                if (!existing.incarnationId().equals((Object)request.incarnationId())) {
                    throw new DuplicateBrokerRegistrationException("Another broker is registered with that broker id.");
                }
            } else if (!existing.incarnationId().equals((Object)request.incarnationId())) {
                this.heartbeatManager.remove(brokerId);
            }
        }
        if (request.isMigratingZkBroker() && !this.zkRegistrationAllowed()) {
            throw new BrokerIdNotRegisteredException("Controller does not support registering ZK brokers.");
        }
        if (!request.isMigratingZkBroker() && this.featureControl.inPreMigrationMode()) {
            throw new BrokerIdNotRegisteredException("Controller is in pre-migration mode and cannot register KRaft brokers until the metadata migration is complete.");
        }
        RegisterBrokerRecord record = new RegisterBrokerRecord().setBrokerId(brokerId).setIsMigratingZkBroker(request.isMigratingZkBroker()).setIncarnationId(request.incarnationId()).setBrokerEpoch(brokerEpoch).setRack(request.rack());
        if (this.activeBrokerComponentDegradations().containsKey(brokerId)) {
            record.setDegradedComponents(DegradedBrokerHealthState.toRegisterBrokerRecordDegradedComponent(this.activeBrokerComponentDegradations().get(brokerId)));
        }
        for (Object listener : request.listeners()) {
            record.endPoints().add(new RegisterBrokerRecord.BrokerEndpoint().setHost(listener.host()).setName(listener.name()).setPort(listener.port()).setSecurityProtocol(listener.securityProtocol()));
        }
        HashMap<String, VersionRange> ranges = new HashMap<String, VersionRange>();
        for (BrokerRegistrationRequestData.Feature feature : request.features()) {
            record.features().add(new RegisterBrokerRecord.BrokerFeature().setName(feature.name()).setMinSupportedVersion(feature.minSupportedVersion()).setMaxSupportedVersion(feature.maxSupportedVersion()));
            ranges.put(feature.name(), VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()));
        }
        for (Map.Entry entry : ranges.entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals("metadata.version") || name.equals("confluent.metadata.version")) continue;
            Optional<Short> finalized = finalizedFeatures.get((String)entry.getKey());
            if (finalized.isPresent()) {
                if (VersionRange.of(((VersionRange)entry.getValue()).min(), ((VersionRange)entry.getValue()).max()).contains(finalized.get())) continue;
                this.throwUnsupportedVersionDueToIncompatibleFeature(brokerId, name, (VersionRange)entry.getValue(), finalized.get());
                continue;
            }
            this.log.warn("Broker {} registered with feature {} that is unknown to the controller", (Object)brokerId, (Object)name);
        }
        VersionRange confluentRange = (VersionRange)ranges.get("confluent.metadata.version");
        VersionRange versionRange = (VersionRange)ranges.get("metadata.version");
        Optional<Short> confluentMetadataLevel = finalizedFeatures.get("confluent.metadata.version");
        if (!confluentMetadataLevel.isPresent()) {
            confluentMetadataLevel = Optional.of(MetadataVersion.MINIMUM_KRAFT_VERSION.confluentFeatureLevel());
        }
        if (confluentRange == null) {
            if (versionRange != null) throw new UnsupportedVersionException("Unable to register broker " + brokerId + " because it does not support confluent.metadata.version. Please upgrade your broker to Confluent Platform, or downgrade your controller to Apache Kafka. Brokers must be upgraded first in a rolling upgrade from Apache to CP.");
            VersionRange versionRange2 = VersionRange.of(MetadataVersion.MINIMUM_KRAFT_VERSION.apacheFeatureLevel(), MetadataVersion.MINIMUM_KRAFT_VERSION.apacheFeatureLevel());
            confluentRange = VersionRange.of(MetadataVersion.MINIMUM_KRAFT_VERSION.confluentFeatureLevel(), MetadataVersion.MINIMUM_KRAFT_VERSION.confluentFeatureLevel());
            if (!confluentRange.contains(confluentMetadataLevel.get())) {
                this.throwUnsupportedVersionDueToIncompatibleFeature(brokerId, "confluent.metadata.version", confluentRange, confluentMetadataLevel.get());
            }
            record.features().add(new RegisterBrokerRecord.BrokerFeature().setName("metadata.version").setMinSupportedVersion(versionRange2.min()).setMaxSupportedVersion(versionRange2.max()));
            record.features().add(new RegisterBrokerRecord.BrokerFeature().setName("confluent.metadata.version").setMinSupportedVersion(confluentRange.min()).setMaxSupportedVersion(confluentRange.max()));
        } else {
            short max;
            short min = confluentRange.min();
            if (min >= 1 && min <= 7) {
                min = (short)(min + 100);
            }
            if ((max = confluentRange.max()) >= 1 && max <= 7) {
                max = (short)(max + 100);
            }
            if (!(confluentRange = VersionRange.of(min, max)).contains(confluentMetadataLevel.get())) {
                this.throwUnsupportedVersionDueToIncompatibleFeature(brokerId, "confluent.metadata.version", confluentRange, confluentMetadataLevel.get());
            }
        }
        this.heartbeatManager.register(brokerId, record.fenced());
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)record, this.featureControl.metadataVersion().registerBrokerRecordVersion()));
        if (!this.cellControl.isImplicitCellCreationEnabled()) return ControllerResult.atomicOf(records, new BrokerRegistrationReply(brokerEpoch));
        this.cellControl.createCellForBroker(brokerId, records::add);
        return ControllerResult.atomicOf(records, new BrokerRegistrationReply(brokerEpoch));
    }

    private void throwUnsupportedVersionDueToIncompatibleFeature(int brokerId, String name, VersionRange range, short finalizedLevel) {
        String logMessage = "Unable to register broker " + brokerId + " because it does not support version " + finalizedLevel + " of " + name + ". It wants a version between " + range.min() + " and " + range.max() + ", inclusive.";
        this.log.error(logMessage);
        throw new UnsupportedVersionException(logMessage);
    }

    public OptionalLong registerBrokerRecordOffset(int brokerId) {
        Long registrationOffset = (Long)this.registerBrokerRecordOffsets.get((Object)brokerId);
        if (registrationOffset != null) {
            return OptionalLong.of(registrationOffset);
        }
        return OptionalLong.empty();
    }

    public ControllerResult<AlterReplicaExclusionsReply> processAlterReplicaExclusions(Set<AlterReplicaExclusionOp> requestedExclusions) {
        if (BrokerReplicaExclusionUtils.exclusionsMatchCurrentState(this.brokerReplicaExclusions, requestedExclusions)) {
            Set results = requestedExclusions.stream().map(op -> new BrokerReplicaExclusionResult(op.brokerId(), Optional.empty(), op.opType(), op.reason())).collect(Collectors.toSet());
            this.log.debug("Request with exclusion operations {} was matches the current state of the cluster - returning a successful response and not applying anything.", requestedExclusions);
            return ControllerResult.of(Collections.emptyList(), new AlterReplicaExclusionsReply(true, true, results));
        }
        BrokerReplicaExclusionModificationResult modificationResult = BrokerReplicaExclusionUtils.prepareReplicaExclusions(this.brokerReplicaExclusions, requestedExclusions);
        if (!modificationResult.shouldApply()) {
            List errorStrings = modificationResult.reply().exclusionResults().stream().filter(r -> r.apiErrorOptional().isPresent()).map(e -> String.format("%s for broker %d, error %s", e.opType(), e.brokerId(), e.apiErrorOptional().get())).collect(Collectors.toList());
            this.log.info("Will not apply replica exclusions {} due to {} errors ({})", new Object[]{requestedExclusions, errorStrings.size(), errorStrings});
            return ControllerResult.of(Collections.emptyList(), modificationResult.reply());
        }
        this.log.info("Applying {} replica exclusion operations ({})", (Object)requestedExclusions.size(), requestedExclusions.stream().map(e -> String.format("Broker %d -> %s (reason: %s)", e.brokerId(), e.opType(), e.reason())).collect(Collectors.toList()));
        return ControllerResult.of(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)this.exclusionRecord(modificationResult.modifiedExclusions().entrySet()), 0)), modificationResult.reply());
    }

    public ControllerResult<AlterBrokerHealthResponseData> processAlterBrokerHealth(AlterBrokerHealthRequestData request, double maxDemotedBrokersPercentage) {
        if (!this.featureControl.metadataVersion().isSettingBrokerHealthSupported()) {
            throw new UnsupportedVersionException("Alter broker health not supported in version " + this.featureControl.metadataVersion().confluentRelease());
        }
        BrokerComponent componentCode = BrokerComponent.forId((byte)request.componentCode());
        ComponentHealthStatus desiredStatus = ComponentHealthStatus.forId((byte)request.statusCode());
        String reason = request.reason();
        if (desiredStatus == ComponentHealthStatus.DEGRADED && !request.force()) {
            HashSet<Integer> demotedBrokers = new HashSet<Integer>(this.activeBrokerComponentDegradations().keySet());
            demotedBrokers.addAll(Optional.ofNullable(request.brokerIds()).orElseGet(Collections::emptyList));
            int desiredNumBrokersDemoted = demotedBrokers.size();
            double numBrokersThatCanBeDemoted = Math.max(1.0, maxDemotedBrokersPercentage / 100.0 * (double)this.liveBrokers().size());
            if ((double)desiredNumBrokersDemoted > numBrokersThatCanBeDemoted || this.liveBrokers().size() < 3) {
                String errorMessage = String.format("Demoting brokers %s would lead to total %s brokers demoted and exceed the configured limit percentage of %s", request.brokerIds(), desiredNumBrokersDemoted, maxDemotedBrokersPercentage);
                this.log.error("AlterBrokerHealth request {} rejected: {}", (Object)request, (Object)errorMessage);
                throw new DemotionLimitReachedException(errorMessage);
            }
        }
        ArrayList<AlterBrokerHealthResponseData.BrokerHealthStatusResult> healthStatusResults = new ArrayList<AlterBrokerHealthResponseData.BrokerHealthStatusResult>();
        BoundedList brokerChangeRecords = BoundedList.newArrayBacked((int)10000);
        HashSet requestBrokerIds = new HashSet(request.brokerIds());
        Iterator iterator = requestBrokerIds.iterator();
        while (iterator.hasNext()) {
            BrokerRegistrationChangeRecord changeRecord;
            ArrayList<DegradedBrokerHealthState> updatedBrokerDegradedStates;
            int brokerId = (Integer)iterator.next();
            DegradedBrokerHealthState degradedBrokerHealthState = new DegradedBrokerHealthState(reason, componentCode);
            AlterBrokerHealthResponseData.BrokerHealthStatusResult result = new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(brokerId).setComponentCode(componentCode.id()).setStatusCode(desiredStatus.id());
            healthStatusResults.add(result);
            BrokerRegistration brokerRegistration = this.registration(brokerId);
            if (brokerRegistration == null) {
                throw new InvalidRequestException(String.format("Invalid brokerId: %s. Only broker IDs of registered brokers are valid.", brokerId));
            }
            Set<DegradedBrokerHealthState> currentBrokerDegradedStates = brokerRegistration.degradedComponents();
            if (desiredStatus == ComponentHealthStatus.DEGRADED) {
                if (!currentBrokerDegradedStates.contains(degradedBrokerHealthState)) {
                    updatedBrokerDegradedStates = new ArrayList<DegradedBrokerHealthState>(currentBrokerDegradedStates);
                    updatedBrokerDegradedStates.add(degradedBrokerHealthState);
                    changeRecord = this.createRegistrationChangeRecordForDegradedHealth(this.brokerRegistrations().get(brokerId), updatedBrokerDegradedStates);
                    brokerChangeRecords.add(new ApiMessageAndVersion((ApiMessage)changeRecord, this.featureControl.metadataVersion().brokerRegistrationChangeRecordVersion()));
                    continue;
                }
                this.log.debug("Attempted to mark already degraded broker component {} as unhealthy for broker {}", (Object)brokerId, (Object)componentCode);
                continue;
            }
            if (desiredStatus == ComponentHealthStatus.HEALTHY) {
                if (currentBrokerDegradedStates.contains(degradedBrokerHealthState)) {
                    updatedBrokerDegradedStates = new ArrayList<DegradedBrokerHealthState>(currentBrokerDegradedStates);
                    updatedBrokerDegradedStates.remove(degradedBrokerHealthState);
                    changeRecord = this.createRegistrationChangeRecordForDegradedHealth(this.brokerRegistrations().get(brokerId), updatedBrokerDegradedStates);
                    brokerChangeRecords.add(new ApiMessageAndVersion((ApiMessage)changeRecord, this.featureControl.metadataVersion().brokerRegistrationChangeRecordVersion()));
                    continue;
                }
                this.log.debug("Attempted to mark non-degraded broker component {} as healthy for broker {}", (Object)brokerId, (Object)componentCode);
                continue;
            }
            throw new InvalidRequestException("Invalid status " + desiredStatus + " in AlterBrokerHealth request " + request);
        }
        if (brokerChangeRecords.isEmpty()) {
            this.log.debug("No broker registration change records were created from no-op AlterBrokerHealth request {}", (Object)request);
        } else {
            this.log.info("Created broker registration change records from AlterBrokerHealth request {}: {}", (Object)request, (Object)brokerChangeRecords);
        }
        return ControllerResult.of((List<ApiMessageAndVersion>)brokerChangeRecords, new AlterBrokerHealthResponseData().setBrokerHealthStatusResults(healthStatusResults));
    }

    public void replay(RegisterBrokerRecord record, long offset) {
        Object endpoint;
        this.registerBrokerRecordOffsets.put((Object)record.brokerId(), (Object)offset);
        int brokerId = record.brokerId();
        ArrayList<Endpoint> listeners = new ArrayList<Endpoint>();
        Iterator iterator = record.endPoints().iterator();
        while (iterator.hasNext()) {
            endpoint = (RegisterBrokerRecord.BrokerEndpoint)iterator.next();
            listeners.add(new Endpoint(((RegisterBrokerRecord.BrokerEndpoint)endpoint).name(), SecurityProtocol.forId((short)((RegisterBrokerRecord.BrokerEndpoint)endpoint).securityProtocol()), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).host(), ((RegisterBrokerRecord.BrokerEndpoint)endpoint).port()));
        }
        HashMap<String, VersionRange> features = new HashMap<String, VersionRange>();
        endpoint = record.features().iterator();
        while (endpoint.hasNext()) {
            RegisterBrokerRecord.BrokerFeature feature = (RegisterBrokerRecord.BrokerFeature)endpoint.next();
            features.put(feature.name(), VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion()));
        }
        BrokerRegistration prevRegistration = (BrokerRegistration)this.brokerRegistrations.put((Object)brokerId, (Object)new BrokerRegistration(brokerId, record.brokerEpoch(), record.incarnationId(), listeners, features, Optional.ofNullable(record.rack()), record.fenced(), record.inControlledShutdown(), record.isMigratingZkBroker(), DegradedBrokerHealthState.fromRegisterBrokerRecord(record.degradedComponents())));
        if (this.heartbeatManager != null) {
            if (prevRegistration != null) {
                this.heartbeatManager.remove(brokerId);
            }
            this.heartbeatManager.register(brokerId, record.fenced());
        }
        if (prevRegistration == null) {
            this.log.info("Registered new broker: {}", (Object)record);
        } else if (prevRegistration.incarnationId().equals((Object)record.incarnationId())) {
            this.log.info("Re-registered broker incarnation: {}", (Object)record);
        } else {
            this.log.info("Re-registered broker id {}: {}", (Object)brokerId, (Object)record);
        }
    }

    public void replay(UnregisterBrokerRecord record) {
        this.registerBrokerRecordOffsets.remove((Object)record.brokerId());
        int brokerId = record.brokerId();
        BrokerRegistration registration = (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
        if (registration == null) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration found for that id", record));
        }
        if (registration.epoch() != record.brokerEpoch()) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration with that epoch found", record));
        }
        if (this.heartbeatManager != null) {
            this.heartbeatManager.remove(brokerId);
        }
        this.brokerRegistrations.remove((Object)brokerId);
        this.log.info("Unregistered broker: {}", (Object)record);
    }

    public void replay(BrokerReplicaExclusionRecord record) {
        Map<Integer, String> exclusionsInRecord = record.brokerExclusions().stream().collect(Collectors.toMap(BrokerReplicaExclusionRecord.BrokerReplicaExclusion::brokerId, BrokerReplicaExclusionRecord.BrokerReplicaExclusion::reason));
        HashMap<Integer, String> oldExclusions = new HashMap<Integer, String>((Map<Integer, String>)this.brokerReplicaExclusions);
        this.brokerReplicaExclusions.clear();
        this.brokerReplicaExclusions.putAll(exclusionsInRecord);
        this.controllerMetrics.setExcludedBrokerCount(this.brokerReplicaExclusions.size());
        this.log.info("Loaded new broker replica exclusions {} (old exclusions {})", new TreeMap<Integer, String>((Map<Integer, String>)this.brokerReplicaExclusions), new TreeMap<Integer, String>(oldExclusions));
    }

    public void replay(FenceBrokerRecord record) {
        this.replayRegistrationChange(record, record.id(), record.epoch(), BrokerRegistrationFencingChange.FENCE.asBoolean(), BrokerRegistrationInControlledShutdownChange.NONE.asBoolean(), Optional.empty());
    }

    public void replay(UnfenceBrokerRecord record) {
        this.replayRegistrationChange(record, record.id(), record.epoch(), BrokerRegistrationFencingChange.UNFENCE.asBoolean(), BrokerRegistrationInControlledShutdownChange.NONE.asBoolean(), Optional.empty());
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        BrokerRegistrationFencingChange fencingChange = BrokerRegistrationFencingChange.fromValue(record.fenced()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for fenced field: %x", record, record.fenced())));
        BrokerRegistrationInControlledShutdownChange inControlledShutdownChange = BrokerRegistrationInControlledShutdownChange.fromValue(record.inControlledShutdown()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for inControlledShutdown field: %x", record, record.inControlledShutdown())));
        Set healthStatusChanges = null;
        if (record.degradedComponents() != null) {
            healthStatusChanges = record.degradedComponents().stream().map(degradedComponent -> new DegradedBrokerHealthState(degradedComponent.reason(), BrokerComponent.forId((byte)degradedComponent.componentCode()))).collect(Collectors.toSet());
        }
        this.replayRegistrationChange(record, record.brokerId(), record.brokerEpoch(), fencingChange.asBoolean(), inControlledShutdownChange.asBoolean(), Optional.ofNullable(healthStatusChanges));
    }

    private void replayRegistrationChange(ApiMessage record, int brokerId, long brokerEpoch, Optional<Boolean> fencingChange, Optional<Boolean> inControlledShutdownChange, Optional<Set<DegradedBrokerHealthState>> brokerStatusChanges) {
        BrokerRegistration curRegistration = (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
        if (curRegistration == null) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration found for that id", record.toString()));
        }
        if (curRegistration.epoch() != brokerEpoch) {
            throw new RuntimeException(String.format("Unable to replay %s: no broker registration with that epoch found", record.toString()));
        }
        BrokerRegistration nextRegistration = curRegistration.cloneWith(fencingChange, inControlledShutdownChange, brokerStatusChanges);
        if (!curRegistration.equals(nextRegistration)) {
            this.brokerRegistrations.put((Object)brokerId, (Object)nextRegistration);
        } else {
            this.log.info("Ignoring no-op registration change {} for {}", (Object)record, (Object)curRegistration);
        }
        if (this.heartbeatManager != null) {
            this.heartbeatManager.register(brokerId, nextRegistration.fenced());
        }
        if (this.readyBrokersFuture.isPresent() && this.readyBrokersFuture.get().check()) {
            this.readyBrokersFuture.get().future.complete(null);
            this.readyBrokersFuture = Optional.empty();
        }
    }

    Iterator<UsableBroker> usableBrokers() {
        if (this.heartbeatManager == null) {
            throw new RuntimeException("ClusterControlManager is not active.");
        }
        return this.heartbeatManager.usableBrokers(id -> ((BrokerRegistration)this.brokerRegistrations.get(id)).rack(), this.brokerReplicaExclusions.keySet(), this.cellControl::getBrokerCellId);
    }

    public boolean isUnfenced(int brokerId) {
        BrokerRegistration registration = (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
        if (registration == null) {
            return false;
        }
        return !registration.fenced();
    }

    public BrokerRegistration registration(int brokerId) {
        return (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
    }

    public boolean inControlledShutdown(int brokerId) {
        BrokerRegistration registration = (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
        if (registration == null) {
            return false;
        }
        return registration.inControlledShutdown();
    }

    public boolean isActive(int brokerId) {
        BrokerRegistration registration = (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
        if (registration == null) {
            return false;
        }
        return !registration.inControlledShutdown() && !registration.fenced();
    }

    MetadataResponseData.MetadataResponseBrokerCollection unfencedBrokerEndpoints(ListenerName listenerName) {
        MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
        for (BrokerRegistration registration : this.brokerRegistrations.values()) {
            Endpoint endpoint;
            if (registration.fenced() || (endpoint = registration.listeners().get(listenerName.value())) == null) continue;
            MetadataResponseData.MetadataResponseBroker metadataResponseBroker = new MetadataResponseData.MetadataResponseBroker().setNodeId(registration.id()).setHost(endpoint.host()).setPort(endpoint.port());
            registration.rack().ifPresent(arg_0 -> ((MetadataResponseData.MetadataResponseBroker)metadataResponseBroker).setRack(arg_0));
            brokers.add((ImplicitLinkedHashCollection.Element)metadataResponseBroker);
        }
        return brokers;
    }

    BrokerHeartbeatManager heartbeatManager() {
        if (this.heartbeatManager == null) {
            throw new RuntimeException("ClusterControlManager is not active.");
        }
        return this.heartbeatManager;
    }

    public void checkBrokerEpoch(int brokerId, long brokerEpoch) {
        BrokerRegistration registration = (BrokerRegistration)this.brokerRegistrations.get((Object)brokerId);
        if (registration == null) {
            throw new StaleBrokerEpochException("No broker registration found for broker id " + brokerId);
        }
        if (registration.epoch() != brokerEpoch) {
            throw new StaleBrokerEpochException("Expected broker epoch " + registration.epoch() + ", but got broker epoch " + brokerEpoch);
        }
    }

    private BrokerRegistrationChangeRecord createRegistrationChangeRecordForDegradedHealth(BrokerRegistration currentRegistration, List<DegradedBrokerHealthState> updatedDegradedHealthStates) {
        List<BrokerRegistrationChangeRecord.DegradedComponent> degradedComponents = updatedDegradedHealthStates.stream().map(c -> new BrokerRegistrationChangeRecord.DegradedComponent().setComponentCode(c.component().id()).setReason(c.reason())).collect(Collectors.toList());
        return new BrokerRegistrationChangeRecord().setBrokerId(currentRegistration.id()).setBrokerEpoch(currentRegistration.epoch()).setDegradedComponents(degradedComponents);
    }

    public void addReadyBrokersFuture(CompletableFuture<Void> future, int minBrokers) {
        this.readyBrokersFuture = Optional.of(new ReadyBrokersFuture(future, minBrokers));
        if (this.readyBrokersFuture.get().check()) {
            this.readyBrokersFuture.get().future.complete(null);
            this.readyBrokersFuture = Optional.empty();
        }
    }

    private BrokerReplicaExclusionRecord exclusionRecord(Set<Map.Entry<Integer, String>> exclusions) {
        return new BrokerReplicaExclusionRecord().setBrokerExclusions(exclusions.stream().map(pair -> new BrokerReplicaExclusionRecord.BrokerReplicaExclusion().setBrokerId((Integer)pair.getKey()).setReason((String)pair.getValue())).collect(Collectors.toList()));
    }

    public Set<Integer> liveBrokers() {
        return this.brokerRegistrations.values().stream().filter(e -> this.isActive(e.id())).map(registration -> registration.id()).collect(Collectors.toSet());
    }

    class ReadyBrokersFuture {
        private final CompletableFuture<Void> future;
        private final int minBrokers;

        ReadyBrokersFuture(CompletableFuture<Void> future, int minBrokers) {
            this.future = future;
            this.minBrokers = minBrokers;
        }

        boolean check() {
            int numUnfenced = 0;
            for (BrokerRegistration registration : ClusterControlManager.this.brokerRegistrations.values()) {
                if (!registration.fenced()) {
                    ++numUnfenced;
                }
                if (numUnfenced < this.minBrokers) continue;
                return true;
            }
            return false;
        }
    }

    static class Builder {
        private LogContext logContext = null;
        private String clusterId = null;
        private Time time = Time.SYSTEM;
        private SnapshotRegistry snapshotRegistry = null;
        private long sessionTimeoutNs = DEFAULT_SESSION_TIMEOUT_NS;
        private ReplicaPlacer replicaPlacer = null;
        private ControllerMetrics controllerMetrics = null;
        private FeatureControlManager featureControl = null;
        private boolean zkMigrationEnabled = false;
        private CellControlManager cellControl = null;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder setSessionTimeoutNs(long sessionTimeoutNs) {
            this.sessionTimeoutNs = sessionTimeoutNs;
            return this;
        }

        Builder setReplicaPlacer(ReplicaPlacer replicaPlacer) {
            this.replicaPlacer = replicaPlacer;
            return this;
        }

        Builder setControllerMetrics(ControllerMetrics controllerMetrics) {
            this.controllerMetrics = controllerMetrics;
            return this;
        }

        Builder setFeatureControlManager(FeatureControlManager featureControl) {
            this.featureControl = featureControl;
            return this;
        }

        Builder setZkMigrationEnabled(boolean zkMigrationEnabled) {
            this.zkMigrationEnabled = zkMigrationEnabled;
            return this;
        }

        Builder setCellControlManager(CellControlManager cellControl) {
            this.cellControl = cellControl;
            return this;
        }

        ClusterControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.clusterId == null) {
                this.clusterId = Uuid.randomUuid().toString();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.replicaPlacer == null) {
                this.replicaPlacer = new StripedReplicaPlacer(new Random());
            }
            if (this.controllerMetrics == null) {
                throw new RuntimeException("You must specify ControllerMetrics");
            }
            if (this.featureControl == null) {
                throw new RuntimeException("You must specify FeatureControlManager");
            }
            if (this.cellControl == null) {
                this.cellControl = new CellControlManager(new LogContext(), this.time, this.snapshotRegistry, this.featureControl, new Random(), 15, 6, 15, true);
            }
            return new ClusterControlManager(this.logContext, this.clusterId, this.time, this.snapshotRegistry, this.sessionTimeoutNs, this.replicaPlacer, this.controllerMetrics, this.featureControl, this.zkMigrationEnabled, this.cellControl);
        }
    }
}

