/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerRegistrationFencingChange;
import org.apache.kafka.metadata.BrokerRegistrationInControlledShutdownChange;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.server.common.MetadataVersion;

public final class ClusterDelta {
    private final ClusterImage image;
    private final HashMap<Integer, Optional<BrokerRegistration>> changedBrokers = new HashMap();

    public ClusterDelta(ClusterImage image) {
        this.image = image;
    }

    public HashMap<Integer, Optional<BrokerRegistration>> changedBrokers() {
        return this.changedBrokers;
    }

    private Map<Integer, Set<DegradedBrokerHealthState>> filterDegradations(UpdatedDegradations<BrokerRegistration> updatedDegradations) {
        HashMap<Integer, Set<DegradedBrokerHealthState>> degradationsAddedOrRemoved = new HashMap<Integer, Set<DegradedBrokerHealthState>>();
        for (Integer brokerId : this.changedBrokers.keySet()) {
            Optional<BrokerRegistration> newRegistration = this.changedBrokers.get(brokerId);
            Optional<BrokerRegistration> oldRegistration = Optional.ofNullable(this.image.broker(brokerId));
            Set<DegradedBrokerHealthState> degradationsDiff = updatedDegradations.apply(oldRegistration, newRegistration);
            if (degradationsDiff.isEmpty()) continue;
            degradationsAddedOrRemoved.put(brokerId, degradationsDiff);
        }
        return degradationsAddedOrRemoved;
    }

    public BrokerRegistration broker(int nodeId) {
        Optional<BrokerRegistration> result = this.changedBrokers.get(nodeId);
        if (result != null) {
            return result.orElse(null);
        }
        return this.image.broker(nodeId);
    }

    private boolean isBrokerAvailable(Optional<BrokerRegistration> registration) {
        return registration.isPresent() && !registration.get().fenced();
    }

    private boolean isBrokerDegraded(Optional<BrokerRegistration> registration) {
        return registration.isPresent() && !registration.get().degradedComponents().isEmpty();
    }

    public List<BrokerRegistration> newBrokers() {
        ArrayList<BrokerRegistration> newBrokerList = new ArrayList<BrokerRegistration>();
        for (Optional<BrokerRegistration> newRegistration : this.changedBrokers.values()) {
            Optional<BrokerRegistration> oldRegistration;
            if (!this.isBrokerAvailable(newRegistration) || this.isBrokerAvailable(oldRegistration = Optional.ofNullable(this.image.broker(newRegistration.get().id())))) continue;
            newBrokerList.add(newRegistration.get());
        }
        return newBrokerList;
    }

    public Set<Integer> removedBrokers() {
        HashSet<Integer> removedBrokerSet = new HashSet<Integer>();
        for (Map.Entry<Integer, Optional<BrokerRegistration>> entry : this.changedBrokers.entrySet()) {
            Optional<BrokerRegistration> newRegistration = entry.getValue();
            if (this.isBrokerAvailable(newRegistration) || this.image.broker(entry.getKey()) == null) continue;
            removedBrokerSet.add(entry.getKey());
        }
        return removedBrokerSet;
    }

    public Set<Integer> newlyDegradedBrokers() {
        DegradedBrokerFilter<BrokerRegistration> newlyDegradedFilter = (oldRegistration, newRegistration) -> this.isBrokerDegraded(newRegistration) && !this.isBrokerDegraded(oldRegistration);
        return this.filterRegisteredBrokers(newlyDegradedFilter);
    }

    public Set<Integer> newlyRecoveredBrokers() {
        DegradedBrokerFilter<BrokerRegistration> newlyRecoveredFilter = (oldRegistration, newRegistration) -> this.isBrokerDegraded(oldRegistration) && !this.isBrokerDegraded(newRegistration);
        return this.filterRegisteredBrokers(newlyRecoveredFilter);
    }

    private Set<Integer> filterRegisteredBrokers(DegradedBrokerFilter<BrokerRegistration> filter) {
        HashSet<Integer> filteredBrokers = new HashSet<Integer>();
        for (Integer brokerId : this.changedBrokers.keySet()) {
            Optional<BrokerRegistration> newRegistration = this.changedBrokers.get(brokerId);
            Optional<BrokerRegistration> oldRegistration = Optional.ofNullable(this.image.broker(brokerId));
            if (!filter.apply(oldRegistration, newRegistration)) continue;
            filteredBrokers.add(brokerId);
        }
        return filteredBrokers;
    }

    public void finishSnapshot() {
        for (Integer brokerId : this.image.brokers().keySet()) {
            if (this.changedBrokers.containsKey(brokerId)) continue;
            this.changedBrokers.put(brokerId, Optional.empty());
        }
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public void replay(RegisterBrokerRecord record) {
        BrokerRegistration broker = BrokerRegistration.fromRecord(record);
        this.changedBrokers.put(broker.id(), Optional.of(broker));
    }

    public void replay(UnregisterBrokerRecord record) {
        this.changedBrokers.put(record.brokerId(), Optional.empty());
    }

    private BrokerRegistration getBrokerOrThrow(int brokerId, long epoch, String action) {
        BrokerRegistration broker = this.broker(brokerId);
        if (broker == null) {
            throw new IllegalStateException("Tried to " + action + " broker " + brokerId + ", but that broker was not registered.");
        }
        if (broker.epoch() != epoch) {
            throw new IllegalStateException("Tried to " + action + " broker " + brokerId + ", but the given epoch, " + epoch + ", did not match the current broker epoch, " + broker.epoch());
        }
        return broker;
    }

    public void replay(FenceBrokerRecord record) {
        BrokerRegistration curRegistration = this.getBrokerOrThrow(record.id(), record.epoch(), "fence");
        this.changedBrokers.put(record.id(), Optional.of(curRegistration.cloneWith(BrokerRegistrationFencingChange.FENCE.asBoolean(), Optional.empty(), Optional.empty())));
    }

    public void replay(UnfenceBrokerRecord record) {
        BrokerRegistration curRegistration = this.getBrokerOrThrow(record.id(), record.epoch(), "unfence");
        this.changedBrokers.put(record.id(), Optional.of(curRegistration.cloneWith(BrokerRegistrationFencingChange.UNFENCE.asBoolean(), Optional.empty(), Optional.empty())));
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        BrokerRegistration curRegistration = this.getBrokerOrThrow(record.brokerId(), record.brokerEpoch(), "change");
        BrokerRegistrationFencingChange fencingChange = BrokerRegistrationFencingChange.fromValue(record.fenced()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for fenced field: %d", record, record.fenced())));
        BrokerRegistrationInControlledShutdownChange inControlledShutdownChange = BrokerRegistrationInControlledShutdownChange.fromValue(record.inControlledShutdown()).orElseThrow(() -> new IllegalStateException(String.format("Unable to replay %s: unknown value for inControlledShutdown field: %d", record, record.inControlledShutdown())));
        Set<DegradedBrokerHealthState> healthStatusChanges = record.degradedComponents() != null ? DegradedBrokerHealthState.fromBrokerRegistrationChangeRecord(record.degradedComponents()) : null;
        BrokerRegistration nextRegistration = curRegistration.cloneWith(fencingChange.asBoolean(), inControlledShutdownChange.asBoolean(), Optional.ofNullable(healthStatusChanges));
        if (!curRegistration.equals(nextRegistration)) {
            this.changedBrokers.put(record.brokerId(), Optional.of(nextRegistration));
        }
    }

    public ClusterImage apply() {
        int nodeId;
        HashMap<Integer, BrokerRegistration> newBrokers = new HashMap<Integer, BrokerRegistration>(this.image.brokers().size());
        for (Map.Entry<Integer, BrokerRegistration> entry : this.image.brokers().entrySet()) {
            nodeId = entry.getKey();
            Optional<BrokerRegistration> change = this.changedBrokers.get(nodeId);
            if (change == null) {
                newBrokers.put(nodeId, entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newBrokers.put(nodeId, change.get());
        }
        for (Map.Entry<Integer, Object> entry : this.changedBrokers.entrySet()) {
            nodeId = entry.getKey();
            Optional brokerRegistration = (Optional)entry.getValue();
            if (newBrokers.containsKey(nodeId) || !brokerRegistration.isPresent()) continue;
            newBrokers.put(nodeId, (BrokerRegistration)brokerRegistration.get());
        }
        return new ClusterImage(newBrokers);
    }

    public String toString() {
        return "ClusterDelta(changedBrokers=" + this.changedBrokers + ')';
    }

    @FunctionalInterface
    static interface UpdatedDegradations<T> {
        public Set<DegradedBrokerHealthState> apply(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    static interface DegradedBrokerFilter<T> {
        public boolean apply(Optional<T> var1, Optional<T> var2);
    }
}

